/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.io;

import java.io.IOException;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.util.AdaptorRegistry;
import net.sf.tapestry.util.io.BooleanAdaptor;
import net.sf.tapestry.util.io.ByteAdaptor;
import net.sf.tapestry.util.io.CharacterAdaptor;
import net.sf.tapestry.util.io.ComponentAddressAdaptor;
import net.sf.tapestry.util.io.DoubleAdaptor;
import net.sf.tapestry.util.io.FloatAdaptor;
import net.sf.tapestry.util.io.ISqueezeAdaptor;
import net.sf.tapestry.util.io.IntegerAdaptor;
import net.sf.tapestry.util.io.LongAdaptor;
import net.sf.tapestry.util.io.SerializableAdaptor;
import net.sf.tapestry.util.io.ShortAdaptor;
import net.sf.tapestry.util.io.StringAdaptor;

public class DataSqueezer {
    private static final String NULL_PREFIX = "X";
    private static final char NULL_PREFIX_CH = 'X';
    private static final int ARRAY_SIZE = 90;
    private static final int FIRST_ADAPTOR_OFFSET = 33;
    private ISqueezeAdaptor[] _adaptorByPrefix = new ISqueezeAdaptor[90];
    private AdaptorRegistry _adaptors = new AdaptorRegistry();
    private IResourceResolver _resolver;

    public DataSqueezer(IResourceResolver resolver) {
        this(resolver, null);
    }

    public DataSqueezer(IResourceResolver resolver, ISqueezeAdaptor[] adaptors) {
        this._resolver = resolver;
        this.registerDefaultAdaptors();
        if (adaptors != null) {
            int i = 0;
            while (i < adaptors.length) {
                adaptors[i].register(this);
                ++i;
            }
        }
    }

    private void registerDefaultAdaptors() {
        new CharacterAdaptor().register(this);
        new StringAdaptor().register(this);
        new IntegerAdaptor().register(this);
        new DoubleAdaptor().register(this);
        new ByteAdaptor().register(this);
        new FloatAdaptor().register(this);
        new LongAdaptor().register(this);
        new ShortAdaptor().register(this);
        new BooleanAdaptor().register(this);
        new SerializableAdaptor().register(this);
        new ComponentAddressAdaptor().register(this);
    }

    public synchronized void register(String prefix, Class dataClass, ISqueezeAdaptor adaptor) {
        int prefixLength = prefix.length();
        if (prefixLength < 1) {
            throw new IllegalArgumentException(Tapestry.getString("DataSqueezer.short-prefix"));
        }
        if (dataClass == null) {
            throw new IllegalArgumentException(Tapestry.getString("DataSqueezer.null-class"));
        }
        if (adaptor == null) {
            throw new IllegalArgumentException(Tapestry.getString("DataSqueezer.null-adaptor"));
        }
        int i = 0;
        while (i < prefixLength) {
            char ch = prefix.charAt(i);
            if (ch < '!' | ch > 'z') {
                throw new IllegalArgumentException(Tapestry.getString("DataSqueezer.prefix-out-of-range"));
            }
            int offset = ch - 33;
            if (this._adaptorByPrefix[offset] != null) {
                throw new IllegalArgumentException(Tapestry.getString("DataSqueezer.adaptor-prefix-taken", prefix.substring(i, i)));
            }
            this._adaptorByPrefix[offset] = adaptor;
            ++i;
        }
        this._adaptors.register(dataClass, adaptor);
    }

    public String squeeze(Object data) throws IOException {
        if (data == null) {
            return NULL_PREFIX;
        }
        ISqueezeAdaptor adaptor = (ISqueezeAdaptor)this._adaptors.getAdaptor(data.getClass());
        return adaptor.squeeze(this, data);
    }

    public String[] squeeze(Object[] data) throws IOException {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = this.squeeze(data[i]);
            ++i;
        }
        return result;
    }

    public Object unsqueeze(String string) throws IOException {
        ISqueezeAdaptor adaptor = null;
        if (string.equals(NULL_PREFIX)) {
            return null;
        }
        char ch = string.charAt(0);
        int offset = string.charAt(0) - 33;
        if (offset >= 0 && offset < this._adaptorByPrefix.length) {
            adaptor = this._adaptorByPrefix[offset];
        }
        if (adaptor == null) {
            return string;
        }
        return adaptor.unsqueeze(this, string);
    }

    public Object[] unsqueeze(String[] strings) throws IOException {
        if (strings == null) {
            return null;
        }
        int length = strings.length;
        Object[] result = new Object[length];
        int i = 0;
        while (i < length) {
            result[i] = this.unsqueeze(strings[i]);
            ++i;
        }
        return result;
    }

    public boolean isPrefixRegistered(char prefix) {
        int offset = prefix - 33;
        if (prefix == 'X') {
            return true;
        }
        if (offset < 0 || offset >= this._adaptorByPrefix.length) {
            return false;
        }
        return this._adaptorByPrefix[offset] != null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataSqueezer[adaptors=<");
        buffer.append(this._adaptors.toString());
        buffer.append(">]");
        return buffer.toString();
    }

    public IResourceResolver getResolver() {
        return this._resolver;
    }
}

