/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.sf.tapestry.util.jdbc.IStatement;

public class ParameterizedStatement
implements IStatement {
    private String SQL;
    private PreparedStatement statement;
    private Object[] parameters;

    public ParameterizedStatement(String SQL, Connection connection, List parameters) throws SQLException {
        this.SQL = SQL;
        this.statement = connection.prepareStatement(SQL);
        this.setupParameters(parameters);
    }

    public ParameterizedStatement(String SQL, Connection connection, List parameters, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.SQL = SQL;
        this.statement = connection.prepareStatement(SQL, resultSetType, resultSetConcurrency);
        this.setupParameters(parameters);
    }

    private void setupParameters(List list) throws SQLException {
        this.parameters = list.toArray();
        int i = 0;
        while (i < this.parameters.length) {
            this.statement.setObject(i + 1, this.parameters[i]);
            ++i;
        }
    }

    public String getSQL() {
        return this.SQL;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void close() throws SQLException {
        this.statement.close();
        this.statement = null;
        this.SQL = null;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.statement.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.statement.executeUpdate();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("[SQL=\n<");
        buffer.append(this.SQL);
        buffer.append("\n>");
        int i = 0;
        while (i < this.parameters.length) {
            Object parameter = this.parameters[i];
            buffer.append(" ?");
            buffer.append(i + 1);
            buffer.append('=');
            if (parameter == null) {
                buffer.append("null");
            } else {
                buffer.append('(');
                buffer.append(parameter.getClass().getName());
                buffer.append(") ");
                buffer.append(parameter);
            }
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }
}

