/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.prop;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.util.prop.PropertyInfo;

public class PropertyFinder {
    private static Map _cache = new HashMap();

    public static synchronized PropertyInfo getPropertyInfo(Class beanClass, String propertyName) {
        Map beanClassMap = (Map)_cache.get(beanClass);
        if (beanClassMap == null) {
            beanClassMap = PropertyFinder.buildBeanClassMap(beanClass);
            _cache.put(beanClass, beanClassMap);
        }
        return (PropertyInfo)beanClassMap.get(propertyName);
    }

    private static Map buildBeanClassMap(Class beanClass) {
        HashMap<String, PropertyInfo> result = new HashMap<String, PropertyInfo>();
        BeanInfo bi = null;
        try {
            bi = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("PropertyFinder.unable-to-introspect-class", beanClass.getName()), ex);
        }
        PropertyDescriptor[] pd = bi.getPropertyDescriptors();
        int i = 0;
        while (i < pd.length) {
            PropertyDescriptor d = pd[i];
            PropertyInfo info = new PropertyInfo(d.getName(), d.getPropertyType(), d.getReadMethod() != null, d.getWriteMethod() != null);
            result.put(d.getName(), info);
            ++i;
        }
        return result;
    }
}

