/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.prop;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlException;

public class PublicBeanPropertyAccessor
extends ObjectPropertyAccessor {
    private static final Map EMPTY_MAP = new HashMap();
    private Map _cache = new HashMap();

    private synchronized Field findField(Class beanClass, String fieldName) {
        Map classMap = (Map)this._cache.get(beanClass);
        if (classMap == null) {
            classMap = this.constructClassMap(beanClass);
            this._cache.put(beanClass, classMap);
        }
        return (Field)classMap.get(fieldName);
    }

    private Map constructClassMap(Class beanClass) {
        Field[] fields = beanClass.getFields();
        if (fields.length == 0) {
            return EMPTY_MAP;
        }
        HashMap<String, Field> result = new HashMap<String, Field>();
        int i = 0;
        while (i < fields.length) {
            result.put(fields[i].getName(), fields[i]);
            ++i;
        }
        return result;
    }

    public Object getProperty(Map context, Object target, Object name) throws OgnlException {
        Field f = this.findField(target.getClass(), (String)name);
        if (f != null) {
            try {
                return f.get(target);
            }
            catch (IllegalAccessException ex) {
                throw new OgnlException(ex.getMessage(), (Throwable)ex);
            }
        }
        return super.getProperty(context, target, name);
    }

    public boolean hasGetProperty(Map context, Object target, Object oname) throws OgnlException {
        Field f = this.findField(target.getClass(), (String)oname);
        if (f != null) {
            return true;
        }
        return super.hasGetProperty(context, target, oname);
    }

    public boolean hasSetProperty(Map context, Object target, Object oname) throws OgnlException {
        Field f = this.findField(target.getClass(), (String)oname);
        if (f != null) {
            return true;
        }
        return super.hasSetProperty(context, target, oname);
    }

    public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
        Field f = this.findField(target.getClass(), (String)name);
        if (f != null) {
            try {
                f.set(target, value);
            }
            catch (IllegalAccessException ex) {
                throw new OgnlException(ex.getMessage(), (Throwable)ex);
            }
        }
        super.setProperty(context, target, name, value);
    }
}

