/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.valid;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IScript;
import net.sf.tapestry.IScriptSource;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.ScriptException;
import net.sf.tapestry.ScriptSession;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.form.FormEventType;
import net.sf.tapestry.html.Body;
import net.sf.tapestry.valid.IField;
import net.sf.tapestry.valid.IValidator;
import net.sf.tapestry.valid.ValidationConstraint;
import net.sf.tapestry.valid.ValidatorException;

public abstract class BaseValidator
implements IValidator {
    public static final String FIELD_SYMBOL = "field";
    public static final String VALIDATOR_SYMBOL = "validator";
    public static final String FORM_SYMBOL = "form";
    public static final String FUNCTION_SYMBOL = "function";
    private boolean _required;
    private boolean _clientScriptingEnabled = false;

    public BaseValidator() {
    }

    protected BaseValidator(boolean required) {
        this._required = required;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    protected String getString(String key, Locale locale, Object[] args) {
        ResourceBundle strings = ResourceBundle.getBundle("net.sf.tapestry.valid.ValidationStrings", locale);
        String pattern = strings.getString(key);
        return MessageFormat.format(pattern, args);
    }

    protected String getString(String key, Locale locale, Object arg) {
        return this.getString(key, locale, new Object[]{arg});
    }

    protected String getString(String key, Locale locale, Object arg1, Object arg2) {
        return this.getString(key, locale, new Object[]{arg1, arg2});
    }

    protected boolean checkRequired(IField field, String value) throws ValidatorException {
        boolean isNull = Tapestry.isNull(value);
        if (this._required && isNull) {
            throw new ValidatorException(this.getString("field-is-required", field.getPage().getLocale(), field.getDisplayName()), ValidationConstraint.REQUIRED, null);
        }
        return isNull;
    }

    public void renderValidatorContribution(IField field, IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
    }

    protected void processValidatorScript(String scriptPath, IRequestCycle cycle, IField field, Map symbols) throws RequestCycleException {
        ScriptSession session;
        IEngine engine = field.getPage().getEngine();
        IScriptSource source = engine.getScriptSource();
        IForm form = field.getForm();
        Map finalSymbols = symbols == null ? new HashMap() : symbols;
        finalSymbols.put(FIELD_SYMBOL, field);
        finalSymbols.put(FORM_SYMBOL, form);
        finalSymbols.put(VALIDATOR_SYMBOL, this);
        IScript script = source.getScript(scriptPath);
        try {
            session = script.execute(finalSymbols);
        }
        catch (ScriptException ex) {
            throw new RequestCycleException(ex.getMessage(), field, ex);
        }
        Body body = Body.get(cycle);
        body.process(session);
        String functionName = (String)finalSymbols.get(FUNCTION_SYMBOL);
        form.addEventHandler(FormEventType.SUBMIT, functionName);
    }

    public boolean isClientScriptingEnabled() {
        return this._clientScriptingEnabled;
    }

    public void setClientScriptingEnabled(boolean clientScriptingEnabled) {
        this._clientScriptingEnabled = clientScriptingEnabled;
    }

    public abstract Object toObject(IField var1, String var2) throws ValidatorException;

    public abstract String toString(IField var1, Object var2);
}

