/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.valid;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.valid.BaseValidator;
import net.sf.tapestry.valid.IField;
import net.sf.tapestry.valid.ValidationConstraint;
import net.sf.tapestry.valid.ValidatorException;

public class DateValidator
extends BaseValidator {
    private DateFormat _format;
    private String _displayFormat;
    private Date _minimum;
    private Date _maximum;
    private Calendar _calendar;
    private String _scriptPath = "/net/sf/tapestry/valid/DateValidator.script";
    private static DateFormat defaultDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private static String defaultDateDisplayFormat = "MM/DD/YYYY";

    public void setFormat(DateFormat value) {
        this._format = value;
    }

    public DateFormat getFormat() {
        return this._format;
    }

    private DateFormat getEffectiveFormat() {
        if (this._format == null) {
            return defaultDateFormat;
        }
        return this._format;
    }

    public String getDisplayFormat() {
        return this._displayFormat;
    }

    public void setDisplayFormat(String value) {
        this._displayFormat = value;
    }

    private String getEffectiveDisplayFormat() {
        if (this._displayFormat == null) {
            return defaultDateDisplayFormat;
        }
        return this._displayFormat;
    }

    public String toString(IField file, Object value) {
        DateFormat format;
        if (value == null) {
            return null;
        }
        Date date = (Date)value;
        DateFormat dateFormat = format = this.getEffectiveFormat();
        synchronized (dateFormat) {
            String string = format.format(date);
            return string;
        }
    }

    public Object toObject(IField field, String value) throws ValidatorException {
        String errorMessage;
        Date result;
        if (this.checkRequired(field, value)) {
            return null;
        }
        DateFormat format = this.getEffectiveFormat();
        try {
            DateFormat dateFormat = format;
            synchronized (dateFormat) {
                result = format.parse(value);
            }
            if (this._calendar == null) {
                this._calendar = new GregorianCalendar();
            }
            this._calendar.setTime(result);
            if (this._calendar.get(1) < 1000) {
                result = null;
            }
        }
        catch (ParseException ex) {
            result = null;
        }
        if (result == null) {
            errorMessage = this.getString("invalid-date-format", field.getPage().getLocale(), field.getDisplayName(), this.getEffectiveDisplayFormat());
            throw new ValidatorException(errorMessage, ValidationConstraint.DATE_FORMAT, value);
        }
        if (this._minimum != null && this._minimum.compareTo(result) > 0) {
            errorMessage = this.getString("date-too-early", field.getPage().getLocale(), field.getDisplayName(), format.format(this._minimum));
            throw new ValidatorException(errorMessage, ValidationConstraint.TOO_SMALL, value);
        }
        if (this._maximum != null && this._maximum.compareTo(result) < 0) {
            errorMessage = this.getString("date-too-late", field.getPage().getLocale(), field.getDisplayName(), format.format(this._maximum));
            throw new ValidatorException(errorMessage, ValidationConstraint.TOO_LARGE, value);
        }
        return result;
    }

    public Date getMaximum() {
        return this._maximum;
    }

    public void setMaximum(Date maximum) {
        this._maximum = maximum;
    }

    public Date getMinimum() {
        return this._minimum;
    }

    public void setMinimum(Date minimum) {
        this._minimum = minimum;
    }

    public void renderValidatorContribution(IField field, IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (!this.isClientScriptingEnabled() || !this.isRequired()) {
            return;
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        Locale locale = field.getPage().getLocale();
        String displayName = field.getDisplayName();
        symbols.put("requiredMessage", this.getString("field-is-required", locale, displayName));
        this.processValidatorScript(this._scriptPath, cycle, field, symbols);
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }
}

