/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Vector;
import org.hsql.Database;
import org.hsql.Table;
import org.hsql.Trace;
import org.hsql.Transaction;
import org.hsql.User;

class Channel {
    private Database dDatabase;
    private User uUser;
    private Vector tTransaction;
    private boolean bAutoCommit;
    private boolean bNestedTransaction;
    private boolean bNestedOldAutoCommit;
    private int iNestedOldTransIndex;
    private boolean bReadOnly;
    private int iMaxRows;
    private int iLastIdentity;
    private boolean bClosed;
    private int iId;

    public void finalize() throws SQLException {
        this.disconnect();
    }

    int getId() {
        return this.iId;
    }

    void disconnect() throws SQLException {
        if (this.bClosed) {
            return;
        }
        this.rollback();
        this.dDatabase = null;
        this.uUser = null;
        this.tTransaction = null;
        this.bClosed = true;
    }

    boolean isClosed() {
        return this.bClosed;
    }

    void setLastIdentity(int n) {
        this.iLastIdentity = n;
    }

    int getLastIdentity() {
        return this.iLastIdentity;
    }

    Database getDatabase() {
        return this.dDatabase;
    }

    String getUsername() {
        return this.uUser.getName();
    }

    void setUser(User user) {
        this.uUser = user;
    }

    void checkAdmin() throws SQLException {
        this.uUser.checkAdmin();
    }

    void check(String string, int n) throws SQLException {
        this.uUser.check(string, n);
    }

    void checkReadWrite() throws SQLException {
        Trace.check(!this.bReadOnly, 30);
    }

    void setPassword(String string) {
        this.uUser.setPassword(string);
    }

    void addTransactionDelete(Table table, Object[] objectArray) throws SQLException {
        if (!this.bAutoCommit) {
            Transaction transaction = new Transaction(true, table, objectArray);
            this.tTransaction.addElement(transaction);
        }
    }

    void addTransactionInsert(Table table, Object[] objectArray) throws SQLException {
        if (!this.bAutoCommit) {
            Transaction transaction = new Transaction(false, table, objectArray);
            this.tTransaction.addElement(transaction);
        }
    }

    void setAutoCommit(boolean bl) throws SQLException {
        this.commit();
        this.bAutoCommit = bl;
    }

    void commit() throws SQLException {
        this.tTransaction.removeAllElements();
    }

    void rollback() throws SQLException {
        int n = this.tTransaction.size() - 1;
        while (n >= 0) {
            Transaction transaction = (Transaction)this.tTransaction.elementAt(n);
            transaction.rollback();
            --n;
        }
        this.tTransaction.removeAllElements();
    }

    void beginNestedTransaction() throws SQLException {
        Trace.assert(!this.bNestedTransaction, "beginNestedTransaction");
        this.bNestedOldAutoCommit = this.bAutoCommit;
        this.bAutoCommit = false;
        this.iNestedOldTransIndex = this.tTransaction.size();
        this.bNestedTransaction = true;
    }

    void endNestedTransaction(boolean bl) throws SQLException {
        Trace.assert(this.bNestedTransaction, "endNestedTransaction");
        int n = this.tTransaction.size() - 1;
        if (bl) {
            while (n >= this.iNestedOldTransIndex) {
                Transaction transaction = (Transaction)this.tTransaction.elementAt(n);
                transaction.rollback();
                --n;
            }
        }
        this.bNestedTransaction = false;
        this.bAutoCommit = this.bNestedOldAutoCommit;
        if (this.bAutoCommit) {
            this.tTransaction.setSize(this.iNestedOldTransIndex);
        }
    }

    void setReadOnly(boolean bl) {
        this.bReadOnly = bl;
    }

    boolean isReadOnly() {
        return this.bReadOnly;
    }

    void setMaxRows(int n) {
        this.iMaxRows = n;
    }

    int getMaxRows() {
        return this.iMaxRows;
    }

    boolean isNestedTransaction() {
        return this.bNestedTransaction;
    }

    Channel(Channel channel, int n) {
        this(channel.dDatabase, channel.uUser, true, channel.bReadOnly, n);
    }

    Channel(Database database, User user, boolean bl, boolean bl2, int n) {
        this.iId = n;
        this.dDatabase = database;
        this.uUser = user;
        this.tTransaction = new Vector();
        this.bAutoCommit = bl;
        this.bReadOnly = bl2;
    }
}

