/*
 * Decompiled with CFR 0.152.
 */
package tyrex.security.cert;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import tyrex.util.Logger;

public final class X509CertificateLoginModule
implements LoginModule {
    public static final String OPTION_KEY_STORE = "key-store";
    public static final String OPTION_TRUSTED_CERTS = "trusted-certs";
    public static final String OPTION_CRL_CLASS = "crl-class";
    public static final String OPTION_LOG_ERRORS = "log-errors";
    private static final String DEFAULT_KEY_STORE = "JKS";
    private static final String MODULE_NAME = "X509CertificateLoginModule";
    private Subject _subject;
    private Vector _subjectDN;
    private Hashtable _trusted;
    private X509CRL _crl;
    static /* synthetic */ Class class$java$security$cert$X509Certificate;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this._subject = subject;
        Map map3 = map;
        synchronized (map3) {
            block24: {
                Object object;
                block23: {
                    Object object2;
                    String string;
                    KeyStore keyStore;
                    String string2 = (String)map2.get(OPTION_KEY_STORE);
                    if (string2 == null) {
                        string2 = DEFAULT_KEY_STORE;
                    }
                    if ((keyStore = (KeyStore)map.get("key-store-" + string2)) == null) {
                        try {
                            keyStore = KeyStore.getInstance(string2);
                            map.put("key-store-" + string2, keyStore);
                        }
                        catch (KeyStoreException keyStoreException) {
                            if (map2.get(OPTION_LOG_ERRORS) != null) {
                                Logger.security.error((Object)("X509CertificateLoginModule error: key store " + string2 + " could not be loaded"), (Throwable)keyStoreException);
                            }
                            this._trusted = new Hashtable();
                            return;
                        }
                    }
                    if ((string = (String)map2.get(OPTION_TRUSTED_CERTS)) != null) {
                        this._trusted = (Hashtable)map.get("trusted-certs-" + string2 + "-" + string);
                        if (this._trusted == null) {
                            this._trusted = new Hashtable();
                            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
                            while (stringTokenizer.hasMoreTokens()) {
                                object = stringTokenizer.nextToken();
                                try {
                                    if (!keyStore.isCertificateEntry((String)object) || (object2 = keyStore.getCertificate((String)object)) == null || !(object2 instanceof X509Certificate)) continue;
                                    this._trusted.put(((X509Certificate)object2).getIssuerDN(), object2);
                                }
                                catch (KeyStoreException keyStoreException) {
                                    if (map2.get(OPTION_LOG_ERRORS) != null) {
                                        Logger.security.error((Object)("X509CertificateLoginModule error: error accessing key store " + string2 + " could not be loaded"), (Throwable)keyStoreException);
                                    }
                                    return;
                                }
                            }
                            map.put("trusted-certs-" + string2 + "-" + string, this._trusted);
                        }
                    } else {
                        this._trusted = (Hashtable)map.get("trusted-certs-" + string2 + "-all");
                        if (this._trusted == null) {
                            try {
                                this._trusted = new Hashtable();
                                object = keyStore.aliases();
                                while (object.hasMoreElements()) {
                                    Certificate certificate;
                                    object2 = (String)object.nextElement();
                                    if (!keyStore.isCertificateEntry((String)object2) || (certificate = keyStore.getCertificate((String)object2)) == null || !(certificate instanceof X509Certificate)) continue;
                                    this._trusted.put(((X509Certificate)certificate).getIssuerDN(), certificate);
                                }
                                map.put("trusted-certs-" + string2 + "-all", this._trusted);
                            }
                            catch (KeyStoreException keyStoreException) {
                                if (map2.get(OPTION_LOG_ERRORS) == null) break block23;
                                Logger.security.error((Object)("X509CertificateLoginModule error: error accessing key store " + string2 + " could not be loaded"), (Throwable)keyStoreException);
                            }
                        }
                    }
                }
                if ((object = (String)map2.get(OPTION_CRL_CLASS)) != null) {
                    this._crl = (X509CRL)map.get("crl-" + (String)object);
                    if (this._crl == null) {
                        try {
                            this._crl = (X509CRL)Class.forName((String)object).newInstance();
                            map.put("crl-" + (String)object, this._crl);
                        }
                        catch (Exception exception) {
                            if (map2.get(OPTION_LOG_ERRORS) == null) break block24;
                            Logger.security.error((Object)("X509CertificateLoginModule error: error loading CRL class " + (String)object), (Throwable)exception);
                        }
                    }
                }
            }
        }
    }

    public boolean login() throws LoginException {
        if (this._subject == null) {
            return false;
        }
        Set set = this._subject.getPublicCredentials(class$java$security$cert$X509Certificate == null ? (class$java$security$cert$X509Certificate = X509CertificateLoginModule.class$("java.security.cert.X509Certificate")) : class$java$security$cert$X509Certificate);
        if (set.size() == 0) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            X509Certificate x509Certificate2 = (X509Certificate)this._trusted.get(x509Certificate.getIssuerDN());
            if (x509Certificate2 == null) continue;
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateException certificateException) {
                throw new LoginException("The certificate for " + x509Certificate.getSubjectDN().getName() + " has expired");
            }
            try {
                x509Certificate.verify(x509Certificate2.getPublicKey());
            }
            catch (CertificateException certificateException) {
                throw new LoginException("The certificate for " + x509Certificate.getSubjectDN().getName() + " was not signed by " + x509Certificate2.getSubjectDN().getName());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new LoginException("Certificate verification error: " + generalSecurityException.toString());
            }
            if (this._crl != null && this._crl.isRevoked(x509Certificate)) {
                throw new LoginException("The certificate for " + x509Certificate.getSubjectDN().getName() + " has been revoked");
            }
            if (this._subjectDN == null) {
                this._subjectDN = new Vector();
            }
            this._subjectDN.add(x509Certificate.getSubjectDN());
        }
        return this._subjectDN != null;
    }

    public boolean commit() throws LoginException {
        if (this._subjectDN != null) {
            this._subject.getPrincipals().add((Principal)((Object)this._subjectDN));
            return true;
        }
        return false;
    }

    public boolean abort() throws LoginException {
        if (this._subjectDN != null) {
            this._subjectDN.clear();
            return true;
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (this._subjectDN != null) {
            this._subject.getPrincipals().remove(this._subjectDN);
            this._subjectDN.clear();
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

