/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat4;

import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Service;
import org.apache.catalina.net.DefaultServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.tomcat4.CoyoteAdapter;
import org.apache.coyote.tomcat4.CoyoteRequest;
import org.apache.coyote.tomcat4.CoyoteResponse;
import org.apache.coyote.tomcat4.CoyoteServerSocketFactory;
import org.apache.tomcat.util.IntrospectionUtils;

public final class CoyoteConnector
implements Connector,
Lifecycle,
MBeanRegistration {
    private Service service = null;
    private int acceptCount = 10;
    private String address = null;
    private boolean allowTrace = false;
    private int bufferSize = 2048;
    protected Container container = null;
    private Vector created = new Vector();
    private int curProcessors = 0;
    private int debug = 0;
    private boolean enableLookups = false;
    private ServerSocketFactory factory = null;
    private static final String info = "org.apache.coyote.tomcat4.CoyoteConnector2/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected int minProcessors = 5;
    protected int maxSpareProcessors = 5;
    private int maxProcessors = 20;
    private int connectionLinger = -1;
    private int connectionTimeout = 60000;
    private int connectionUploadTimeout = 300000;
    private int serverSocketTimeout = 0;
    private int port = 8080;
    private String proxyName = null;
    private int proxyPort = 0;
    private int redirectPort = 443;
    private String scheme = "http";
    private boolean secure = false;
    private boolean tomcatAuthentication = true;
    private StringManager sm = StringManager.getManager((String)"org.apache.coyote.tomcat4");
    private boolean initialized = false;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private boolean tcpNoDelay = true;
    private boolean disableUploadTimeout = false;
    private int maxKeepAliveRequests = 100;
    private String compression = "off";
    private String protocolHandlerClassName = "org.apache.coyote.http11.Http11Protocol";
    private boolean useURIValidationHack = true;
    private ProtocolHandler protocolHandler = null;
    private Adapter adapter = null;
    private String URIEncoding = null;
    private boolean useBodyEncodingForURI = true;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public int getConnectionLinger() {
        return this.connectionLinger;
    }

    public void setConnectionLinger(int connectionLinger) {
        this.connectionLinger = connectionLinger;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setConnectionUploadTimeout(int connectionUploadTimeout) {
        this.connectionUploadTimeout = connectionUploadTimeout;
    }

    public int getServerSocketTimeout() {
        return this.serverSocketTimeout;
    }

    public void setServerSocketTimeout(int serverSocketTimeout) {
        this.serverSocketTimeout = serverSocketTimeout;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public void setAcceptCount(int count) {
        this.acceptCount = count;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean getAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(boolean allowTrace) {
        this.allowTrace = allowTrace;
    }

    public boolean isAvailable() {
        return this.started;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public int getCurProcessors() {
        return this.curProcessors;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocketFactory getFactory() {
        if (this.factory == null) {
            CoyoteConnector coyoteConnector = this;
            synchronized (coyoteConnector) {
                this.factory = new DefaultServerSocketFactory();
            }
        }
        return this.factory;
    }

    public void setFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public String getInfo() {
        return info;
    }

    public int getMinProcessors() {
        return this.minProcessors;
    }

    public void setMinProcessors(int minProcessors) {
        this.minProcessors = minProcessors;
    }

    public int getMaxProcessors() {
        return this.maxProcessors;
    }

    public void setMaxProcessors(int maxProcessors) {
        this.maxProcessors = maxProcessors;
    }

    public int getMaxSpareProcessors() {
        return this.maxSpareProcessors;
    }

    public void setMaxSpareProcessors(int maxSpareProcessors) {
        this.maxSpareProcessors = maxSpareProcessors;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    public void setProtocolHandlerClassName(String protocolHandlerClassName) {
        this.protocolHandlerClassName = protocolHandlerClassName;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = !"".equals(proxyName) ? proxyName : null;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public String getURIEncoding() {
        return this.URIEncoding;
    }

    public void setURIEncoding(String URIEncoding) {
        this.URIEncoding = URIEncoding;
    }

    public boolean getUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
    }

    public boolean getUseURIValidationHack() {
        return this.useURIValidationHack;
    }

    public void setUseURIValidationHack(boolean useURIValidationHack) {
        this.useURIValidationHack = useURIValidationHack;
    }

    public Request createRequest() {
        CoyoteRequest request = new CoyoteRequest();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        CoyoteResponse response = new CoyoteResponse();
        response.setConnector(this);
        return response;
    }

    private void log(String message) {
        Logger logger = this.container.getLogger();
        String localName = "CoyoteConnector";
        if (logger != null) {
            logger.log(localName + " " + message);
        } else {
            System.out.println(localName + " " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        String localName = "CoyoteConnector";
        if (logger != null) {
            logger.log(localName + " " + message, throwable);
        } else {
            System.out.println(localName + " " + message);
            throwable.printStackTrace(System.out);
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return null;
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.alreadyInitialized"));
        }
        this.initialized = true;
        this.adapter = new CoyoteAdapter(this);
        try {
            Class<?> clazz = Class.forName(this.protocolHandlerClassName);
            this.protocolHandler = (ProtocolHandler)clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerInstantiationFailed", (Object)e));
        }
        this.protocolHandler.setAdapter(this.adapter);
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"jkHome", (String)System.getProperty("catalina.base"));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"port", (String)("" + this.port));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"maxThreads", (String)("" + this.maxProcessors));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"minSpareThreads", (String)("" + this.minProcessors));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"maxSpareThreads", (String)("" + this.maxSpareProcessors));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"backlog", (String)("" + this.acceptCount));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"tcpNoDelay", (String)("" + this.tcpNoDelay));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"soLinger", (String)("" + this.connectionLinger));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"soTimeout", (String)("" + this.connectionTimeout));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"timeout", (String)("" + this.connectionUploadTimeout));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"serverSoTimeout", (String)("" + this.serverSocketTimeout));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"disableUploadTimeout", (String)("" + this.disableUploadTimeout));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"maxKeepAliveRequests", (String)("" + this.maxKeepAliveRequests));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"tomcatAuthentication", (String)("" + this.tomcatAuthentication));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"compression", (String)this.compression);
        if (this.address != null) {
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"address", (String)this.address);
        }
        if (this.factory instanceof CoyoteServerSocketFactory) {
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"secure", (String)"true");
            CoyoteServerSocketFactory ssf = (CoyoteServerSocketFactory)this.factory;
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"algorithm", (String)ssf.getAlgorithm());
            if (ssf.getClientAuth()) {
                IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"clientauth", (String)("" + ssf.getClientAuth()));
            }
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"keystore", (String)ssf.getKeystoreFile());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"randomfile", (String)ssf.getRandomFile());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"rootfile", (String)ssf.getRootFile());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"keypass", (String)ssf.getKeystorePass());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"keytype", (String)ssf.getKeystoreType());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"protocol", (String)ssf.getProtocol());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"sSLImplementation", (String)ssf.getSSLImplementation());
        } else {
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"secure", (String)"false");
        }
        try {
            this.protocolHandler.init();
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerInitializationFailed", (Object)e));
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.oname != null) {
            try {
                Registry.getRegistry().registerComponent((Object)this.protocolHandler, this.domain + ":type=protocolHandler,className=" + this.protocolHandlerClassName, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.log("Coyote can't register jmx for protocol");
        }
        try {
            this.protocolHandler.start();
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerStartFailed", (Object)e));
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            this.protocolHandler.destroy();
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerDestroyFailed", (Object)e));
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

