/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.exporters;

import de.nava.informa.core.ChannelExporterIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.ParserUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class RSS_0_91_Exporter
implements ChannelExporterIF {
    public static final String PUBLIC_ID = "-//Netscape Communications//DTD RSS 0.91//EN";
    public static final String SYSTEM_ID = "http://my.netscape.com/publish/formats/rss-0.91.dtd";
    public static final String RSS_VERSION = "0.91";
    private Writer writer;
    private String encoding;

    public void write(ChannelIF channel) throws IOException {
        if (this.writer == null) {
            throw new RuntimeException("No writer has been initialized.");
        }
        XMLOutputter outputter = new XMLOutputter("  ", true, this.encoding);
        Element rootElem = new Element("rss");
        rootElem.setAttribute("version", RSS_VERSION);
        Element channelElem = new Element("channel");
        channelElem.addContent(new Element("title").setText(channel.getTitle()));
        channelElem.addContent(new Element("description").setText(channel.getDescription()));
        if (channel.getSite() != null) {
            channelElem.addContent(new Element("link").setText(channel.getSite().toString()));
        }
        if (channel.getLanguage() != null) {
            channelElem.addContent(new Element("language").setText(channel.getLanguage()));
        }
        Collection items = channel.getItems();
        Iterator it = items.iterator();
        while (it.hasNext()) {
            ItemIF item = (ItemIF)it.next();
            Element itemElem = new Element("item");
            itemElem.addContent(new Element("title").setText(item.getTitle()));
            if (item.getLink() != null) {
                itemElem.addContent(new Element("link").setText(item.getLink().toString()));
            }
            if (item.getDescription() != null) {
                itemElem.addContent(new Element("description").setText(item.getDescription()));
            }
            if (item.getDate() != null) {
                itemElem.addContent(new Element("pubDate").setText(ParserUtils.formatDate(item.getDate())));
            }
            channelElem.addContent(itemElem);
        }
        if (channel.getCopyright() != null) {
            channelElem.addContent(new Element("copyright").setText(channel.getCopyright()));
        }
        rootElem.addContent(channelElem);
        DocType docType = new DocType("rss", PUBLIC_ID, SYSTEM_ID);
        Document doc = new Document(rootElem, docType);
        outputter.output(doc, this.writer);
    }

    public RSS_0_91_Exporter(String filename) throws IOException {
        this(new File(filename), "utf-8");
    }

    public RSS_0_91_Exporter(File file) throws IOException {
        this(file, "utf-8");
    }

    public RSS_0_91_Exporter(File file, String encoding) throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        this.encoding = encoding;
    }

    public RSS_0_91_Exporter(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }
}

