/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.basic;

import de.nava.informa.core.CategoryIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelObserverIF;
import de.nava.informa.core.CloudIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.impl.basic.IdGenerator;
import de.nava.informa.utils.XmlPathUtils;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Channel
implements ChannelIF,
Serializable {
    private long id;
    private String title;
    private String description;
    private URL location;
    private URL site;
    private String creator;
    private String publisher;
    private String language;
    private ChannelFormat format;
    private Map items;
    private ImageIF image;
    private CloudIF cloud;
    private TextInputIF textInput;
    private String copyright;
    private Collection categories;
    private Date lastUpdated;
    private Date lastBuild;
    private Date pubDate;
    private String rating;
    private String generator;
    private String docs;
    private int ttl;
    private Element channelElement;
    private String updatePeriod;
    private int updateFrequency;
    private Date updateBase;
    private transient Collection observers;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public URL getLocation() {
        return this.location;
    }

    public void setLocation(URL location) {
        this.location = location;
    }

    public URL getSite() {
        return this.site;
    }

    public void setSite(URL site) {
        this.site = site;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getRating() {
        return this.rating;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public CloudIF getCloud() {
        return this.cloud;
    }

    public void setCloud(CloudIF cloud) {
        this.cloud = cloud;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public String getDocs() {
        return this.docs;
    }

    public void setDocs(String docs) {
        this.docs = docs;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public ChannelFormat getFormat() {
        return this.format;
    }

    public void setFormat(ChannelFormat format) {
        this.format = format;
    }

    public Collection getItems() {
        return this.items.values();
    }

    public void addItem(ItemIF item) {
        this.items.put(new Long(item.getId()), item);
        item.setChannel(this);
        this.notifyObserversItemAdded(item);
    }

    public void removeItem(ItemIF item) {
        this.items.remove(new Long(item.getId()));
    }

    public ItemIF getItem(long id) {
        return (ItemIF)this.items.get(new Long(id));
    }

    public ImageIF getImage() {
        return this.image;
    }

    public void setImage(ImageIF image) {
        this.image = image;
    }

    public TextInputIF getTextInput() {
        return this.textInput;
    }

    public void setTextInput(TextInputIF textInput) {
        this.textInput = textInput;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public Collection getCategories() {
        return this.categories;
    }

    public void setCategories(Collection categories) {
        this.categories = categories;
    }

    public void addCategory(CategoryIF category) {
        this.categories.add(category);
    }

    public void removeCategory(CategoryIF category) {
        this.categories.remove(category);
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        this.notifyObserversChannelUpdated();
    }

    public Date getLastBuildDate() {
        return this.lastBuild;
    }

    public void setLastBuildDate(Date lastBuild) {
        this.lastBuild = lastBuild;
    }

    public Date getPubDate() {
        return this.pubDate;
    }

    public void setPubDate(Date pubDate) {
        this.pubDate = pubDate;
    }

    public void setAllProperties(ChannelIF sourceChan) {
        this.setTitle(sourceChan.getTitle());
        this.setDescription(sourceChan.getDescription());
        this.setSite(sourceChan.getSite());
        this.setCreator(sourceChan.getCreator());
        this.setCopyright(sourceChan.getCopyright());
        this.setPublisher(sourceChan.getPublisher());
        this.setLanguage(sourceChan.getLanguage());
        this.setImage(sourceChan.getImage());
        this.setTextInput(sourceChan.getTextInput());
        this.setRating(sourceChan.getRating());
        this.setGenerator(sourceChan.getGenerator());
        this.setDocs(sourceChan.getDocs());
        this.setTtl(sourceChan.getTtl());
        this.setCloud(sourceChan.getCloud());
        this.setLastBuildDate(sourceChan.getLastBuildDate());
        this.setUpdateBase(sourceChan.getUpdateBase());
        this.setUpdateFrequency(sourceChan.getUpdateFrequency());
        this.setUpdatePeriod(sourceChan.getUpdatePeriod());
        this.setPubDate(sourceChan.getPubDate());
    }

    public String getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setUpdatePeriod(String updatePeriod) {
        this.updatePeriod = updatePeriod;
    }

    public int getUpdateFrequency() {
        return this.updateFrequency;
    }

    public void setUpdateFrequency(int updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    public Date getUpdateBase() {
        return this.updateBase;
    }

    public void setUpdateBase(Date updateBase) {
        this.updateBase = updateBase;
    }

    public String getElementValue(String path) {
        return XmlPathUtils.getElementValue(this.channelElement, path);
    }

    public String[] getElementValues(String path, String[] elements) {
        return XmlPathUtils.getElementValues(this.channelElement, path, elements);
    }

    public String getAttributeValue(String path, String attribute) {
        return XmlPathUtils.getAttributeValue(this.channelElement, path, attribute);
    }

    public String[] getAttributeValues(String path, String[] attributes) {
        return XmlPathUtils.getAttributeValues(this.channelElement, path, attributes);
    }

    public void addObserver(ChannelObserverIF o) {
        this.observers.add(o);
    }

    public void removeObserver(ChannelObserverIF o) {
        this.observers.remove(o);
    }

    public boolean equals(Object obj) {
        boolean le;
        boolean de;
        boolean te;
        if (!(obj instanceof ChannelIF)) {
            return false;
        }
        ChannelIF cmp = (ChannelIF)obj;
        if (this.title != null) {
            te = this.title.equals(cmp.getTitle());
        } else {
            boolean bl = false;
            if (cmp.getTitle() == null) {
                bl = te = true;
            }
        }
        if (this.description != null) {
            de = this.description.equals(cmp.getDescription());
        } else {
            boolean bl = false;
            if (cmp.getDescription() == null) {
                bl = de = true;
            }
        }
        if (this.location != null) {
            le = this.location.equals(cmp.getLocation());
        } else {
            boolean bl = false;
            if (cmp.getLocation() == null) {
                bl = true;
            }
            le = bl;
        }
        boolean bl = false;
        if (te && de && le) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.title).append(this.description).append(this.location);
        return sb.toString().hashCode();
    }

    public String toString() {
        return "[Basic Channel (" + this.id + "): " + this.title + " (" + this.location + " )]";
    }

    private final void notifyObserversItemAdded(ItemIF newItem) {
        Iterator it = this.observers.iterator();
        while (it.hasNext()) {
            ChannelObserverIF o = (ChannelObserverIF)it.next();
            o.itemAdded(newItem);
        }
    }

    private final void notifyObserversChannelUpdated() {
        Iterator it = this.observers.iterator();
        while (it.hasNext()) {
            ChannelObserverIF o = (ChannelObserverIF)it.next();
            o.channelRetrieved(this);
        }
    }

    private static final Map getMap() {
        try {
            String jdkVersion = System.getProperty("java.specification.version");
            int version = (int)(Double.parseDouble(jdkVersion) * 10.0);
            return version <= 13 ? new HashMap() : MapFactory.getMap();
        }
        catch (Exception e) {
            return new HashMap();
        }
    }

    private final /* synthetic */ void this() {
        this.ttl = -1;
        this.updatePeriod = null;
        this.updateFrequency = -1;
    }

    public Channel() {
        this((String)null);
    }

    public Channel(String title) {
        this(null, title);
    }

    public Channel(Element channelElement) {
        this(channelElement, "Unnamed channel");
    }

    public Channel(Element channelElement, String title) {
        this.this();
        this.id = IdGenerator.getInstance().getId();
        this.channelElement = channelElement;
        this.title = title;
        this.items = Channel.getMap();
        this.categories = new ArrayList();
        this.observers = new ArrayList();
        this.format = ChannelFormat.UNKNOWN_CHANNEL_FORMAT;
        this.lastUpdated = new Date();
    }

    private static final class MapFactory {
        static final Map getMap() {
            return new LinkedHashMap();
        }

        private MapFactory() {
        }
    }
}

