/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.impl.basic;

import de.nava.informa.core.CategoryIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemEnclosureIF;
import de.nava.informa.core.ItemGuidIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ItemSourceIF;
import de.nava.informa.impl.basic.IdGenerator;
import de.nava.informa.utils.XmlPathUtils;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.jdom.Element;

public class Item
implements ItemIF,
Serializable {
    private long id = IdGenerator.getInstance().getId();
    private String title;
    private String description;
    private URL link;
    private Collection categories;
    private String creator;
    private String subject;
    private Date date;
    private Date found;
    private ItemGuidIF guid;
    private URL comments;
    private ItemSourceIF source;
    private ItemEnclosureIF enclosure;
    private Element itemElement;
    private ChannelIF channel;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public ChannelIF getChannel() {
        return this.channel;
    }

    public void setChannel(ChannelIF channel) {
        this.channel = channel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public URL getLink() {
        return this.link;
    }

    public void setLink(URL link) {
        this.link = link;
    }

    public Collection getCategories() {
        return this.categories;
    }

    public void setCategories(Collection categories) {
        this.categories = categories;
    }

    public void addCategory(CategoryIF category) {
        this.categories.add(category);
    }

    public void removeCategory(CategoryIF category) {
        this.categories.remove(category);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getFound() {
        return this.found;
    }

    public void setFound(Date found) {
        this.found = found;
    }

    public ItemGuidIF getGuid() {
        return this.guid;
    }

    public void setGuid(ItemGuidIF guid) {
        this.guid = guid;
    }

    public URL getComments() {
        return this.comments;
    }

    public void setComments(URL comments) {
        this.comments = comments;
    }

    public ItemSourceIF getSource() {
        return this.source;
    }

    public void setSource(ItemSourceIF source) {
        this.source = source;
    }

    public ItemEnclosureIF getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(ItemEnclosureIF enclosure) {
        this.enclosure = enclosure;
    }

    public String getElementValue(String path) {
        return XmlPathUtils.getElementValue(this.itemElement, path);
    }

    public String[] getElementValues(String path, String[] elements) {
        return XmlPathUtils.getElementValues(this.itemElement, path, elements);
    }

    public String getAttributeValue(String path, String attribute) {
        return XmlPathUtils.getAttributeValue(this.itemElement, path, attribute);
    }

    public String[] getAttributeValues(String path, String[] attributes) {
        return XmlPathUtils.getAttributeValues(this.itemElement, path, attributes);
    }

    public boolean equals(Object obj) {
        boolean le;
        boolean de;
        boolean te;
        if (!(obj instanceof ItemIF)) {
            return false;
        }
        ItemIF cmp = (ItemIF)obj;
        if (this.title != null) {
            te = this.title.equals(cmp.getTitle());
        } else {
            boolean bl = false;
            if (cmp.getTitle() == null) {
                bl = te = true;
            }
        }
        if (this.description != null) {
            de = this.description.equals(cmp.getDescription());
        } else {
            boolean bl = false;
            if (cmp.getDescription() == null) {
                bl = de = true;
            }
        }
        if (this.link != null) {
            le = this.link.equals(cmp.getLink());
        } else {
            boolean bl = false;
            if (cmp.getLink() == null) {
                bl = true;
            }
            le = bl;
        }
        boolean bl = false;
        if (te && de && le) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.title).append(this.description).append(this.link);
        return sb.toString().hashCode();
    }

    public String toString() {
        return "[Item (" + this.id + "): " + this.title + ']';
    }

    public Item() {
        this(null, null, "[Unknown Item]", null, null);
    }

    public Item(String title, String description, URL link) {
        this(null, null, title, description, link);
    }

    public Item(ChannelIF channel, String title, String description, URL link) {
        this(null, channel, title, description, link);
    }

    public Item(Element itemElement, String title, String description, URL link) {
        this(itemElement, null, title, description, link);
    }

    public Item(Element itemElement, ChannelIF channel, String title, String description, URL link) {
        this.itemElement = itemElement;
        this.channel = channel;
        this.title = title;
        this.description = description;
        this.link = link;
        this.categories = new ArrayList();
    }
}

