/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.parsers;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.core.UnsupportedFormatException;
import de.nava.informa.parsers.RSS_0_91_Parser;
import de.nava.informa.parsers.RSS_1_0_Parser;
import de.nava.informa.parsers.RSS_2_0_Parser;
import de.nava.informa.utils.NoOpEntityResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class RSSParser {
    private static Log logger;
    static /* synthetic */ Class class$de$nava$informa$parsers$RSSParser;

    public static ChannelIF parse(ChannelBuilderIF cBuilder, URL aURL) throws IOException, ParseException {
        return RSSParser.parse(cBuilder, new InputSource(aURL.toExternalForm()), aURL);
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, String url) throws IOException, ParseException {
        URL aURL = null;
        try {
            aURL = new URL(url);
        }
        catch (MalformedURLException e) {
            logger.warn((Object)("Could not create URL for " + url));
        }
        return RSSParser.parse(cBuilder, new InputSource(url), aURL);
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, Reader reader) throws IOException, ParseException {
        return RSSParser.parse(cBuilder, new InputSource(reader), null);
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, InputStream stream) throws IOException, ParseException {
        return RSSParser.parse(cBuilder, new InputSource(stream), null);
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, File aFile) throws IOException, ParseException {
        URL aURL = null;
        try {
            aURL = aFile.toURL();
        }
        catch (MalformedURLException e) {
            throw new IOException("File " + aFile + " had invalid URL representation.");
        }
        return RSSParser.parse(cBuilder, new InputSource(aURL.toExternalForm()), aURL);
    }

    public static ChannelIF parse(ChannelBuilderIF cBuilder, InputSource inpSource, URL baseLocation) throws IOException, ParseException {
        SAXBuilder saxBuilder = new SAXBuilder(false);
        saxBuilder.setEntityResolver((EntityResolver)new NoOpEntityResolver());
        try {
            Document doc = saxBuilder.build(inpSource);
            ChannelIF channel = RSSParser.parse(cBuilder, doc);
            channel.setLocation(baseLocation);
            return channel;
        }
        catch (JDOMException e) {
            throw new ParseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final synchronized ChannelIF parse(ChannelBuilderIF cBuilder, Document doc) throws ParseException {
        if (cBuilder == null) {
            throw new RuntimeException("Without builder no channel can be created.");
        }
        logger.debug((Object)"start parsing.");
        Element root = doc.getRootElement();
        String rootElement = root.getName().toLowerCase();
        if (!rootElement.startsWith("rss")) {
            if (rootElement.indexOf("rdf") < 0) throw new UnsupportedFormatException("Unsupported RSS root element [" + rootElement + "].");
            return RSS_1_0_Parser.parse(cBuilder, root);
        }
        String rssVersion = root.getAttribute("version").getValue();
        if (rssVersion.indexOf("0.91") >= 0) {
            logger.info((Object)"Channel uses RSS root element (Version 0.91).");
            return RSS_0_91_Parser.parse(cBuilder, root);
        }
        if (rssVersion.indexOf("0.92") >= 0) {
            logger.info((Object)"Channel uses RSS root element (Version 0.92).");
            return RSS_0_91_Parser.parse(cBuilder, root);
        }
        if (rootElement.indexOf("0.93") >= 0) {
            logger.info((Object)"Channel uses RSS root element (Version 0.93).");
            logger.warn((Object)"RSS 0.93 not fully supported yet, fall back to 0.91.");
            throw new UnsupportedFormatException("Unsupported RSS root element [" + rootElement + "].");
        }
        if (rootElement.indexOf("0.94") >= 0) {
            logger.info((Object)"Channel uses RSS root element (Version 0.94).");
            logger.warn((Object)"RSS 0.94 not fully supported yet, will use RSS 2.0");
            return RSS_2_0_Parser.parse(cBuilder, root);
        }
        if (rssVersion.indexOf("2.0") < 0) throw new UnsupportedFormatException("Unsupported RSS version [" + rssVersion + "].");
        logger.info((Object)"Channel uses RSS root element (Version 2.0).");
        return RSS_2_0_Parser.parse(cBuilder, root);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$de$nava$informa$parsers$RSSParser;
        if (clazz == null) {
            clazz = class$de$nava$informa$parsers$RSSParser = RSSParser.class$("[Lde.nava.informa.parsers.RSSParser;", false);
        }
        logger = LogFactory.getLog((Class)clazz);
    }
}

