/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.parsers;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemEnclosureIF;
import de.nava.informa.core.ItemGuidIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ItemSourceIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.utils.ParserUtils;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

class RSS_2_0_Parser {
    private static Log logger;
    static /* synthetic */ Class class$de$nava$informa$parsers$RSS_2_0_Parser;

    static ChannelIF parse(ChannelBuilderIF cBuilder, Element root) throws ParseException {
        Element cloud;
        Element webMaster;
        Element managingEditor;
        Element lastBuildDate;
        Element pubDate;
        Element ttl;
        Element generator;
        Element docs;
        Element rating;
        Element copyright;
        Element txtinp;
        Element channel;
        Namespace dcNS;
        if (cBuilder == null) {
            throw new RuntimeException("Without builder no channel can be created.");
        }
        Date dateParsed = new Date();
        logger.debug((Object)"start parsing.");
        Namespace defNS = ParserUtils.getDefaultNS(root);
        if (defNS == null) {
            defNS = Namespace.NO_NAMESPACE;
            logger.info((Object)"No default namespace found.");
        }
        if ((dcNS = ParserUtils.getNamespace(root, "dc")) == null) {
            dcNS = defNS;
        }
        if ((channel = root.getChild("channel")) == null) {
            logger.warn((Object)"Channel element could not be retrieved from feed.");
            throw new ParseException("No channel element found in feed.");
        }
        ChannelIF chnl = cBuilder.createChannel(channel, channel.getChildTextTrim("title"));
        chnl.setFormat(ChannelFormat.RSS_2_0);
        chnl.setDescription(channel.getChildTextTrim("description"));
        chnl.setSite(ParserUtils.getURL(channel.getChildTextTrim("link")));
        chnl.setLanguage(channel.getChildTextTrim("language"));
        List items = channel.getChildren("item");
        Iterator i = items.iterator();
        while (i.hasNext()) {
            Attribute lengthAttribute;
            Attribute typeAttribute;
            Element elEnclosure;
            Element elSource;
            String guidUrl;
            Element elDate;
            Element item = (Element)i.next();
            Element elTitle = item.getChild("title");
            String strTitle = "<No Title>";
            if (elTitle != null) {
                strTitle = elTitle.getTextTrim();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Item element found (" + strTitle + ")."));
            }
            Element elLink = item.getChild("link");
            String strLink = "";
            if (elLink != null) {
                strLink = elLink.getTextTrim();
            }
            Element elDesc = item.getChild("description");
            String strDesc = "";
            if (elDesc != null) {
                strDesc = elDesc.getTextTrim();
            }
            ItemIF rssItem = cBuilder.createItem(item, chnl, strTitle, strDesc, ParserUtils.getURL(strLink));
            Element elSubject = item.getChild("subject");
            if (elSubject == null) {
                elSubject = item.getChild("subject", dcNS);
            }
            if (elSubject != null) {
                rssItem.setSubject(elSubject.getTextTrim());
            }
            if ((elDate = item.getChild("pubDate")) == null) {
                elDate = item.getChild("date", dcNS);
            }
            if (elDate != null) {
                rssItem.setDate(ParserUtils.getDate(elDate.getTextTrim()));
            }
            rssItem.setFound(dateParsed);
            Element elAuthor = item.getChild("author");
            if (elAuthor == null) {
                elAuthor = item.getChild("creator", dcNS);
            }
            if (elAuthor != null) {
                rssItem.setCreator(elAuthor.getTextTrim());
            }
            Element elComments = item.getChild("comments");
            String strComments = "";
            if (elComments != null) {
                strComments = elComments.getTextTrim();
            }
            rssItem.setComments(ParserUtils.getURL(strComments));
            Element elGuid = item.getChild("guid");
            if (elGuid != null && (guidUrl = elGuid.getTextTrim()) != null) {
                String permaLinkStr;
                boolean permaLink = true;
                Attribute permaLinkAttribute = elGuid.getAttribute("isPermaLink");
                if (permaLinkAttribute != null && (permaLinkStr = permaLinkAttribute.getValue()) != null) {
                    permaLink = Boolean.valueOf(permaLinkStr);
                }
                ItemGuidIF itemGuid = cBuilder.createItemGuid(rssItem, guidUrl, permaLink);
                rssItem.setGuid(itemGuid);
            }
            if ((elSource = item.getChild("source")) != null) {
                String sourceName = elSource.getTextTrim();
                Attribute sourceAttribute = elSource.getAttribute("url");
                if (sourceAttribute != null) {
                    String sourceLocation = sourceAttribute.getValue().trim();
                    ItemSourceIF itemSource = cBuilder.createItemSource(rssItem, sourceName, sourceLocation, null);
                    rssItem.setSource(itemSource);
                }
            }
            if ((elEnclosure = item.getChild("enclosure")) == null) continue;
            URL location = null;
            String type = null;
            int length = -1;
            Attribute urlAttribute = elEnclosure.getAttribute("url");
            if (urlAttribute != null) {
                location = ParserUtils.getURL(urlAttribute.getValue().trim());
            }
            if ((typeAttribute = elEnclosure.getAttribute("type")) != null) {
                type = typeAttribute.getValue().trim();
            }
            if ((lengthAttribute = elEnclosure.getAttribute("length")) != null) {
                try {
                    length = Integer.parseInt(lengthAttribute.getValue().trim());
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            ItemEnclosureIF itemEnclosure = cBuilder.createItemEnclosure(rssItem, location, type, length);
            rssItem.setEnclosure(itemEnclosure);
        }
        Element image = channel.getChild("image");
        if (image != null) {
            Element imgDescr;
            Element imgHeight;
            ImageIF rssImage = cBuilder.createImage(image.getChildTextTrim("title"), ParserUtils.getURL(image.getChildTextTrim("url")), ParserUtils.getURL(image.getChildTextTrim("link")));
            Element imgWidth = image.getChild("width");
            if (imgWidth != null) {
                try {
                    rssImage.setWidth(Integer.parseInt(imgWidth.getTextTrim()));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("Error parsing width: " + e.getMessage()));
                }
            }
            if ((imgHeight = image.getChild("height")) != null) {
                try {
                    rssImage.setHeight(Integer.parseInt(imgHeight.getTextTrim()));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("Error parsing height: " + e.getMessage()));
                }
            }
            if ((imgDescr = image.getChild("description")) != null) {
                rssImage.setDescription(imgDescr.getTextTrim());
            }
            chnl.setImage(rssImage);
        }
        if ((txtinp = channel.getChild("textinput")) != null) {
            TextInputIF rssTextInput = cBuilder.createTextInput(txtinp.getChild("title").getTextTrim(), txtinp.getChild("description").getTextTrim(), txtinp.getChild("name").getTextTrim(), ParserUtils.getURL(txtinp.getChild("link").getTextTrim()));
            chnl.setTextInput(rssTextInput);
        }
        if ((copyright = channel.getChild("copyright")) != null) {
            chnl.setCopyright(copyright.getTextTrim());
        }
        if ((rating = channel.getChild("rating")) != null) {
            chnl.setRating(rating.getTextTrim());
        }
        if ((docs = channel.getChild("docs")) != null) {
            chnl.setDocs(docs.getTextTrim());
        }
        if ((generator = channel.getChild("generator")) != null) {
            chnl.setGenerator(generator.getTextTrim());
        }
        if ((ttl = channel.getChild("ttl")) != null) {
            chnl.setTtl(Integer.parseInt(ttl.getTextTrim()));
        }
        if ((pubDate = channel.getChild("pubDate")) != null) {
            chnl.setPubDate(ParserUtils.getDate(pubDate.getTextTrim()));
        }
        if ((lastBuildDate = channel.getChild("lastBuildDate")) != null) {
            chnl.setLastBuildDate(ParserUtils.getDate(lastBuildDate.getTextTrim()));
        }
        if ((managingEditor = channel.getChild("managingEditor")) != null) {
            chnl.setCreator(managingEditor.getTextTrim());
        }
        if ((webMaster = channel.getChild("webMaster")) != null) {
            chnl.setPublisher(webMaster.getTextTrim());
        }
        if ((cloud = channel.getChild("cloud")) != null) {
            String _port = cloud.getAttributeValue("port");
            int port = -1;
            if (_port != null) {
                try {
                    port = Integer.parseInt(_port);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            chnl.setCloud(cBuilder.createCloud(cloud.getAttributeValue("domain"), port, cloud.getAttributeValue("path"), cloud.getAttributeValue("registerProcedure"), cloud.getAttributeValue("protocol")));
        }
        chnl.setLastUpdated(dateParsed);
        return chnl;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    RSS_2_0_Parser() {
    }

    static {
        Class clazz = class$de$nava$informa$parsers$RSS_2_0_Parser;
        if (clazz == null) {
            clazz = class$de$nava$informa$parsers$RSS_2_0_Parser = RSS_2_0_Parser.class$("[Lde.nava.informa.parsers.RSS_2_0_Parser;", false);
        }
        logger = LogFactory.getLog((Class)clazz);
    }
}

