/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.search;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.search.ItemDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;

public final class ChannelIndexer {
    private static Log logger;
    private String indexDir;
    private int nrOfIndexedItems;
    private Analyzer analyzer;
    static /* synthetic */ Class class$de$nava$informa$search$ChannelIndexer;

    public final void indexChannels(boolean createNewIndex, Collection channels) throws IOException {
        ArrayList items = new ArrayList();
        Iterator itC = channels.iterator();
        while (itC.hasNext()) {
            ChannelIF channel = (ChannelIF)itC.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Searching channel " + channel + " for items."));
            }
            items.addAll(channel.getItems());
        }
        if (!items.isEmpty()) {
            this.indexItems(createNewIndex, items);
        } else {
            logger.info((Object)"No items found for indexing.");
        }
    }

    public final void indexItems(boolean createNewIndex, Collection items) throws IOException {
        logger.info((Object)"Start writing index.");
        IndexWriter writer = new IndexWriter(this.indexDir, this.analyzer, createNewIndex);
        Iterator itI = items.iterator();
        while (itI.hasNext()) {
            ItemIF item = (ItemIF)itI.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add item " + item + " to index."));
            }
            writer.addDocument(ItemDocument.makeDocument(item));
        }
        writer.optimize();
        this.nrOfIndexedItems = writer.docCount();
        writer.close();
        logger.info((Object)"Finished writing index.");
    }

    public final int getNrOfIndexedItems() {
        return this.nrOfIndexedItems;
    }

    public final void setIndexDir(String indexDir) {
        this.indexDir = indexDir;
    }

    public final String getIndexDir() {
        return this.indexDir;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ChannelIndexer(String indexDir) {
        this.indexDir = indexDir;
        this.nrOfIndexedItems = 0;
        this.analyzer = new StandardAnalyzer();
    }

    static {
        Class clazz = class$de$nava$informa$search$ChannelIndexer;
        if (clazz == null) {
            clazz = class$de$nava$informa$search$ChannelIndexer = ChannelIndexer.class$("[Lde.nava.informa.search.ChannelIndexer;", false);
        }
        logger = LogFactory.getLog((Class)clazz);
    }
}

