/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.search;

import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.search.ItemResult;
import de.nava.informa.search.QueryParseException;
import de.nava.informa.search.UnretrievableException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;

public class ChannelSearcher {
    private static Log logger;
    public static final int DEFAULT_MAX_RESULTS = 25;
    private String indexDir;
    private Analyzer analyzer;
    private Searcher searcher;
    private int nrOfHits;
    static /* synthetic */ Class class$de$nava$informa$search$ChannelSearcher;

    public List search(ChannelGroupIF channels, String queryString) throws QueryParseException, IOException {
        return this.search(channels, queryString, 25);
    }

    public List search(ChannelGroupIF channels, String queryString, int maxResults) throws QueryParseException, IOException {
        Query query = null;
        try {
            logger.info((Object)("Searching for '" + queryString + "'."));
            query = QueryParser.parse((String)queryString, (String)"titledesc", (Analyzer)this.analyzer);
        }
        catch (ParseException pe) {
            throw new QueryParseException(pe);
        }
        Hits hits = this.searcher.search(query);
        this.nrOfHits = hits.length();
        logger.info((Object)("Query returned " + this.nrOfHits + " hits."));
        ArrayList<ItemResult> results = new ArrayList<ItemResult>();
        int i = 0;
        while (i < hits.length() && i < maxResults) {
            Document doc = hits.doc(i);
            long channelId = Long.parseLong(doc.get("channel"));
            ChannelIF channel = channels.getById(channelId);
            if (channel == null) {
                throw new UnretrievableException("channel " + channelId);
            }
            long itemId = Long.parseLong(doc.get("item"));
            ItemIF item = channel.getItem(itemId);
            if (item == null) {
                throw new UnretrievableException("item " + itemId);
            }
            results.add(new ItemResult(item, hits.score(i)));
            ++i;
        }
        this.searcher.close();
        return results;
    }

    public int getNrOfHits() {
        return this.nrOfHits;
    }

    public void setIndexDir(String indexDir) {
        this.indexDir = indexDir;
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ChannelSearcher(String indexDir) throws IOException {
        this.indexDir = indexDir;
        this.analyzer = new StandardAnalyzer();
        this.searcher = new IndexSearcher(indexDir);
        this.nrOfHits = 0;
    }

    static {
        Class clazz = class$de$nava$informa$search$ChannelSearcher;
        if (clazz == null) {
            clazz = class$de$nava$informa$search$ChannelSearcher = ChannelSearcher.class$("[Lde.nava.informa.search.ChannelSearcher;", false);
        }
        logger = LogFactory.getLog((Class)clazz);
    }
}

