/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.search;

import de.nava.informa.core.ItemIF;
import de.nava.informa.search.ItemFieldConstants;
import java.util.Date;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class ItemDocument
implements ItemFieldConstants {
    public static Document makeDocument(ItemIF item) {
        Document doc = new Document();
        doc.add(Field.Text((String)"title", (String)item.getTitle()));
        doc.add(Field.Text((String)"description", (String)item.getDescription()));
        doc.add(Field.Text((String)"titledesc", (String)(item.getTitle() + ' ' + item.getDescription())));
        if (item.getFound() != null) {
            doc.add(Field.Keyword((String)"found", (String)DateField.dateToString((Date)item.getFound())));
        }
        doc.add(Field.UnIndexed((String)"item", (String)Long.toString(item.getId())));
        if (item.getChannel() != null) {
            doc.add(Field.UnIndexed((String)"channel", (String)Long.toString(item.getChannel().getId())));
        }
        return doc;
    }

    private ItemDocument() {
    }
}

