/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.utils.UpdateChannelInfo;
import de.nava.informa.utils.UpdateChannelTask;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelRegistry {
    private static Log logger;
    public static final int DEFAULT_ACCEPT_NR_ERRORS = 10;
    private int acceptNrOfErrors;
    private ChannelBuilderIF builder;
    private ChannelGroupIF channels;
    private Timer updateDaemon;
    private Map updateTasks;
    private Map channelInfos;
    static /* synthetic */ Class class$de$nava$informa$utils$ChannelRegistry;

    public ChannelIF addChannel(URL url, int interval, boolean active) {
        return this.addChannel(url, null, interval, active);
    }

    public ChannelIF addChannel(URL url, Collection categories, int interval, boolean active) {
        ChannelIF channel = this.builder.createChannel("[uninitialized channel]");
        channel.setCategories(categories);
        channel.setLocation(url);
        channel = this.addChannel(channel, active, interval);
        return channel;
    }

    public ChannelIF addChannel(ChannelIF channel, boolean active, int interval) {
        this.channels.add(channel);
        logger.debug((Object)("added channel " + channel.getId() + " to registry"));
        if (active) {
            this.activateChannel(channel, interval);
        }
        return channel;
    }

    public void activateChannel(ChannelIF channel, int interval) {
        if (this.updateTasks.get(channel.getLocation()) == null) {
            UpdateChannelInfo info = (UpdateChannelInfo)this.channelInfos.get(channel.getLocation());
            if (info == null) {
                info = new UpdateChannelInfo(this.acceptNrOfErrors);
                info.setFormatDetected(false);
                this.channelInfos.put(channel.getLocation(), info);
            } else {
                info.reset();
            }
            UpdateChannelTask task = new UpdateChannelTask(this, this.builder, channel, info);
            this.updateDaemon.schedule((TimerTask)task, 100L, (long)(interval * 1000));
            logger.info((Object)("activating channel updates for " + channel.getTitle()));
            this.updateTasks.put(channel.getLocation(), task);
        }
    }

    public ChannelIF getChannel(int id) {
        return this.channels.getById(id);
    }

    public Collection getChannels() {
        return this.channels.getAll();
    }

    public ChannelGroupIF getChannelGroup() {
        return this.channels;
    }

    public void setChannelGroup(ChannelGroupIF channels) {
        this.channels = channels;
        Iterator it = channels.getAll().iterator();
        while (it.hasNext()) {
            ChannelIF channelIF = (ChannelIF)it.next();
        }
    }

    public void removeChannel(ChannelIF channel) {
        this.deactivateChannel(channel);
        this.channels.remove(channel);
        logger.debug((Object)("removing channel from registry: " + channel.getTitle()));
    }

    public void deactivateChannel(ChannelIF channel) {
        UpdateChannelTask task = (UpdateChannelTask)this.updateTasks.get(channel.getLocation());
        if (task != null) {
            logger.debug((Object)("update task canceled for " + channel.getTitle()));
            task.cancel();
            this.updateTasks.remove(channel.getLocation());
        }
    }

    public boolean isActiveChannel(ChannelIF channel) {
        UpdateChannelTask task = (UpdateChannelTask)this.updateTasks.get(channel.getLocation());
        boolean bl = false;
        if (task != null) {
            bl = true;
        }
        return bl;
    }

    public UpdateChannelInfo getUpdateInfo(ChannelIF channel) {
        return (UpdateChannelInfo)this.channelInfos.get(channel.getLocation());
    }

    public long getScheduledUpdateTime(ChannelIF channel) {
        UpdateChannelTask task = (UpdateChannelTask)this.updateTasks.get(channel.getLocation());
        if (task != null) {
            return task.scheduledExecutionTime();
        }
        return 0L;
    }

    public int getAcceptNrOfErrors() {
        return this.acceptNrOfErrors;
    }

    public void setAcceptNrOfErrors(int acceptNrOfErrors) {
        this.acceptNrOfErrors = acceptNrOfErrors;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ChannelRegistry(ChannelBuilderIF builder) {
        this.builder = builder;
        this.channels = builder.createChannelGroup("Default");
        this.updateDaemon = new Timer(true);
        this.updateTasks = new HashMap();
        this.channelInfos = new HashMap();
        this.acceptNrOfErrors = 10;
    }

    static {
        Class clazz = class$de$nava$informa$utils$ChannelRegistry;
        if (clazz == null) {
            clazz = class$de$nava$informa$utils$ChannelRegistry = ChannelRegistry.class$("[Lde.nava.informa.utils.ChannelRegistry;", false);
        }
        logger = LogFactory.getLog((Class)clazz);
    }
}

