/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.FeedIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.OPMLParser;
import de.nava.informa.utils.FeedManagerEntry;
import de.nava.informa.utils.FeedManagerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FeedManager {
    private static final ChannelBuilderIF DEFAULT_BUILDER = new ChannelBuilder();
    private ChannelBuilderIF channelBuilder;
    private Map feeds = new HashMap();

    public FeedIF addFeed(FeedIF feed) throws FeedManagerException {
        return this.addFeed(feed.getLocation().toString());
    }

    public Collection addFeeds(String opmlFeedUri) throws FeedManagerException {
        ArrayList<FeedIF> retFeeds = null;
        try {
            Collection feeds = OPMLParser.parse(opmlFeedUri);
            retFeeds = new ArrayList<FeedIF>();
            Iterator iter = feeds.iterator();
            while (iter.hasNext()) {
                FeedIF element = (FeedIF)iter.next();
                retFeeds.add(this.addFeed(element));
            }
        }
        catch (IOException e) {
            throw new FeedManagerException(e);
        }
        catch (ParseException e) {
            throw new FeedManagerException(e);
        }
        return retFeeds;
    }

    public void setChannelBuilder(ChannelBuilderIF chBuilder) {
        this.channelBuilder = chBuilder;
    }

    public ChannelBuilderIF getChannelBuilder() {
        if (this.channelBuilder == null) {
            return DEFAULT_BUILDER;
        }
        return this.channelBuilder;
    }

    public boolean hasFeed(String feedUri) {
        return this.feeds.containsKey(feedUri);
    }

    public FeedIF addFeed(String feedUri) throws FeedManagerException {
        if (!this.hasFeed(feedUri)) {
            this.feeds.put(feedUri, new FeedManagerEntry(feedUri, this.getChannelBuilder()));
        }
        return this.getFeed(feedUri);
    }

    public void removeFeed(String feedUri) {
        this.feeds.remove(feedUri);
    }

    public FeedIF getFeed(String feedUri) throws FeedManagerException {
        FeedIF feed = null;
        if (this.hasFeed(feedUri)) {
            FeedManagerEntry entry = (FeedManagerEntry)this.feeds.get(feedUri);
            feed = entry.getFeed();
        }
        return feed;
    }
}

