/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.FeedIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.impl.basic.Feed;
import de.nava.informa.parsers.RSSParser;
import de.nava.informa.utils.FeedManagerException;
import java.io.IOException;
import java.net.URL;
import java.util.Date;

public class FeedManagerEntry {
    private static final String DEFAULT_UPDATE_PERIOD = "daily";
    private static final int DEFAULT_UPDATE_FREQUENCY = 1;
    private static final long MILLISECONDS_IN_HOUR = 3600000L;
    private static final long MILLISECONDS_IN_DAY = 86400000L;
    private static final long MILLISECONDS_IN_MONTH = 2419200000L;
    private static final long MILLISECONDS_IN_YEAR = 31536000000L;
    private long timeToExpire;
    private FeedIF feed;
    private long lastUpdate;
    private String feedUri;
    private ChannelBuilderIF channelBuilder;

    private final FeedIF retrieveFeed(String uri) throws FeedManagerException {
        try {
            URL feedUri = new URL(uri);
            ChannelIF channel = RSSParser.parse(this.getChannelBuilder(), feedUri);
            this.timeToExpire = FeedManagerEntry.getTimeToExpire(channel);
            this.feed = new Feed(channel);
            Date currDate = new Date();
            this.feed.setLastUpdated(currDate);
            this.feed.setDateFound(currDate);
        }
        catch (IOException e) {
            throw new FeedManagerException(e);
        }
        catch (ParseException e) {
            throw new FeedManagerException(e);
        }
        return this.feed;
    }

    private final void updateChannel() throws FeedManagerException {
        try {
            String feedUri = this.getFeed().getLocation().toString();
            ChannelIF channel = RSSParser.parse(this.getChannelBuilder(), feedUri);
            this.feed.setChannel(channel);
            this.feed.setLastUpdated(new Date());
        }
        catch (IOException e) {
            throw new FeedManagerException(e);
        }
        catch (ParseException e) {
            throw new FeedManagerException(e);
        }
    }

    public FeedIF getFeed() throws FeedManagerException {
        if (this.isOutOfDate()) {
            this.updateChannel();
        }
        return this.feed;
    }

    private static final long getTimeToExpire(ChannelIF channel) {
        long msInPeriod;
        String updatePeriod = channel.getUpdatePeriod();
        int updateFrequency = channel.getUpdateFrequency();
        if (updatePeriod == null) {
            updatePeriod = DEFAULT_UPDATE_PERIOD;
        }
        if (updateFrequency < 0) {
            updateFrequency = 1;
        }
        if (updatePeriod.equals("hourly")) {
            msInPeriod = 3600000L;
        } else if (updatePeriod.equals(DEFAULT_UPDATE_PERIOD)) {
            msInPeriod = 86400000L;
        } else if (updatePeriod.equals("monthly")) {
            msInPeriod = 2419200000L;
        } else if (updatePeriod.equals("yearly")) {
            msInPeriod = 31536000000L;
        } else {
            throw new IllegalArgumentException("updatePeriod " + updatePeriod + " is not valid");
        }
        long timeToExpire = msInPeriod / (long)updateFrequency;
        return timeToExpire;
    }

    private final boolean isOutOfDate() {
        boolean outOfDate = false;
        if (this.lastUpdate + this.timeToExpire < System.currentTimeMillis()) {
            outOfDate = true;
        }
        return outOfDate;
    }

    private final ChannelBuilderIF getChannelBuilder() {
        return this.channelBuilder;
    }

    public FeedManagerEntry(String feedUri, ChannelBuilderIF builder) throws FeedManagerException {
        this.feedUri = feedUri;
        this.channelBuilder = builder;
        this.feed = this.retrieveFeed(feedUri);
        this.lastUpdate = System.currentTimeMillis();
    }
}

