/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.UnsupportedFormatException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FormatDetector {
    private static Log logger;
    private static final int NR_FIRST_BYTES = 2048;
    static /* synthetic */ Class class$de$nava$informa$utils$FormatDetector;

    public static final ChannelFormat getFormat(URL url) throws IOException, UnsupportedFormatException {
        logger.info((Object)("Trying to retrieve stream from " + url));
        BufferedInputStream in = new BufferedInputStream(url.openStream(), 2048);
        return FormatDetector.getFormat(in);
    }

    public static final ChannelFormat getFormat(InputStream in) throws IOException, UnsupportedFormatException {
        byte[] b = new byte[2048];
        int bytesRead = 0;
        while (bytesRead < 2048) {
            int bytes = in.read(b, bytesRead, 2048 - bytesRead);
            if (bytes == -1) break;
            bytesRead += bytes;
        }
        String rootElement = FormatDetector.getRootElement(b);
        logger.debug((Object)("Detected [" + rootElement + "]."));
        if (rootElement.startsWith("rss")) {
            if (rootElement.indexOf("0.91") > 0) {
                logger.info((Object)"Channel uses RSS root element (Version 0.91).");
                return ChannelFormat.RSS_0_91;
            }
            if (rootElement.indexOf("0.92") > 0) {
                logger.info((Object)"Channel uses RSS root element (Version 0.92).");
                return ChannelFormat.RSS_0_92;
            }
            if (rootElement.indexOf("0.93") > 0) {
                logger.info((Object)"Channel uses RSS root element (Version 0.93).");
                logger.warn((Object)"RSS 0.93 not fully supported yet, fall back to 0.92.");
                return ChannelFormat.RSS_0_92;
            }
            if (rootElement.indexOf("0.94") > 0) {
                logger.info((Object)"Channel uses RSS root element (Version 0.94).");
                logger.warn((Object)"RSS 0.94 not fully supported yet, fall back to 0.92.");
                return ChannelFormat.RSS_0_92;
            }
            if (rootElement.indexOf("2.0") > 0) {
                logger.info((Object)"Channel uses RSS root element (Version 2.0).");
                return ChannelFormat.RSS_2_0;
            }
            throw new UnsupportedFormatException("Unsupported RSS version [" + rootElement + "].");
        }
        if (rootElement.indexOf("rdf") >= 0) {
            logger.info((Object)"Channel uses RDF root element.");
            return ChannelFormat.RSS_1_0;
        }
        throw new UnsupportedFormatException("Not able to parse document with root element [" + rootElement + "].");
    }

    private static final String getRootElement(byte[] b) {
        String s = new String(b);
        int startPos = 0;
        int endPos = 0;
        boolean inComment = false;
        int i = 0;
        block0: while (i < s.length()) {
            if (s.charAt(i) == '<' && Character.isLetter(s.charAt(i + 1)) && !inComment) {
                startPos = i + 1;
                int j = i + 1;
                while (j < s.length()) {
                    if (s.charAt(j) == '>') {
                        endPos = j;
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            if (!inComment && s.charAt(i) == '<' && s.charAt(i + 1) == '!' && s.charAt(i + 2) == '-' && s.charAt(i + 3) == '-') {
                inComment = true;
            } else if (inComment && s.charAt(i) == '-' && s.charAt(i + 1) == '-' && s.charAt(i + 2) == '>') {
                inComment = false;
            }
            ++i;
        }
        if (startPos >= 0 && endPos >= 0 && endPos > startPos) {
            return s.substring(startPos, endPos);
        }
        throw new IllegalArgumentException("Unable to retrieve root element from " + s);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$de$nava$informa$utils$FormatDetector;
        if (clazz == null) {
            clazz = class$de$nava$informa$utils$FormatDetector = FormatDetector.class$("[Lde.nava.informa.utils.FormatDetector;", false);
        }
        logger = LogFactory.getLog((Class)clazz);
    }
}

