/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.jdom.Namespace;

public final class ParserUtils {
    private static Log logger;
    private static SimpleDateFormat dfA;
    private static SimpleDateFormat dfB;
    private static SimpleDateFormat dfC;
    private static SimpleDateFormat dfD;
    static /* synthetic */ Class class$de$nava$informa$utils$ParserUtils;

    public static final URL getURL(String toURL) {
        URL result = null;
        try {
            if (toURL != null && toURL.trim().length() > 0) {
                result = new URL(toURL);
            }
        }
        catch (MalformedURLException e) {
            logger.warn((Object)("Invalid URL " + toURL + " given."));
        }
        return result;
    }

    public static final Namespace getDefaultNS(Element element) {
        return ParserUtils.getNamespace(element, "");
    }

    public static final Namespace getNamespace(Element element, String prefix) {
        Namespace ns = prefix == null ? element.getNamespace("") : element.getNamespace(prefix);
        return ns;
    }

    public static final Date getDate(String strdate) {
        Date result = null;
        try {
            result = dfA.parse(strdate);
        }
        catch (ParseException eA) {
            try {
                result = dfB.parse(strdate);
            }
            catch (ParseException eB) {
                try {
                    result = dfC.parse(strdate);
                    result = ParserUtils.extractTimeZone(strdate, result);
                }
                catch (ParseException eC) {
                    try {
                        result = dfD.parse(strdate);
                    }
                    catch (ParseException eD) {
                        // empty catch block
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsing date '" + strdate + "' resulted in: " + result));
        }
        if (result == null) {
            logger.warn((Object)("No appropiate date could be extracted from " + strdate));
        }
        return result;
    }

    private static final Date extractTimeZone(String strdate, Date thedate) {
        String tzSign = strdate.substring(strdate.length() - 6, strdate.length() - 5);
        String tzHour = strdate.substring(strdate.length() - 5, strdate.length() - 3);
        String tzMin = strdate.substring(strdate.length() - 2);
        if (tzSign.equals("-") || tzSign.equals("+")) {
            int h = Integer.parseInt(tzHour);
            int m = Integer.parseInt(tzMin);
            if (tzSign.equals("+")) {
                h = -1 * h;
                m = -1 * m;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(thedate);
            cal.add(11, h);
            cal.add(12, m);
            cal.add(14, ParserUtils.localTimeDiff(cal.getTimeZone(), thedate));
            thedate = cal.getTime();
        }
        return thedate;
    }

    private static final int localTimeDiff(TimeZone tz, Date date) {
        if (tz.inDaylightTime(date)) {
            int dstSavings = 0;
            if (tz.useDaylightTime()) {
                dstSavings = 3600000;
            }
            return tz.getRawOffset() + dstSavings;
        }
        return tz.getRawOffset();
    }

    public static final String formatDate(Date aDate) {
        return dfA.format(aDate);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private ParserUtils() {
    }

    static {
        Class clazz = class$de$nava$informa$utils$ParserUtils;
        if (clazz == null) {
            clazz = class$de$nava$informa$utils$ParserUtils = ParserUtils.class$("[Lde.nava.informa.utils.ParserUtils;", false);
        }
        logger = LogFactory.getLog((Class)clazz);
        dfA = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dfB = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        dfC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        dfD = new SimpleDateFormat("yyyy-MM-dd");
    }
}

