/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderException;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ChannelObserverIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.impl.hibernate.Channel;
import de.nava.informa.impl.hibernate.ChannelBuilder;
import de.nava.informa.impl.hibernate.ChannelGroup;
import de.nava.informa.impl.hibernate.Item;
import de.nava.informa.impl.hibernate.SessionHandler;
import de.nava.informa.utils.PersistChanGrpMgrTask;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PersistChanGrpMgr {
    private static final int DEFAULT_STARTDELAY = 1000;
    private static final int DEFAULT_PERIOD = 120000;
    private static final int DEFAULT_ACCEPTERRORS = 10;
    private static final int DBG_DEFAULT_STARTDELAY = 100;
    private static final int DBG_DEFAULT_PERIOD = 20000;
    private static final int DBG_DEFAULT_ACCEPTERRORS = 10;
    private static Log logger;
    private ChannelBuilder builder;
    private ChannelGroup group;
    private ChannelObserverIF globalChannelObserver;
    private boolean activated;
    private PersistChanGrpMgrTask task;
    private Timer taskScheduler;
    int taskStartDelay;
    int taskPeriod;
    int acceptNrErrors;
    static /* synthetic */ Class class$de$nava$informa$utils$PersistChanGrpMgr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChannelGroup createGroup(String name) {
        logger.debug((Object)("Creating Persistent Group: " + name));
        if (this.group != null) {
            throw new IllegalStateException("Can't call createGroup twice in a row.");
        }
        if (this.activated) {
            throw new IllegalStateException("Can't create groups while activated.");
        }
        ChannelGroup result = null;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            block9: {
                result = this.findChannelGroup(name);
                if (result != null) break block9;
                try {
                    this.builder.beginTransaction();
                    result = (ChannelGroup)this.builder.createChannelGroup(name);
                    this.builder.endTransaction();
                }
                catch (ChannelBuilderException e) {
                    try {
                        this.builder.endTransaction();
                    }
                    catch (ChannelBuilderException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
            this.group = result;
        }
        logger.info((Object)("createGroup: " + name + "->" + result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Channel addChannel(String url) {
        if (this.activated) {
            throw new IllegalStateException("can't add Channels while activated.");
        }
        Channel achannel = null;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                this.builder.update((Object)this.group);
                achannel = this.findChannel(url);
                if (achannel == null) {
                    achannel = this.newChannel(url);
                    logger.debug((Object)("Added New Channel: " + url));
                } else {
                    logger.debug((Object)("Loaded existing channel" + url));
                }
                this.builder.endTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.builder.resetTransaction();
            }
            return achannel;
        }
    }

    public void notifyChannelsAndItems(Channel achannel) {
        try {
            this.builder.beginTransaction();
            this.builder.update((Object)achannel);
            if (this.globalChannelObserver != null) {
                this.globalChannelObserver.channelRetrieved((ChannelIF)achannel);
                Iterator iterChan = achannel.getItems().iterator();
                while (iterChan.hasNext()) {
                    this.globalChannelObserver.itemAdded((ItemIF)((Item)iterChan.next()));
                }
            }
            this.builder.endTransaction();
        }
        catch (ChannelBuilderException e) {
            e.printStackTrace();
        }
    }

    public void notifyChannelsAndItems() {
        Iterator chanIter = this.group.getChannels().iterator();
        while (chanIter.hasNext()) {
            this.notifyChannelsAndItems((Channel)chanIter.next());
        }
    }

    public void notifyChannelRetrieved(Channel chan) {
        if (this.globalChannelObserver != null) {
            this.globalChannelObserver.channelRetrieved((ChannelIF)chan);
        }
    }

    public void notifyItemAdded(ItemIF newItem) {
        if (this.globalChannelObserver != null) {
            this.globalChannelObserver.itemAdded(newItem);
        }
    }

    public void setGlobalObserver(ChannelObserverIF obser) {
        this.globalChannelObserver = obser;
    }

    public void activate() {
        if (this.activated) {
            return;
        }
        this.task = new PersistChanGrpMgrTask(this);
        this.taskScheduler.schedule((TimerTask)this.task, this.taskStartDelay, (long)this.taskPeriod);
        this.activated = true;
    }

    public void deActivate() {
        if (!this.activated) {
            return;
        }
        this.task.cancel();
        this.activated = false;
    }

    public Iterator channelIterator() {
        Iterator ret = null;
        try {
            this.builder.beginTransaction();
            ret = this.group.getAll().iterator();
            this.builder.endTransaction();
        }
        catch (ChannelBuilderException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public ChannelBuilder getBuilder() {
        return this.builder;
    }

    public ChannelGroup getChannelGroup() {
        return this.group;
    }

    public int getAcceptNrErrors() {
        return this.acceptNrErrors;
    }

    public String toString() {
        String result = "";
        try {
            this.builder.beginTransaction();
            this.builder.update((Object)this.group);
            result = this.group.getTitle() + ':' + this.group.getChannels().size();
            this.builder.endTransaction();
        }
        catch (ChannelBuilderException e) {
            e.printStackTrace();
        }
        return result;
    }

    private final Channel newChannel(String url) {
        Channel channel = (Channel)this.builder.createChannel("[uninitialized channel]");
        channel.setLocationString(url);
        this.group.add((ChannelIF)channel);
        return channel;
    }

    private final Channel findChannel(String url) {
        Channel achan = null;
        Session sess = this.builder.getSession();
        try {
            List channels = sess.find("from Channel chan where chan.locationString = ?", (Object)url, (Type)Hibernate.STRING);
            if (channels.size() == 0) {
                achan = null;
            } else if (channels.size() > 1) {
                achan = this.tooManyChannelsFound(url, channels);
            } else if (channels.size() == 1) {
                achan = (Channel)channels.get(0);
            }
        }
        catch (HibernateException e) {
            achan = null;
            e.printStackTrace();
        }
        logger.info((Object)("findChannel: " + url + "->" + achan));
        return achan;
    }

    private final Channel tooManyChannelsFound(String url, List channels) {
        logger.error((Object)("Multiple Channels for " + url + " found."));
        return (Channel)channels.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ChannelGroup findChannelGroup(String name) {
        ChannelGroup result = null;
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            try {
                this.builder.beginTransaction();
                Session sess = this.builder.getSession();
                List results = sess.find("from ChannelGroup as grp where grp.title = ?", (Object)name, (Type)Hibernate.STRING);
                if (results.size() == 0) {
                    result = null;
                } else if (results.size() > 1) {
                    result = this.tooManyChannelGroupsFound(name, results);
                } else if (results.size() == 1) {
                    result = (ChannelGroup)results.get(0);
                }
                this.builder.endTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info((Object)("findChannelGroup: " + name + "->" + result));
        return result;
    }

    private final ChannelGroup tooManyChannelGroupsFound(String name, List results) {
        logger.error((Object)("Multiple Channel Groups called " + name + " found."));
        return (ChannelGroup)results.get(0);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.activated = false;
    }

    public PersistChanGrpMgr(SessionHandler handler, boolean debug) {
        this.this();
        if (handler == null || handler.getConnection() == null) {
            throw new IllegalStateException("Invalid handler");
        }
        this.builder = new ChannelBuilder(handler);
        this.taskScheduler = new Timer(true);
        if (debug) {
            this.taskStartDelay = 100;
            this.taskPeriod = 20000;
            this.acceptNrErrors = 10;
        } else {
            this.taskStartDelay = 1000;
            this.taskPeriod = 120000;
            this.acceptNrErrors = 10;
        }
    }

    static {
        Class clazz = class$de$nava$informa$utils$PersistChanGrpMgr;
        if (clazz == null) {
            clazz = class$de$nava$informa$utils$PersistChanGrpMgr = PersistChanGrpMgr.class$("[Lde.nava.informa.utils.PersistChanGrpMgr;", false);
        }
        logger = LogFactory.getLog((Class)clazz);
    }
}

