/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.impl.basic.Item;
import de.nava.informa.impl.hibernate.Channel;
import de.nava.informa.impl.hibernate.ChannelBuilder;
import de.nava.informa.parsers.RSSParser;
import de.nava.informa.utils.FormatDetector;
import de.nava.informa.utils.InformaUtils;
import de.nava.informa.utils.PersistChanGrpMgr;
import de.nava.informa.utils.UpdateChannelInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistChanGrpMgrTask
extends TimerTask {
    private static Log logger;
    private PersistChanGrpMgr mgr;
    private ChannelBuilder builder;
    private ChannelBuilderIF tempBuilder;
    private Map channelInfos;
    static /* synthetic */ Class class$de$nava$informa$utils$PersistChanGrpMgrTask;

    public void run() {
        logger.fatal((Object)"run()...");
        Thread.currentThread().setName("PCGrp: " + this.mgr.getChannelGroup().getTitle());
        Iterator iter = this.mgr.channelIterator();
        while (iter.hasNext()) {
            Channel nextChan = (Channel)iter.next();
            logger.info((Object)("processing: " + nextChan));
            this.handleChannel(nextChan, this.getUpdChanInfo(nextChan));
        }
    }

    private final UpdateChannelInfo getUpdChanInfo(Channel chan) {
        UpdateChannelInfo info = (UpdateChannelInfo)this.channelInfos.get(chan.getLocation());
        if (info == null) {
            info = new UpdateChannelInfo(this.mgr.getAcceptNrErrors());
            this.channelInfos.put(chan.getLocation(), info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handleChannel(Channel chan, UpdateChannelInfo info) {
        if (info.shouldDeactivate()) {
            logger.info((Object)("Not processing channel: " + chan + " because exceeded error threshold."));
            return;
        }
        ChannelBuilder channelBuilder = this.builder;
        synchronized (channelBuilder) {
            if (!info.getFormatDetected()) {
                this.handleChannelHeader(chan, info);
            }
            this.handleChannelItems(chan, info);
            return;
        }
    }

    private final void handleChannelHeader(Channel chan, UpdateChannelInfo info) {
        if (!info.getFormatDetected()) {
            logger.debug((Object)"Handling Channel Header. Format not yet detected.");
            try {
                this.builder.beginTransaction();
                ChannelFormat format = FormatDetector.getFormat(chan.getLocation());
                chan.setFormat(format);
                info.setFormatDetected(true);
                chan.setLastUpdated(new Date());
                this.builder.endTransaction();
            }
            catch (Exception e) {
                info.increaseProblemsOccurred(e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handleChannelItems(Channel chan, UpdateChannelInfo info) {
        Channel channel = chan;
        synchronized (channel) {
            try {
                this.builder.beginTransaction();
                ChannelIF tempChannel = RSSParser.parse(this.tempBuilder, chan.getLocation());
                InformaUtils.copyChannelProperties(tempChannel, (ChannelIF)chan);
                this.builder.update((Object)chan);
                chan.setLastUpdated(new Date());
                this.mgr.notifyChannelRetrieved(chan);
                if (!tempChannel.getItems().isEmpty()) {
                    Iterator it = tempChannel.getItems().iterator();
                    while (it.hasNext()) {
                        Item transientItem = (Item)it.next();
                        if (chan.getItems().contains(transientItem)) continue;
                        logger.info((Object)("Found new item: " + transientItem));
                        ItemIF newItem = this.builder.createItem((ChannelIF)chan, (ItemIF)transientItem);
                        chan.addItem(newItem);
                        this.mgr.notifyItemAdded(newItem);
                    }
                }
                this.builder.endTransaction();
            }
            catch (Exception e) {
                info.increaseProblemsOccurred(e);
                logger.info((Object)"Exception in handleChannelItems. Continuing...");
                this.builder.resetTransaction();
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PersistChanGrpMgrTask(PersistChanGrpMgr mgr) {
        this.mgr = mgr;
        this.builder = mgr.getBuilder();
        this.channelInfos = new HashMap();
        this.tempBuilder = new de.nava.informa.impl.basic.ChannelBuilder();
    }

    static {
        Class clazz = class$de$nava$informa$utils$PersistChanGrpMgrTask;
        if (clazz == null) {
            clazz = class$de$nava$informa$utils$PersistChanGrpMgrTask = PersistChanGrpMgrTask.class$("[Lde.nava.informa.utils.PersistChanGrpMgrTask;", false);
        }
        logger = LogFactory.getLog((Class)clazz);
    }
}

