/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import de.nava.informa.core.ChannelBuilderException;
import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.core.UnsupportedFormatException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.RSSParser;
import de.nava.informa.utils.ChannelRegistry;
import de.nava.informa.utils.FormatDetector;
import de.nava.informa.utils.InformaUtils;
import de.nava.informa.utils.UpdateChannelInfo;
import java.io.IOException;
import java.util.Date;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateChannelTask
extends TimerTask {
    private static Log logger;
    private ChannelRegistry registry;
    private ChannelIF channel;
    private ChannelBuilderIF builder;
    private UpdateChannelInfo info;
    private ChannelBuilderIF tempBuilder;
    static /* synthetic */ Class class$de$nava$informa$utils$UpdateChannelTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        UpdateChannelTask.logger.fatal((Object)"Task Run()");
        Thread.currentThread().setName("Informa Update Channel Task");
        var1_1 = this.builder;
        synchronized (var1_1) {
            block15: {
                if (this.info.getFormatDetected()) break block15;
                ** try [egrp 1[TRYBLOCK] [1, 2, 3 : 41->109)] { 
lbl8:
                // 1 sources

                {
                    this.builder.beginTransaction();
                    format = FormatDetector.getFormat(this.channel.getLocation());
                    this.channel.setFormat(format);
                    this.info.setFormatDetected(true);
                    this.channel.setLastUpdated(new Date());
                    this.builder.endTransaction();
                }
lbl18:
                // 1 sources

                catch (UnsupportedFormatException ex) {
                    UpdateChannelTask.logger.info((Object)"Unsupported format for Channel");
                    this.incrementProblems(ex);
                    return;
                }
lbl22:
                // 1 sources

                catch (IOException ioe) {
                    UpdateChannelTask.logger.info((Object)"Cannot retrieve Channel");
                    this.incrementProblems(ioe);
                    return;
                }
lbl26:
                // 1 sources

                catch (ChannelBuilderException e) {
                    e.printStackTrace();
                }
            }
            try {
                e = this.channel;
                synchronized (e) {
                    block17: {
                        block16: {
                            this.builder.beginTransaction();
                            tempChannel = RSSParser.parse(this.tempBuilder, this.channel.getLocation());
                            UpdateChannelTask.logger.info((Object)("Updating channel from " + this.channel.getLocation() + ": " + tempChannel + "(new)    " + this.channel + "(old)"));
                            InformaUtils.copyChannelProperties(tempChannel, this.channel);
                            this.builder.update(this.channel);
                            this.channel.setLastUpdated(new Date());
                            if (!tempChannel.getItems().isEmpty()) break block16;
                            UpdateChannelTask.logger.warn((Object)("No items found in channel " + this.channel));
                            break block17;
                        }
                        it = tempChannel.getItems().iterator();
                        break block18;
                    }
                    this.builder.endTransaction();
                }
            }
            catch (ParseException pe) {
                this.incrementProblems(pe);
            }
            catch (IOException ioe) {
                this.incrementProblems(ioe);
            }
            catch (ChannelBuilderException e) {
                e.printStackTrace();
            }
            return;
lbl-1000:
            // 1 sources

            {
                block18: {
                    item = (ItemIF)it.next();
                    if (!this.channel.getItems().contains(item)) {
                        UpdateChannelTask.logger.debug((Object)("Found new item: " + item));
                        this.channel.addItem(this.builder.createItem(null, item));
                    }
                }
                if (it.hasNext()) ** GOTO lbl-1000
            }
        }
    }

    private final void incrementProblems(Exception e) {
        this.info.increaseProblemsOccurred(e);
        if (this.info.shouldDeactivate()) {
            logger.warn((Object)("Deactivating channel after " + this.info.getNrProblemsOccurred() + " problems occurred."));
            this.registry.deactivateChannel(this.channel);
        }
        logger.warn((Object)e);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public UpdateChannelTask(ChannelRegistry registry, ChannelBuilderIF builder, ChannelIF channel, UpdateChannelInfo info) {
        this.registry = registry;
        this.channel = channel;
        this.builder = builder;
        this.info = info;
        this.tempBuilder = new ChannelBuilder();
    }

    static {
        Class clazz = class$de$nava$informa$utils$UpdateChannelTask;
        if (clazz == null) {
            clazz = class$de$nava$informa$utils$UpdateChannelTask = UpdateChannelTask.class$("[Lde.nava.informa.utils.UpdateChannelTask;", false);
        }
        logger = LogFactory.getLog((Class)clazz);
    }
}

