/*
 * Decompiled with CFR 0.152.
 */
package de.nava.informa.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jdom.Namespace;

public class XmlPathUtils {
    private static final String elementDelim = "/";
    private static final String prefixDelim = ":";

    public static String getElementValue(Element parent, String childPath) {
        if (parent == null) {
            return null;
        }
        Element child = XmlPathUtils.getLeafChild(parent, childPath);
        return child == null ? null : child.getTextTrim();
    }

    public static String[] getElementValues(Element parent, String childPath, String[] elements) {
        if (parent == null) {
            return null;
        }
        Element child = XmlPathUtils.getLeafChild(parent, childPath);
        return XmlPathUtils.getElementValues(child, elements);
    }

    public static String[] getElementValues(Element parent, String[] children) {
        if (parent == null || children == null) {
            return null;
        }
        int numValues = children.length;
        String[] elementValues = new String[numValues];
        int i = 0;
        while (i < numValues) {
            Element child = XmlPathUtils.getChild(parent, children[i]);
            elementValues[i] = child == null ? null : child.getTextTrim();
            ++i;
        }
        return elementValues;
    }

    public static String getAttributeValue(Element parent, String childPath, String attribute) {
        if (parent == null || attribute == null) {
            return null;
        }
        Element child = XmlPathUtils.getLeafChild(parent, childPath);
        return XmlPathUtils.getAttributeValue(child, attribute);
    }

    public static String[] getAttributeValues(Element parent, String childPath, String[] attributes) {
        if (parent == null || attributes == null) {
            return null;
        }
        Element child = XmlPathUtils.getLeafChild(parent, childPath);
        return XmlPathUtils.getAttributeValues(child, attributes);
    }

    public static String[] getAttributeValues(Element element, String[] attributes) {
        if (element == null || attributes == null) {
            return null;
        }
        int numAttributes = attributes.length;
        String[] attributeValues = new String[numAttributes];
        int i = 0;
        while (i < numAttributes) {
            attributeValues[i] = XmlPathUtils.getAttributeValue(element, attributes[i]);
            ++i;
        }
        return attributeValues;
    }

    private static final Element getLeafChild(Element parent, String childPath) {
        if (childPath == null) {
            return parent;
        }
        List elementNames = XmlPathUtils.getElementNames(childPath);
        Iterator iterator = elementNames.iterator();
        Element nextChild = parent;
        while (iterator.hasNext() && nextChild != null) {
            String elementName = (String)iterator.next();
            nextChild = XmlPathUtils.getChild(nextChild, elementName);
        }
        return nextChild;
    }

    private static final Element getChild(Element parent, String childName) {
        int prefixPos = childName.indexOf(prefixDelim);
        if (prefixPos == 0 || prefixPos >= childName.length() - 1) {
            return null;
        }
        if (prefixPos == -1) {
            return parent.getChild(childName, XmlPathUtils.getNamespace(parent, null));
        }
        String prefix = childName.substring(0, prefixPos);
        String childElementName = childName.substring(prefixPos + 1);
        return parent.getChild(childElementName, XmlPathUtils.getNamespace(parent, prefix));
    }

    private static final String getAttributeValue(Element element, String attribute) {
        if (element == null) {
            return null;
        }
        int prefixPos = attribute.indexOf(prefixDelim);
        if (prefixPos == 0 || prefixPos >= attribute.length() - 1) {
            return null;
        }
        if (prefixPos == -1) {
            return element.getAttributeValue(attribute);
        }
        String prefix = attribute.substring(0, prefixPos);
        String attributeName = attribute.substring(prefixPos + 1);
        return element.getAttributeValue(attributeName, XmlPathUtils.getNamespace(element, prefix));
    }

    private static final List getElementNames(String childPath) {
        ArrayList<String> strArray = new ArrayList<String>();
        if (childPath != null) {
            StringTokenizer st = new StringTokenizer(childPath, elementDelim);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0) continue;
                strArray.add(token);
            }
        }
        return strArray;
    }

    private static final Namespace getNamespace(Element element, String prefix) {
        Namespace namespace = prefix == null ? element.getNamespace("") : element.getNamespace(prefix);
        return namespace == null ? Namespace.NO_NAMESPACE : namespace;
    }

    private XmlPathUtils() {
    }
}

