/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.response;

import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DispositionReport
extends UDDIElement {
    public static String UDDI_TAG = "dispositionReport";
    String genericAttrib = null;
    String operatorAttrib = null;
    int errno = 0;
    String errCode = null;
    String errInfoText = null;
    public static final String E_assertionNotFound = "E_assertionNotFound";
    public static final String E_authTokenExpired = "E_authTokenExpired";
    public static final String E_authTokenRequired = "E_authTokenRequired";
    public static final String E_accountLimitExceeded = "E_accountLimitExceeded";
    public static final String E_busy = "E_busy";
    public static final String E_categorizationNotAllowed = "E_categorizationNotAllowed";
    public static final String E_fatalError = "E_fatalError";
    public static final String E_invalidKeyPassed = "E_invalidKeyPassed";
    public static final String E_invalidProjection = "E_invalidProjection";
    public static final String E_invalidCategory = "E_invalidCategory";
    public static final String E_invalidCompletionStatus = "E_invalidCompletionStatus";
    public static final String E_invalidURLPassed = "E_invalidURLPassed";
    public static final String E_invalidValue = "E_invalidValue";
    public static final String E_keyRetired = "E_keyRetired";
    public static final String E_languageError = "E_languageError";
    public static final String E_messageTooLarge = "E_messageTooLarge";
    public static final String E_nameTooLong = "E_nameTooLong";
    public static final String E_operatorMismatch = "E_operatorMismatch";
    public static final String E_publisherCancelled = "E_publisherCancelled";
    public static final String E_requestDenied = "E_requestDenied";
    public static final String E_requestTimeout = "E_requestTimeout";
    public static final String E_secretUnknown = "E_secretUnknown";
    public static final String E_success = "E_success";
    public static final String E_tooManyOptions = "E_tooManyOptions";
    public static final String E_transferAborted = "E_transferAborted";
    public static final String E_unrecognizedVersion = "E_unrecognizedVersion";
    public static final String E_unknownUser = "E_unknownUser";
    public static final String E_unsupported = "E_unsupported";
    public static final String E_unvalidatable = "E_unvalidatable";
    public static final String E_userMismatch = "E_userMismatch";
    public static final String E_valueNotAllowed = "E_valueNotAllowed";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DispositionReport(Element element) throws UDDIException {
        NodeList nodeList;
        boolean bl = false;
        UDDIException uDDIException = null;
        if (UDDIException.isValidElement(element)) {
            bl = true;
            uDDIException = new UDDIException(element, true);
            nodeList = uDDIException.getDetailElement().getElementsByTagName(UDDI_TAG);
            if (nodeList.getLength() <= 0) throw uDDIException;
            this.base = (Element)nodeList.item(0);
        } else {
            this.base = element;
        }
        if (this.isValidElement(this.base)) {
            this.genericAttrib = element.getAttribute("generic");
            this.operatorAttrib = element.getAttribute("operator");
            nodeList = element.getElementsByTagName("result");
            if (nodeList != null && nodeList.getLength() > 0) {
                Element element2 = (Element)nodeList.item(0);
                String string = element2.getAttribute("errno");
                Integer n = new Integer(string);
                this.errno = n;
                nodeList = element2.getElementsByTagName("errInfo");
                if (nodeList.getLength() > 0) {
                    element2 = (Element)nodeList.item(0);
                    this.errCode = element2.getAttribute("errCode");
                    this.errInfoText = this.getText(element2);
                }
            }
        }
        if (!bl) return;
        throw uDDIException;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrInfoText() {
        return this.errInfoText;
    }

    public int getErrno() {
        return this.errno;
    }

    public String getGeneric() {
        return this.genericAttrib;
    }

    public String getOperator() {
        return this.operatorAttrib;
    }

    public boolean isValidElement(Element element) {
        return element.getNodeName().equals(UDDI_TAG);
    }

    public void saveToXML(Element element) {
        this.base = element.getOwnerDocument().createElement(UDDI_TAG);
        if (this.genericAttrib != null) {
            this.base.setAttribute("generic", this.genericAttrib);
        }
        this.base.setAttribute("xmlns", UDDIElement.XMLNS);
        if (this.operatorAttrib != null) {
            this.base.setAttribute("operator", this.operatorAttrib);
        }
        if (this.errno != 0) {
            this.base.setAttribute("errno", new Integer(this.errno).toString());
        }
        if (this.errCode != null) {
            this.base.setAttribute("errCode", this.errCode);
        }
        if (this.errInfoText != null) {
            this.base.setAttribute("errInfoText", this.errInfoText);
        }
        element.appendChild(this.base);
    }

    public boolean success() {
        return this.errno == 0;
    }
}

