/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.DFA;
import JFlex.Emitter;
import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.LexParse;
import JFlex.LexScan;
import JFlex.MacroException;
import JFlex.NFA;
import JFlex.Out;
import JFlex.ScannerException;
import JFlex.Skeleton;
import JFlex.Timer;
import JFlex.gui.MainFrame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class Main
implements ErrorMessages {
    public static final String version = "1.3.5";
    public static final int PACK = 0;
    public static final int TABLE = 1;
    public static final int SWITCH = 2;
    public static boolean no_minimize = false;
    public static boolean no_backup = false;
    public static int gen_method = 0;

    public static void generate(File file) {
        Out.resetCounters();
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        LexScan lexScan = null;
        LexParse lexParse = null;
        FileReader fileReader = null;
        timer.start();
        try {
            Out.println("Reading \"" + file + "\"");
            fileReader = new FileReader(file);
            lexScan = new LexScan(fileReader);
            lexScan.setFile(file);
            lexParse = new LexParse(lexScan);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Out.error("Sorry, couldn't find the file \"" + file + "\"");
            throw new GeneratorException();
        }
        catch (IOException iOException) {
            Out.error("Sorry, error opening input file \"" + file + "\"");
            throw new GeneratorException();
        }
        try {
            NFA nFA = (NFA)lexParse.parse().value;
            Out.checkErrors();
            if (Out.DUMP) {
                Out.dump("NFA is" + Out.NL + nFA + Out.NL);
            }
            if (Out.DOT) {
                nFA.writeDot(Emitter.normalize("nfa.dot", null, null));
            }
            Out.println(nFA.numStates + " states in NFA");
            timer2.start();
            DFA dFA = nFA.getDFA();
            timer2.stop();
            Out.time("DFA construction took " + timer2);
            dFA.checkActions(lexScan, lexParse);
            nFA = null;
            if (Out.DUMP) {
                Out.dump("DFA is" + Out.NL + dFA + Out.NL);
            }
            if (Out.DOT) {
                dFA.writeDot(Emitter.normalize("dfa-big.dot", null, null));
            }
            timer2.start();
            dFA.minimize();
            timer2.stop();
            Out.time("Minimization took " + timer2);
            if (Out.DUMP) {
                Out.dump("Miniminal DFA is" + Out.NL + dFA);
            }
            if (Out.DOT) {
                dFA.writeDot(Emitter.normalize("dfa-min.dot", null, null));
            }
            timer2.start();
            Emitter emitter = new Emitter(file, lexParse, dFA);
            emitter.emit();
            timer2.stop();
            Out.time("Writing took " + timer2);
            timer.stop();
            Out.time("Overall scanner generation time : " + timer);
        }
        catch (ScannerException scannerException) {
            Out.error(scannerException.file, scannerException.message, scannerException.line, scannerException.column);
            throw new GeneratorException();
        }
        catch (MacroException macroException) {
            Out.error(macroException.getMessage());
            throw new GeneratorException();
        }
        catch (IOException iOException) {
            Out.error("An I/O-Error occured : " + iOException);
            throw new GeneratorException();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Out.error(33);
            throw new GeneratorException();
        }
        catch (GeneratorException generatorException) {
            throw new GeneratorException();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GeneratorException();
        }
    }

    public static void setDir(String string) {
        File file = new File(string);
        if (file.isFile()) {
            Out.error("Error: \"" + file + "\" is not a directory.");
            throw new GeneratorException();
        }
        if (!file.isDirectory() && !file.mkdirs()) {
            Out.error("Error: couldn't create directory \"" + file + "\"");
            throw new GeneratorException();
        }
        Emitter.directory = file;
    }

    public static Vector parseOptions(String[] stringArray) {
        Vector<File> vector = new Vector<File>();
        int n = 0;
        while (n < stringArray.length) {
            File file;
            if (stringArray[n].equals("-d")) {
                if (++n >= stringArray.length) {
                    Out.error(30);
                    System.exit(1);
                }
                Main.setDir(stringArray[n]);
            } else if (stringArray[n].equals("--skel") || stringArray[n].equals("-skel")) {
                if (++n >= stringArray.length) {
                    Out.error(31);
                    System.exit(1);
                }
                if (!(file = new File(stringArray[n])).isFile() || !file.canRead()) {
                    Out.error("Error: couldn't open \"" + file + "\".");
                    System.exit(1);
                }
                Skeleton.readSkelFile(file);
            } else if (stringArray[n].equals("-v") || stringArray[n].equals("--verbose") || stringArray[n].equals("-verbose")) {
                Out.VERBOSE = true;
            } else if (stringArray[n].equals("-q") || stringArray[n].equals("--quiet") || stringArray[n].equals("-quiet")) {
                Out.VERBOSE = false;
            } else if (stringArray[n].equals("--dump") || stringArray[n].equals("-dump")) {
                Out.DUMP = true;
            } else if (stringArray[n].equals("--time") || stringArray[n].equals("-time")) {
                Out.TIME = true;
            } else {
                if (stringArray[n].equals("--version") || stringArray[n].equals("-version")) {
                    Out.println("This is JFlex 1.3.5");
                    System.exit(0);
                }
                if (stringArray[n].equals("--dot") || stringArray[n].equals("-dot")) {
                    Out.DOT = true;
                } else {
                    if (stringArray[n].equals("--help") || stringArray[n].equals("-h") || stringArray[n].equals("/h")) {
                        Main.printUsage();
                        System.exit(0);
                    }
                    if (stringArray[n].equals("--info") || stringArray[n].equals("-info")) {
                        Out.printSystemInfo();
                        System.exit(0);
                    }
                    if (stringArray[n].equals("--nomin") || stringArray[n].equals("-nomin")) {
                        no_minimize = true;
                    } else if (stringArray[n].equals("--pack") || stringArray[n].equals("-pack")) {
                        gen_method = 0;
                    } else if (stringArray[n].equals("--table") || stringArray[n].equals("-table")) {
                        gen_method = 1;
                    } else if (stringArray[n].equals("--switch") || stringArray[n].equals("-switch")) {
                        gen_method = 2;
                    } else if (stringArray[n].equals("--nobak") || stringArray[n].equals("-nobak")) {
                        no_backup = true;
                    } else {
                        if (stringArray[n].startsWith("-")) {
                            Out.error("Error: unknown option \"" + stringArray[n] + "\"");
                            Main.printUsage();
                            System.exit(1);
                        }
                        if ((file = new File(stringArray[n])).isFile() && file.canRead()) {
                            vector.addElement(file);
                        } else {
                            Out.error("Sorry, couldn't open \"" + file + "\"");
                            throw new GeneratorException();
                        }
                    }
                }
            }
            ++n;
        }
        return vector;
    }

    public static void printUsage() {
        Out.println("");
        Out.println("Usage: jflex <options> <input-files>");
        Out.println("");
        Out.println("Where <options> can be one or more of");
        Out.println("-d <directory>   write generated file to <directory>");
        Out.println("--skel <file>    use external skeleton <file>");
        Out.println("--switch");
        Out.println("--table");
        Out.println("--pack           set default code generation method");
        Out.println("--nomin          skip minimization step");
        Out.println("--nobak          don't create backup files");
        Out.println("--dump           display transition tables");
        Out.println("--dot            write graphviz .dot files for the generated automata (alpha)");
        Out.println("--verbose");
        Out.println("-v               display generation progress messages (default)");
        Out.println("--quiet");
        Out.println("-q               display errors only");
        Out.println("--time           display generation time statistics");
        Out.println("--version        print the version number of this copy of jflex");
        Out.println("--info           print system + JDK information");
        Out.println("--help");
        Out.println("-h               print this message");
        Out.println("");
        Out.println("This is JFlex 1.3.5");
        Out.println("Have a nice day!");
    }

    public static void generate(String[] stringArray) {
        Vector vector = Main.parseOptions(stringArray);
        if (vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                Main.generate((File)vector.elementAt(n));
                ++n;
            }
        } else {
            new MainFrame();
        }
    }

    public static void main(String[] stringArray) {
        try {
            Main.generate(stringArray);
        }
        catch (GeneratorException generatorException) {
            Out.statistics();
            System.exit(1);
        }
    }
}

