/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HexDumpEncoder;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.SunJSSE_c;
import com.sun.net.ssl.internal.ssl.SunJSSE_f;
import com.sun.net.ssl.internal.ssl.SunJSSE_r;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;

final class InputRecord
extends ByteArrayInputStream
implements SunJSSE_f {
    private MessageDigest[] a;
    private MessageDigest[] b;
    private int c;
    private boolean d = false;
    private boolean e = false;
    private static final Debug f = Debug.getInstance("ssl");
    private static final byte[] g;

    static {
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[1] = 3;
        byArray[4] = 1;
        g = byArray;
    }

    InputRecord() {
        super(new byte[17433]);
        this.pos = 5;
        this.c = this.count = 5;
    }

    private void a(byte[] byArray) throws SSLException {
        int n;
        this.buf[0] = 22;
        this.buf[1] = this.buf[3];
        this.buf[2] = this.buf[4];
        this.buf[5] = 1;
        this.buf[9] = this.buf[1];
        this.buf[10] = this.buf[2];
        this.count = 11;
        int n2 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
        int n3 = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        int n4 = ((byArray[4] & 0xFF) << 8) + (byArray[5] & 0xFF);
        int n5 = 6 + n2 + n3;
        if (n4 < 32) {
            n = 0;
            while (n < 32 - n4) {
                this.buf[this.count++] = 0;
                ++n;
            }
            System.arraycopy(byArray, n5, this.buf, this.count, n4);
            this.count += n4;
        } else {
            System.arraycopy(byArray, n5 + (n4 - 32), this.buf, this.count, 32);
            this.count += 32;
        }
        this.buf[this.count++] = (byte)n3;
        System.arraycopy(byArray, n5 -= n3, this.buf, this.count, n3);
        this.count += n3;
        n5 -= n2;
        int n6 = this.count + 2;
        n = 0;
        while (n < n2) {
            if (byArray[n5 + n] == 0) {
                this.buf[n6++] = byArray[n5 + n + 1];
                this.buf[n6++] = byArray[n5 + n + 2];
            }
            n += 3;
        }
        this.buf[this.count++] = (byte)((n6 -= this.count + 2) >>> 8);
        this.buf[this.count++] = (byte)n6;
        this.count += n6;
        this.buf[this.count++] = 1;
        this.buf[this.count++] = 0;
        this.buf[3] = (byte)(this.count - 5);
        this.buf[4] = (byte)(this.count - 5 >>> 8);
        this.buf[6] = 0;
        this.buf[7] = (byte)(this.count - 5 - 4 >>> 8);
        this.buf[8] = (byte)(this.count - 5 - 4);
        this.pos = 5;
    }

    boolean a(MAC mAC) {
        int n = mAC.MAClen();
        if (n == 0) {
            return true;
        }
        int n2 = this.count - n;
        if (n2 < 5) {
            return false;
        }
        byte[] byArray = mAC.compute(this.contentType(), this.buf, 5, n2 - 5);
        if (n != byArray.length) {
            throw new RuntimeException("Internal MAC error");
        }
        int n3 = 0;
        while (n3 < n) {
            if (this.buf[n2 + n3] != byArray[n3]) {
                return false;
            }
            ++n3;
        }
        this.count -= n;
        return true;
    }

    public void close() {
        this.e = true;
        this.mark = 0;
        this.pos = 0;
        this.count = 0;
    }

    public byte contentType() {
        return this.buf[0];
    }

    void a(SunJSSE_c sunJSSE_c) throws SunJSSE_r {
        int n = this.count - 5;
        this.count = 5 + sunJSSE_c.a(this.buf, 5, n);
    }

    public void disableFormatChecks() {
        this.d = true;
    }

    void a() {
        int n = this.pos - this.c;
        if (n > 0) {
            this.a(this.buf, this.c, n);
            this.c = this.pos;
        }
    }

    MessageDigest[] b() {
        return this.a;
    }

    MessageDigest[] c() {
        return this.b;
    }

    private void a(byte[] byArray, int n, int n2) {
        if (f != null && Debug.isOn("data")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("[read] MD5 and SHA1 hashes:  len = " + n2);
                hexDumpEncoder.encodeBuffer(new ByteArrayInputStream(byArray, n, n2), (OutputStream)System.out);
            }
            catch (IOException iOException) {}
        }
        int n3 = 0;
        while (n3 < this.a.length) {
            if (this.a[n3] != null) {
                this.a[n3].update(byArray, n, n2);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.b.length) {
            if (this.b[n3] != null) {
                this.b[n3].update(byArray, n, n2);
            }
            ++n3;
        }
    }

    void a(int n) {
        if (n > 0) {
            this.pos += n;
            this.c = this.pos;
        }
    }

    void a(MessageDigest[] messageDigestArray, MessageDigest[] messageDigestArray2) {
        this.a = messageDigestArray;
        this.b = messageDigestArray2;
    }

    public void queueHandshake(InputRecord inputRecord) throws IOException {
        int n;
        this.a();
        if (this.pos > 5) {
            n = this.count - this.pos;
            if (n != 0) {
                System.arraycopy(this.buf, this.pos, this.buf, 5, n);
            }
            this.c = this.pos = 5;
            this.count = 5 + n;
        }
        if (this.buf.length < (n = inputRecord.available() + this.count)) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        System.arraycopy(inputRecord.buf, inputRecord.pos, this.buf, this.count, n - this.count);
        this.count = n;
        n = inputRecord.c - inputRecord.pos;
        if (this.pos == 5) {
            this.c += n;
        } else {
            throw new IOException("?? confused buffer hashing ??");
        }
    }

    public void read(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        if (this.e) {
            return;
        }
        try {
            n = InputRecord.a(inputStream, this.buf, 0, 5);
        }
        catch (IOException iOException) {
            throw new EOFException("SSL peer shut down incorrectly");
        }
        if (n == -1) {
            throw new EOFException("SSL peer shut down incorrectly");
        }
        if (n != 5) {
            throw new IOException("bad header read; count = " + n);
        }
        this.c = this.pos = 5;
        if (!this.d) {
            if (this.buf[0] != 22 && this.buf[0] != 21) {
                if ((this.buf[0] & 0x80) != 0 && this.buf[2] == 1) {
                    if (this.buf[3] == 3 && this.buf[4] >= 0) {
                        int n2 = ((this.buf[0] & 0x7F) << 8) + (this.buf[1] & 0xFF) - 3;
                        byte[] byArray = new byte[n2];
                        inputStream.read(byArray);
                        this.a(this.buf, 2, 3);
                        this.a(byArray, 0, n2);
                        this.a(byArray);
                        this.c = this.count;
                        this.d = true;
                        if (f != null && Debug.isOn("record")) {
                            System.out.println(String.valueOf(Thread.currentThread().getName()) + ", READ:  SSL v2, contentType = " + this.contentType() + ", translated length = " + this.available());
                        }
                        return;
                    }
                    try {
                        outputStream.write(g);
                        outputStream.flush();
                    }
                    catch (Exception exception) {}
                    throw new SSLException("Unsupported SSL v2.0 ClientHello");
                }
                if ((this.buf[0] & 0x80) != 0 && this.buf[2] == 4) {
                    throw new SSLException("SSL V2.0 servers are not supported.");
                }
                int n3 = 0;
                while (n3 < g.length) {
                    if (this.buf[n3] != g[n3]) {
                        throw new SSLException("Unrecognized SSL handshake.");
                    }
                    ++n3;
                }
                throw new SSLException("SSL V2.0 servers are not supported.");
            }
            if (this.buf[1] != 3 || this.buf[2] < 0) {
                throw new SSLProtocolException("Unsupported SSL version v" + this.buf[1] + "." + this.buf[2]);
            }
            this.d = true;
        } else if (this.buf[1] != 3 || this.buf[2] < 0) {
            throw new SSLProtocolException("Unsupported SSL message version.");
        }
        this.count = ((this.buf[3] & 0xFF) << 8) + (this.buf[4] & 0xFF);
        if (this.count < 0 || this.count > Short.MAX_VALUE) {
            throw new SSLProtocolException("Bad InputRecord size, count = " + this.count + ", buf.length = " + this.buf.length);
        }
        if (this.count > this.buf.length - 5) {
            byte[] byArray = new byte[this.count + 5];
            System.arraycopy(this.buf, 0, byArray, 0, 5);
            this.buf = byArray;
        }
        int n4 = 5;
        int n5 = this.count;
        n = 0;
        while (n != -1 && n5 != 0) {
            n = inputStream.read(this.buf, n4, n5);
            n4 += n;
            n5 -= n;
        }
        if (n == -1) {
            throw new EOFException("SSL peer shut down incorrectly");
        }
        this.count += 5;
        if (f != null && Debug.isOn("record")) {
            String string;
            switch (this.contentType()) {
                case 20: {
                    string = "Change Cipher Spec";
                    break;
                }
                case 21: {
                    string = "Alert";
                    break;
                }
                case 22: {
                    string = "Handshake";
                    break;
                }
                case 23: {
                    string = "Application Data";
                    break;
                }
                default: {
                    string = "contentType = " + this.contentType();
                }
            }
            if (this.count < 0 || this.count > 17428) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + ", Bad InputRecord size" + ", count = " + this.count);
            }
            System.out.println(String.valueOf(Thread.currentThread().getName()) + ", READ:  SSL v" + this.buf[1] + "." + this.buf[2] + " " + string + ", length = " + this.available());
        }
    }

    private static int a(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                return n4;
            }
            n3 += n4;
        }
        return n3;
    }
}

