/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.PacketTooBigException;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

class Buffer {
    static final int NO_LENGTH_LIMIT = -1;
    static long NULL_LENGTH;
    private int bufLength = 0;
    private byte[] byteBuffer;
    private int position = 0;
    private int sendLength = 0;
    private int maxLength = -1;
    private boolean wasMultiPacket = false;

    Buffer(byte[] buf) {
        this.byteBuffer = buf;
        this.setBufLength(buf.length);
    }

    Buffer(int size, int max_packet_size) {
        this.byteBuffer = new byte[size];
        this.setBufLength(this.byteBuffer.length);
        this.position = 4;
        this.setMaxLength(max_packet_size);
    }

    Buffer(int size) {
        this(size, -1);
    }

    public void setWasMultiPacket(boolean flag) {
        this.wasMultiPacket = flag;
    }

    public boolean wasMultiPacket() {
        return this.wasMultiPacket;
    }

    public void setByteBuffer(byte[] byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    final void setBytes(byte[] buf) {
        this.setSendLength(this.getBufLength());
        System.arraycopy(buf, 0, this.byteBuffer, 0, this.getBufLength());
    }

    final byte[] getBytes(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.byteBuffer, this.position, b, 0, len);
        this.position += len;
        return b;
    }

    final boolean isLastDataPacket() {
        return this.getBufLength() <= 2 && (this.byteBuffer[0] & 0xFF) == 254;
    }

    final byte[] getNullTerminatedBytes() {
        int i = this.position;
        int len = 0;
        while (this.byteBuffer[i] != 0 && i < this.getBufLength()) {
            ++len;
            ++i;
        }
        byte[] b = new byte[len];
        System.arraycopy(this.byteBuffer, this.position, b, 0, len);
        this.position += len + 1;
        return b;
    }

    final void clear() {
        this.position = 4;
    }

    final void dump() {
        int p = 0;
        int rows = this.getBufLength() / 8;
        int i = 0;
        while (i < rows) {
            int ptemp = p;
            int j = 0;
            while (j < 8) {
                String hexVal = Integer.toHexString(this.byteBuffer[ptemp]);
                if (hexVal.length() == 1) {
                    hexVal = "0" + hexVal;
                }
                System.out.print(hexVal + " ");
                ++ptemp;
                ++j;
            }
            System.out.print("    ");
            int j2 = 0;
            while (j2 < 8) {
                if (this.byteBuffer[p] > 32 && this.byteBuffer[p] < 127) {
                    System.out.print((char)this.byteBuffer[p] + " ");
                } else {
                    System.out.print(". ");
                }
                ++p;
                ++j2;
            }
            System.out.println();
            ++i;
        }
        int n = 0;
        int i2 = p;
        while (i2 < this.getBufLength()) {
            String hexVal = Integer.toHexString(this.byteBuffer[i2]);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(hexVal + " ");
            ++n;
            ++i2;
        }
        int i3 = n;
        while (i3 < 8) {
            System.out.print("   ");
            ++i3;
        }
        System.out.print("    ");
        int i4 = p;
        while (i4 < this.getBufLength()) {
            if (this.byteBuffer[i4] > 32 && this.byteBuffer[i4] < 127) {
                System.out.print((char)this.byteBuffer[i4] + " ");
            } else {
                System.out.print(". ");
            }
            ++i4;
        }
        System.out.println();
    }

    final void ensureCapacity(int additional_data) throws SQLException {
        if (this.position + additional_data > this.getBufLength()) {
            int newLength = (int)((double)this.getBufLength() * 1.25);
            if (newLength < this.getBufLength() + additional_data) {
                newLength = this.getBufLength() + (int)((double)additional_data * 1.25);
            }
            if (this.getMaxLength() != -1 && newLength > this.getMaxLength()) {
                throw new PacketTooBigException(newLength, this.getMaxLength());
            }
            byte[] newBytes = new byte[newLength];
            System.arraycopy(this.byteBuffer, 0, newBytes, 0, this.byteBuffer.length);
            this.byteBuffer = newBytes;
            this.setBufLength(this.byteBuffer.length);
        }
    }

    final long newReadLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return sw;
    }

    final byte readByte() {
        return this.byteBuffer[this.position++];
    }

    final byte[] readByteArray() {
        return this.getNullTerminatedBytes();
    }

    final long readFieldLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return NULL_LENGTH;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return sw;
    }

    final int readInt() {
        byte[] b = this.byteBuffer;
        return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8;
    }

    final byte[] readLenByteArray() {
        long len = this.readFieldLength();
        if (len == NULL_LENGTH) {
            return null;
        }
        if (len == 0L) {
            return new byte[0];
        }
        return this.getBytes((int)len);
    }

    final byte[] readLenByteArray(int offset) {
        long len = this.readFieldLength();
        if (len == NULL_LENGTH) {
            return null;
        }
        if (len == 0L) {
            return new byte[0];
        }
        this.position += offset;
        return this.getBytes((int)len);
    }

    final String fastReadLenString() {
        byte len = this.byteBuffer[this.position++];
        String result = StringUtils.toAsciiString3(this.byteBuffer, this.position, len);
        this.position += len;
        return result;
    }

    public int fastSkipLenString() {
        byte len = this.byteBuffer[this.position++];
        this.position += len;
        return len;
    }

    protected final byte[] getBufferSource() {
        return this.byteBuffer;
    }

    final String readLenString() {
        long len = this.readFieldLength();
        if (len == NULL_LENGTH) {
            return null;
        }
        if (len == 0L) {
            return "";
        }
        String S = new String(this.byteBuffer, this.position, (int)len);
        this.position = (int)((long)this.position + len);
        return S;
    }

    final long readLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return sw;
    }

    final long readLong() {
        byte[] b = this.byteBuffer;
        return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16 | (b[this.position++] & 0xFF) << 24;
    }

    final int readLongInt() {
        byte[] b = this.byteBuffer;
        return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16;
    }

    final long readLongLong() {
        byte[] b = this.byteBuffer;
        return (long)(b[this.position++] & 0xFF) | (long)(b[this.position++] & 0xFF) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24 | (long)(b[this.position++] & 0xFF) << 32 | (long)(b[this.position++] & 0xFF) << 40 | (long)(b[this.position++] & 0xFF) << 48 | (long)(b[this.position++] & 0xFF) << 56;
    }

    final String readString() {
        int i = this.position;
        int len = 0;
        while (this.byteBuffer[i] != 0 && i < this.getBufLength()) {
            ++len;
            ++i;
        }
        String s = new String(this.byteBuffer, this.position, len);
        this.position += len + 1;
        return s;
    }

    final void readStringNoop() {
        int i = this.position;
        int len = 0;
        while (this.byteBuffer[i] != 0 && i < this.getBufLength()) {
            ++len;
            ++i;
        }
        this.position += len + 1;
    }

    final int readnBytes() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 1: {
                return this.byteBuffer[this.position++] & 0xFF;
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLongInt();
            }
            case 4: {
                return (int)this.readLong();
            }
        }
        return 255;
    }

    final void writeByte(byte b) {
        this.byteBuffer[this.position++] = b;
    }

    final void writeBytesNoNull(byte[] Bytes) throws SQLException {
        int len = Bytes.length;
        this.ensureCapacity(len);
        System.arraycopy(Bytes, 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    final void writeBytesNoNull(byte[] Bytes, int offset, int length) throws SQLException {
        this.ensureCapacity(length);
        System.arraycopy(Bytes, offset, this.byteBuffer, this.position, length);
        this.position += length;
    }

    final void writeInt(int i) {
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
    }

    final void writeLong(long i) {
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFFL);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
    }

    final void writeLongInt(int i) {
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
    }

    final void writeLongLong(long i) {
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFFL);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
        b[this.position++] = (byte)(i >>> 32);
        b[this.position++] = (byte)(i >>> 40);
        b[this.position++] = (byte)(i >>> 48);
        b[this.position++] = (byte)(i >>> 56);
    }

    final void writeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        this.writeLongLong(l);
    }

    final void writeFloat(float f) {
        int i = Float.floatToIntBits(f);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
    }

    final void writeString(String s) throws SQLException {
        this.writeStringNoNull(s);
        this.byteBuffer[this.position++] = 0;
    }

    final void writeStringNoNull(String s) throws SQLException {
        int len = s.length();
        this.ensureCapacity(len);
        System.arraycopy(s.getBytes(), 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    final void writeStringNoNull(String s, String encoding) throws UnsupportedEncodingException, SQLException {
        byte[] b = s.getBytes(encoding);
        int len = b.length;
        this.ensureCapacity(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    void setBufLength(int bufLength) {
        this.bufLength = bufLength;
    }

    int getBufLength() {
        return this.bufLength;
    }

    void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    int getMaxLength() {
        return this.maxLength;
    }

    void setSendLength(int sendLength) {
        this.sendLength = sendLength;
    }

    int getSendLength() {
        return this.sendLength;
    }

    static {
        NO_LENGTH_LIMIT = -1;
        NULL_LENGTH = -1L;
    }
}

