/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import java.util.StringTokenizer;
import java.util.Vector;

public class ClientCallableStatement {

    class StoredProcedureArg {
        String name;
        String type;
        int size;
        String direction;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public StoredProcedureArg(String argDeclaration) {
            StringTokenizer st = new StringTokenizer(argDeclaration, " ", false);
            if (st.hasMoreTokens()) {
                this.name = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                String typeAndSize = st.nextToken();
                int parenIdx = typeAndSize.indexOf("(");
                if (parenIdx != -1) {
                    int endParenIdx = typeAndSize.indexOf(")", parenIdx);
                    if (endParenIdx == -1) throw new IllegalArgumentException("Stored procedure argument type size must be specified bewteen \"(\" and \")\"");
                    String sizeAsString = typeAndSize.substring(parenIdx, endParenIdx);
                    this.size = Integer.parseInt(sizeAsString);
                } else {
                    this.type = typeAndSize;
                }
            }
            this.direction = st.hasMoreTokens() ? st.nextToken() : "input";
            if (this.name == null) {
                throw new IllegalArgumentException("Stored procedure argument name must be given");
            }
            if (this.type == null) {
                throw new IllegalArgumentException("Stored procedure type must be given");
            }
            if (this.direction.equalsIgnoreCase("input") || this.direction.equalsIgnoreCase("output")) return;
            throw new IllegalArgumentException("Stored procedure argument direction must be either 'input' or 'output'");
        }
    }

    class ClientStoredProcedure {
        Vector args;
        String sql;

        ClientStoredProcedure() {
        }
    }
}

