/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.DatabaseMetaData;
import com.mysql.jdbc.Driver;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.Statement;
import java.io.EOFException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Connection
implements java.sql.Connection {
    private static final String PING_COMMAND = "SELECT 1";
    private static Hashtable mapTransIsolationName2Value;
    protected String database = null;
    protected boolean useUltraDevWorkAround = false;
    MysqlIO io = null;
    private boolean autoCommit = true;
    private boolean capitalizeDBMDTypes = false;
    private boolean doUnicode = false;
    private String encoding = null;
    private boolean hasIsolationLevels = false;
    private boolean hasQuotedIdentifiers = false;
    private boolean highAvailability = false;
    private String host = null;
    private double initialTimeout = 2.0;
    private boolean isClosed = true;
    private long lastQueryFinishedTime = 0L;
    private int maxAllowedPacket = 65536;
    private int maxReconnects = 3;
    private int maxRows = -1;
    private boolean maxRowsChanged = false;
    private final Object mutex = new Object();
    private Driver myDriver;
    private String myURL = null;
    private int netBufferLength = 16384;
    private String password = null;
    private int port = 3306;
    private boolean readOnly = false;
    private boolean relaxAutoCommit = false;
    private Hashtable serverVariables = null;
    private boolean strictFloatingPoint = false;
    private boolean transactionsSupported = false;
    private boolean useAnsiQuotes = false;
    private boolean useFastPing = false;
    private String user = null;
    private boolean useTimezone = false;
    private TimeZone serverTimezone = null;
    private ArrayList hostList = null;
    private int hostListSize = 0;
    private boolean failedOver = false;
    private int isolationLevel = 2;

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.transactionsSupported) {
            String sql = "SET autocommit=" + (autoCommit ? "1" : "0");
            this.execSQL(sql, -1);
            this.autoCommit = autoCommit;
        } else {
            if (!autoCommit && !this.relaxAutoCommit) {
                throw new SQLException("MySQL Versions Older than 3.23.15 do not support transactions", "08003");
            }
            this.autoCommit = autoCommit;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void setCatalog(String catalog) throws SQLException {
        this.execSQL("USE " + catalog, -1);
        this.database = catalog;
    }

    public String getCatalog() throws SQLException {
        return this.database;
    }

    public boolean isClosedNoPing() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() throws SQLException {
        if (!this.isClosed) {
            try {
                Object object = this.mutex;
                synchronized (object) {
                    this.ping();
                }
            }
            catch (Exception E) {
                this.isClosed = true;
            }
        }
        return this.isClosed;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setHoldability(int arg0) throws SQLException {
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public long getIdleFor() {
        if (this.lastQueryFinishedTime == 0L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long idleTime = now - this.lastQueryFinishedTime;
        return idleTime;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        return new DatabaseMetaData(this, this.database);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new NotImplemented();
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new NotImplemented();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        StringBuffer sql;
        if (this.hasIsolationLevels) {
            sql = new StringBuffer("SET SESSION TRANSACTION ISOLATION LEVEL ");
            switch (level) {
                case 0: {
                    throw new SQLException("Transaction isolation level NONE not supported by MySQL");
                }
                case 2: {
                    sql.append("READ COMMITTED");
                    break;
                }
                case 1: {
                    sql.append("READ UNCOMMITTED");
                    break;
                }
                case 4: {
                    sql.append("REPEATABLE READ");
                    break;
                }
                case 8: {
                    sql.append("SERIALIZABLE");
                    break;
                }
                default: {
                    throw new SQLException("Unsupported transaction isolation level '" + level + "'", "S1C00");
                }
            }
        } else {
            throw new SQLException("Transaction Isolation Levels are not supported on MySQL versions older than 3.23.36.", "S1C00");
        }
        this.execSQL(sql.toString(), -1);
        this.isolationLevel = level;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.isolationLevel;
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Map getTypeMap() throws SQLException {
        throw new NotImplemented();
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean capitalizeDBMDTypes() {
        return this.capitalizeDBMDTypes;
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        if (this.io != null) {
            try {
                this.io.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.io = null;
        }
        this.isClosed = true;
    }

    public void commit() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Commit attempt on closed connection.", "08003");
        }
        if (this.autoCommit && !this.relaxAutoCommit) {
            throw new SQLException("Can't call commit when autocommit=true");
        }
        if (this.transactionsSupported) {
            this.execSQL("commit", -1);
        }
    }

    /*
     * Loose catch block
     */
    public void connectionInit(String host, int port, Properties info, String database, String url, Driver d) throws SQLException {
        this.hostList = new ArrayList();
        if (host == null) {
            this.host = "localhost";
            this.hostList.add(this.host);
        } else if (host.indexOf(",") != -1) {
            StringTokenizer hostTokenizer = new StringTokenizer(host, ",", false);
            while (hostTokenizer.hasMoreTokens()) {
                this.hostList.add(hostTokenizer.nextToken().trim());
            }
        } else {
            this.host = host;
            this.hostList.add(this.host);
        }
        this.hostListSize = this.hostList.size();
        this.port = port;
        if (database == null) {
            throw new SQLException("Malformed URL '" + url + "'.", "S1000");
        }
        this.database = database;
        this.myURL = url;
        this.myDriver = d;
        this.user = info.getProperty("user");
        this.password = info.getProperty("password");
        if (this.user == null || this.user.equals("")) {
            this.user = "nobody";
        }
        if (this.password == null) {
            this.password = "";
        }
        if (info.getProperty("relaxAutoCommit") != null) {
            this.relaxAutoCommit = info.getProperty("relaxAutoCommit").toUpperCase().equals("TRUE");
        }
        if (info.getProperty("autoReconnect") != null) {
            this.highAvailability = info.getProperty("autoReconnect").toUpperCase().equals("TRUE");
        }
        if (info.getProperty("capitalizeTypeNames") != null) {
            this.capitalizeDBMDTypes = info.getProperty("capitalizeTypeNames").toUpperCase().equals("TRUE");
        }
        if (info.getProperty("ultraDevHack") != null) {
            this.useUltraDevWorkAround = info.getProperty("ultraDevHack").toUpperCase().equals("TRUE");
        }
        if (info.getProperty("strictFloatingPoint") != null) {
            this.strictFloatingPoint = info.getProperty("strictFloatingPoint").toUpperCase().equals("TRUE");
        }
        if (this.highAvailability) {
            if (info.getProperty("maxReconnects") != null) {
                try {
                    int n;
                    this.maxReconnects = n = Integer.parseInt(info.getProperty("maxReconnects"));
                }
                catch (NumberFormatException NFE) {
                    throw new SQLException("Illegal parameter '" + info.getProperty("maxReconnects") + "' for maxReconnects", "0S100");
                }
            }
            if (info.getProperty("initialTimeout") != null) {
                try {
                    double n;
                    this.initialTimeout = n = (double)Integer.parseInt(info.getProperty("initialTimeout"));
                }
                catch (NumberFormatException NFE) {
                    throw new SQLException("Illegal parameter '" + info.getProperty("initialTimeout") + "' for initialTimeout", "0S100");
                }
            }
        }
        if (info.getProperty("maxRows") != null) {
            try {
                int n = Integer.parseInt(info.getProperty("maxRows"));
                if (n == 0) {
                    n = -1;
                }
                this.maxRows = n;
            }
            catch (NumberFormatException NFE) {
                throw new SQLException("Illegal parameter '" + info.getProperty("maxRows") + "' for maxRows", "0S100");
            }
        }
        if (info.getProperty("useUnicode") != null) {
            String useUnicode = info.getProperty("useUnicode").toUpperCase();
            if (useUnicode.startsWith("TRUE")) {
                this.doUnicode = true;
            }
            if (info.getProperty("characterEncoding") != null) {
                this.encoding = info.getProperty("characterEncoding");
                try {
                    String testString = "abc";
                    testString.getBytes(this.encoding);
                }
                catch (UnsupportedEncodingException UE) {
                    throw new SQLException("Unsupported character encoding '" + this.encoding + "'.", "0S100");
                }
            }
        }
        try {
            block53: {
                block54: {
                    SQLException sqlE22;
                    ResultSet results;
                    Statement stmt;
                    block52: {
                        this.createNewIO();
                        this.isClosed = false;
                        this.serverVariables = new Hashtable();
                        if (this.io.versionMeetsMinimum(3, 22, 1)) {
                            this.useFastPing = true;
                        }
                        if (!this.io.versionMeetsMinimum(3, 21, 22)) break block53;
                        stmt = null;
                        results = null;
                        stmt = (Statement)this.createStatement();
                        results = (ResultSet)stmt.executeQuery("SHOW VARIABLES");
                        while (results.next()) {
                            this.serverVariables.put(results.getString(1), results.getString(2));
                        }
                        Object var11_19 = null;
                        if (results == null) break block52;
                        try {
                            results.close();
                        }
                        catch (SQLException sqlE22) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqlE22) {}
                    }
                    break block54;
                    {
                        catch (SQLException e) {
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        SQLException sqlE22;
                        Object var11_20 = null;
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (SQLException sqlE22) {
                                // empty catch block
                            }
                        }
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException sqlE22) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                if (this.serverVariables.containsKey("max_allowed_packet")) {
                    this.maxAllowedPacket = Integer.parseInt((String)this.serverVariables.get("max_allowed_packet"));
                }
                if (this.serverVariables.containsKey("net_buffer_length")) {
                    this.netBufferLength = Integer.parseInt((String)this.serverVariables.get("net_buffer_length"));
                }
                this.checkTransactionIsolationLevel();
                this.checkServerEncoding();
            }
            this.transactionsSupported = this.io.versionMeetsMinimum(3, 23, 15);
            this.hasIsolationLevels = this.io.versionMeetsMinimum(3, 23, 36);
            String profileSql = info.getProperty("profileSql");
            if (profileSql != null && profileSql.trim().equalsIgnoreCase("true")) {
                this.io.setProfileSql(true);
            } else {
                this.io.setProfileSql(false);
            }
            this.hasQuotedIdentifiers = this.io.versionMeetsMinimum(3, 23, 6);
            if (this.serverVariables.containsKey("sql_mode")) {
                int sqlMode = Integer.parseInt((String)this.serverVariables.get("sql_mode"));
                this.useAnsiQuotes = (sqlMode & 4) > 0;
            }
            this.io.resetMaxBuf();
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SQLException("Cannot connect to MySQL server on " + this.host + ":" + this.port + ". Is there a MySQL server running on the machine/port you are trying to connect to? (" + ex.getClass().getName() + ")", "08S01");
        }
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt = new Statement(this, this.database);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    public java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1004, 1007);
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    public void finalize() throws Throwable {
        if (this.io != null && !this.isClosed()) {
            this.close();
        } else if (this.io != null) {
            this.io.forceClose();
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.useUltraDevWorkAround) {
            return new UltraDevWorkAround(this.prepareStatement(sql));
        }
        throw new SQLException("Callable statments not supported.", "S1C00");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql);
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new NotImplemented();
    }

    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1004, 1007);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pStmt = new PreparedStatement(this, sql, this.database);
        pStmt.setResultSetType(resultSetType);
        pStmt.setResultSetConcurrency(resultSetConcurrency);
        return pStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        return this.prepareStatement(sql);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new NotImplemented();
    }

    public void rollback() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Rollback attempt on closed connection.", "08003");
        }
        if (this.autoCommit && !this.relaxAutoCommit) {
            throw new SQLException("Can't call commit when autocommit=true", "08003");
        }
        if (this.transactionsSupported) {
            this.execSQL("rollback", -1);
        }
    }

    public void rollback(Savepoint arg0) throws SQLException {
        throw new NotImplemented();
    }

    public boolean supportsIsolationLevel() {
        return this.hasIsolationLevels;
    }

    public boolean supportsQuotedIdentifiers() {
        return this.hasQuotedIdentifiers;
    }

    public boolean supportsTransactions() {
        return this.transactionsSupported;
    }

    public boolean useStrictFloatingPoint() {
        return this.strictFloatingPoint;
    }

    public boolean useUnicode() {
        return this.doUnicode;
    }

    protected MysqlIO getIO() {
        return this.io;
    }

    protected MysqlIO createNewIO() throws SQLException {
        MysqlIO newIo = null;
        if (!this.highAvailability && !this.failedOver) {
            int hostIndex = 0;
            while (hostIndex < this.hostListSize) {
                block29: {
                    try {
                        this.io = new MysqlIO(this.hostList.get(hostIndex).toString(), this.port, this);
                        this.io.init(this.user, this.password);
                        if (this.database.length() != 0) {
                            this.io.sendCommand(2, this.database, null);
                        }
                        if (hostIndex != 0) {
                            this.setReadOnly(true);
                            this.failedOver = true;
                        } else {
                            this.failedOver = false;
                            this.setReadOnly(false);
                        }
                        break;
                    }
                    catch (SQLException sqlEx) {
                        try {
                            if (this.io != null) {
                                this.io.forceClose();
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        String sqlState = sqlEx.getSQLState();
                        if (sqlState == null || !sqlState.equals("08S01")) {
                            throw sqlEx;
                        }
                    }
                    catch (Exception unknownException) {
                        try {
                            if (this.io != null) {
                                this.io.forceClose();
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (this.hostListSize - 1 != hostIndex) break block29;
                        throw new SQLException("Unable to connect to any hosts due to exception: " + unknownException.toString(), "08S01");
                    }
                }
                ++hostIndex;
            }
        } else {
            double timeout = this.initialTimeout;
            boolean connectionGood = false;
            int hostIndex = 0;
            while (hostIndex < this.hostListSize) {
                int attemptCount = 0;
                while (attemptCount < this.maxReconnects) {
                    try {
                        if (this.io != null) {
                            try {
                                this.io.forceClose();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        this.io = new MysqlIO(this.hostList.get(hostIndex).toString(), this.port, this);
                        this.io.init(this.user, this.password);
                        if (this.database.length() != 0) {
                            this.io.sendCommand(2, this.database, null);
                        }
                        this.ping();
                        connectionGood = true;
                        if (hostIndex != 0) {
                            this.setReadOnly(true);
                            this.failedOver = true;
                            break;
                        }
                        this.failedOver = false;
                        this.setReadOnly(false);
                        break;
                    }
                    catch (Exception EEE) {
                        boolean i = false;
                        if (connectionGood) break;
                        try {
                            Thread.currentThread();
                            Thread.sleep((long)timeout * 1000L);
                            timeout *= timeout;
                        }
                        catch (InterruptedException IE) {
                            // empty catch block
                        }
                        ++attemptCount;
                    }
                }
                if (!connectionGood) {
                    throw new SQLException("Server connection failure during transaction. \nAttemtped reconnect " + this.maxReconnects + " times. Giving up.", "08001");
                }
                ++hostIndex;
            }
        }
        return newIo;
    }

    int getMaxAllowedPacket() {
        return this.maxAllowedPacket;
    }

    Object getMutex() throws SQLException {
        if (this.io == null) {
            throw new SQLException("Connection.close() has already been called. Invalid operation in this state.", "08003");
        }
        return this.mutex;
    }

    int getNetBufferLength() {
        return this.netBufferLength;
    }

    int getServerMajorVersion() {
        return this.io.getServerMajorVersion();
    }

    int getServerMinorVersion() {
        return this.io.getServerMinorVersion();
    }

    int getServerSubMinorVersion() {
        return this.io.getServerSubMinorVersion();
    }

    String getServerVersion() {
        return this.io.getServerVersion();
    }

    String getURL() {
        return this.myURL;
    }

    String getUser() {
        return this.user;
    }

    ResultSet execSQL(String sql, int maxRowsToRetreive) throws SQLException {
        return this.execSQL(sql, maxRowsToRetreive, null, 1007);
    }

    ResultSet execSQL(String sql, int maxRows, int resultSetType, boolean streamResults) throws SQLException {
        return this.execSQL(sql, maxRows, null, resultSetType, streamResults);
    }

    ResultSet execSQL(String sql, int maxRows, Buffer packet) throws SQLException {
        return this.execSQL(sql, maxRows, packet, 1007);
    }

    ResultSet execSQL(String sql, int maxRows, Buffer packet, int resultSetType) throws SQLException {
        return this.execSQL(sql, maxRows, packet, resultSetType, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResultSet execSQL(String sql, int maxRows, Buffer packet, int resultSetType, boolean streamResults) throws SQLException {
        Object object = this.mutex;
        synchronized (object) {
            ResultSet encoding2;
            block15: {
                ResultSet resultSet;
                block14: {
                    this.lastQueryFinishedTime = 0L;
                    if (this.highAvailability || this.failedOver) {
                        try {
                            this.ping();
                        }
                        catch (Exception Ex) {
                            this.createNewIO();
                        }
                    }
                    try {
                        int realMaxRows;
                        int n = realMaxRows = maxRows == -1 ? 50000000 : maxRows;
                        if (packet == null) {
                            String encoding2 = null;
                            if (this.useUnicode()) {
                                encoding2 = this.getEncoding();
                            }
                            resultSet = this.io.sqlQuery(sql, realMaxRows, encoding2, this, resultSetType, streamResults);
                            Object var13_15 = null;
                            break block14;
                        }
                        encoding2 = this.io.sqlQueryDirect(packet, realMaxRows, this, resultSetType, streamResults);
                        break block15;
                    }
                    catch (EOFException eofE) {
                        try {
                            throw new SQLException("Lost connection to server during query", "08007");
                            catch (SQLException sqlE) {
                                throw sqlE;
                            }
                            catch (Exception ex) {
                                String exceptionType = ex.getClass().getName();
                                String exceptionMessage = ex.getMessage();
                                throw new SQLException("Error during query: Unexpected Exception: " + exceptionType + " message given: " + exceptionMessage, "S1000");
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_17 = null;
                            this.lastQueryFinishedTime = System.currentTimeMillis();
                            throw throwable;
                        }
                    }
                }
                this.lastQueryFinishedTime = System.currentTimeMillis();
                return resultSet;
            }
            Object var13_16 = null;
            this.lastQueryFinishedTime = System.currentTimeMillis();
            return encoding2;
        }
    }

    synchronized void maxRowsChanged() {
        this.maxRowsChanged = true;
    }

    boolean useAnsiQuotedIdentifiers() {
        return this.useAnsiQuotes;
    }

    synchronized boolean useMaxRows() {
        return this.maxRowsChanged;
    }

    private void checkServerEncoding() throws SQLException {
        if (this.useUnicode() && this.getEncoding() == null) {
            this.encoding = (String)this.serverVariables.get("character_set");
            if (this.encoding != null) {
                if (Character.isLowerCase(this.encoding.charAt(0))) {
                    char[] ach = this.encoding.toCharArray();
                    ach[0] = Character.toUpperCase(this.encoding.charAt(0));
                    this.encoding = new String(ach);
                }
                try {
                    String TestString = "abc";
                    TestString.getBytes(this.encoding);
                }
                catch (UnsupportedEncodingException UE) {
                    this.encoding = null;
                }
            }
        }
    }

    private void checkTransactionIsolationLevel() throws SQLException {
        Integer intTI;
        String s = (String)this.serverVariables.get("transaction_isolation");
        if (s != null && (intTI = (Integer)mapTransIsolationName2Value.get(s)) != null) {
            this.isolationLevel = intTI;
        }
    }

    private void ping() throws Exception {
        if (this.useFastPing) {
            this.io.sendCommand(14, null, null);
        } else {
            this.io.sqlQuery(PING_COMMAND, 50000000, 1007, false);
        }
    }

    public boolean useTimezone() {
        return this.useTimezone;
    }

    public TimeZone getServerTimezone() {
        return this.serverTimezone;
    }

    static {
        PING_COMMAND = PING_COMMAND;
        mapTransIsolationName2Value = null;
        mapTransIsolationName2Value = new Hashtable(8);
        mapTransIsolationName2Value.put("READ-UNCOMMITED", new Integer(1));
        mapTransIsolationName2Value.put("READ-COMMITTED", new Integer(2));
        mapTransIsolationName2Value.put("REPEATABLE-READ", new Integer(4));
        mapTransIsolationName2Value.put("SERIALIZABLE", new Integer(8));
    }

    class UltraDevWorkAround
    implements CallableStatement {
        java.sql.PreparedStatement delegate = null;

        UltraDevWorkAround(java.sql.PreparedStatement pstmt) {
            this.delegate = pstmt;
        }

        public void setArray(int p1, Array p2) throws SQLException {
            this.delegate.setArray(p1, p2);
        }

        public Array getArray(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Array getArray(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setAsciiStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setAsciiStream(p1, p2, p3);
        }

        public void setAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setBigDecimal(int p1, BigDecimal p2) throws SQLException {
            this.delegate.setBigDecimal(p1, p2);
        }

        public void setBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
            throw new NotImplemented();
        }

        public BigDecimal getBigDecimal(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public BigDecimal getBigDecimal(int p1, int p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public BigDecimal getBigDecimal(String arg0) throws SQLException {
            return null;
        }

        public void setBinaryStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setBinaryStream(p1, p2, p3);
        }

        public void setBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setBlob(int p1, Blob p2) throws SQLException {
            this.delegate.setBlob(p1, p2);
        }

        public Blob getBlob(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Blob getBlob(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setBoolean(int p1, boolean p2) throws SQLException {
            this.delegate.setBoolean(p1, p2);
        }

        public void setBoolean(String arg0, boolean arg1) throws SQLException {
            throw new NotImplemented();
        }

        public boolean getBoolean(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public boolean getBoolean(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setByte(int p1, byte p2) throws SQLException {
            this.delegate.setByte(p1, p2);
        }

        public void setByte(String arg0, byte arg1) throws SQLException {
            throw new NotImplemented();
        }

        public byte getByte(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public byte getByte(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setBytes(int p1, byte[] p2) throws SQLException {
            this.delegate.setBytes(p1, p2);
        }

        public void setBytes(String arg0, byte[] arg1) throws SQLException {
            throw new NotImplemented();
        }

        public byte[] getBytes(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public byte[] getBytes(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setCharacterStream(int p1, Reader p2, int p3) throws SQLException {
            this.delegate.setCharacterStream(p1, p2, p3);
        }

        public void setCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setClob(int p1, Clob p2) throws SQLException {
            this.delegate.setClob(p1, p2);
        }

        public Clob getClob(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Clob getClob(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.Connection getConnection() throws SQLException {
            return this.delegate.getConnection();
        }

        public void setCursorName(String p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void setDate(int p1, Date p2) throws SQLException {
            this.delegate.setDate(p1, p2);
        }

        public void setDate(int p1, Date p2, Calendar p3) throws SQLException {
            this.delegate.setDate(p1, p2, p3);
        }

        public void setDate(String arg0, Date arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setDate(String arg0, Date arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Date getDate(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Date getDate(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Date getDate(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Date getDate(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setDouble(int p1, double p2) throws SQLException {
            this.delegate.setDouble(p1, p2);
        }

        public void setDouble(String arg0, double arg1) throws SQLException {
            throw new NotImplemented();
        }

        public double getDouble(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public double getDouble(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setEscapeProcessing(boolean p1) throws SQLException {
            this.delegate.setEscapeProcessing(p1);
        }

        public void setFetchDirection(int p1) throws SQLException {
            this.delegate.setFetchDirection(p1);
        }

        public int getFetchDirection() throws SQLException {
            return this.delegate.getFetchDirection();
        }

        public void setFetchSize(int p1) throws SQLException {
            this.delegate.setFetchSize(p1);
        }

        public int getFetchSize() throws SQLException {
            return this.delegate.getFetchSize();
        }

        public void setFloat(int p1, float p2) throws SQLException {
            this.delegate.setFloat(p1, p2);
        }

        public void setFloat(String arg0, float arg1) throws SQLException {
            throw new NotImplemented();
        }

        public float getFloat(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public float getFloat(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.ResultSet getGeneratedKeys() throws SQLException {
            return this.delegate.getGeneratedKeys();
        }

        public void setInt(int p1, int p2) throws SQLException {
            this.delegate.setInt(p1, p2);
        }

        public void setInt(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public int getInt(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getInt(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setLong(int p1, long p2) throws SQLException {
            this.delegate.setLong(p1, p2);
        }

        public void setLong(String arg0, long arg1) throws SQLException {
            throw new NotImplemented();
        }

        public long getLong(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public long getLong(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setMaxFieldSize(int p1) throws SQLException {
            this.delegate.setMaxFieldSize(p1);
        }

        public int getMaxFieldSize() throws SQLException {
            return this.delegate.getMaxFieldSize();
        }

        public void setMaxRows(int p1) throws SQLException {
            this.delegate.setMaxRows(p1);
        }

        public int getMaxRows() throws SQLException {
            return this.delegate.getMaxRows();
        }

        public ResultSetMetaData getMetaData() throws SQLException {
            throw new SQLException("Not supported");
        }

        public boolean getMoreResults() throws SQLException {
            return this.delegate.getMoreResults();
        }

        public boolean getMoreResults(int arg0) throws SQLException {
            return this.delegate.getMoreResults();
        }

        public void setNull(int p1, int p2) throws SQLException {
            this.delegate.setNull(p1, p2);
        }

        public void setNull(int p1, int p2, String p3) throws SQLException {
            this.delegate.setNull(p1, p2, p3);
        }

        public void setNull(String arg0, int arg1, String arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setNull(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(int p1, Object p2) throws SQLException {
            this.delegate.setObject(p1, p2);
        }

        public void setObject(int p1, Object p2, int p3) throws SQLException {
            this.delegate.setObject(p1, p2, p3);
        }

        public void setObject(int p1, Object p2, int p3, int p4) throws SQLException {
            this.delegate.setObject(p1, p2, p3, p4);
        }

        public void setObject(String arg0, Object arg1, int arg2, int arg3) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(String arg0, Object arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(String arg0, Object arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Object getObject(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Object getObject(int p1, Map p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Object getObject(String arg0, Map arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Object getObject(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public ParameterMetaData getParameterMetaData() throws SQLException {
            return this.delegate.getParameterMetaData();
        }

        public void setQueryTimeout(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getQueryTimeout() throws SQLException {
            return this.delegate.getQueryTimeout();
        }

        public void setRef(int p1, Ref p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Ref getRef(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Ref getRef(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.ResultSet getResultSet() throws SQLException {
            return this.delegate.getResultSet();
        }

        public int getResultSetConcurrency() throws SQLException {
            return this.delegate.getResultSetConcurrency();
        }

        public int getResultSetHoldability() throws SQLException {
            return this.delegate.getResultSetHoldability();
        }

        public int getResultSetType() throws SQLException {
            return this.delegate.getResultSetType();
        }

        public void setShort(int p1, short p2) throws SQLException {
            this.delegate.setShort(p1, p2);
        }

        public void setShort(String arg0, short arg1) throws SQLException {
            throw new NotImplemented();
        }

        public short getShort(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public short getShort(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setString(int p1, String p2) throws SQLException {
            this.delegate.setString(p1, p2);
        }

        public void setString(String arg0, String arg1) throws SQLException {
            throw new NotImplemented();
        }

        public String getString(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public String getString(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setTime(int p1, Time p2) throws SQLException {
            this.delegate.setTime(p1, p2);
        }

        public void setTime(int p1, Time p2, Calendar p3) throws SQLException {
            this.delegate.setTime(p1, p2, p3);
        }

        public void setTime(String arg0, Time arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setTime(String arg0, Time arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Time getTime(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Time getTime(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Time getTime(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Time getTime(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setTimestamp(int p1, Timestamp p2) throws SQLException {
            this.delegate.setTimestamp(p1, p2);
        }

        public void setTimestamp(int p1, Timestamp p2, Calendar p3) throws SQLException {
            this.delegate.setTimestamp(p1, p2, p3);
        }

        public void setTimestamp(String arg0, Timestamp arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setTimestamp(String arg0, Timestamp arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Timestamp getTimestamp(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Timestamp getTimestamp(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Timestamp getTimestamp(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setURL(String arg0, URL arg1) throws SQLException {
            throw new NotImplemented();
        }

        public void setURL(int arg0, URL arg1) throws SQLException {
            this.delegate.setURL(arg0, arg1);
        }

        public URL getURL(int arg0) throws SQLException {
            throw new NotImplemented();
        }

        public URL getURL(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setUnicodeStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setUnicodeStream(p1, p2, p3);
        }

        public int getUpdateCount() throws SQLException {
            return this.delegate.getUpdateCount();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        public void addBatch() throws SQLException {
            this.delegate.addBatch();
        }

        public void addBatch(String p1) throws SQLException {
            this.delegate.addBatch(p1);
        }

        public void cancel() throws SQLException {
            this.delegate.cancel();
        }

        public void clearBatch() throws SQLException {
            this.delegate.clearBatch();
        }

        public void clearParameters() throws SQLException {
            this.delegate.clearParameters();
        }

        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        public void close() throws SQLException {
            this.delegate.close();
        }

        public boolean execute() throws SQLException {
            return this.delegate.execute();
        }

        public boolean execute(String p1) throws SQLException {
            return this.delegate.execute(p1);
        }

        public boolean execute(String arg0, int arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public boolean execute(String arg0, int[] arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public boolean execute(String arg0, String[] arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public int[] executeBatch() throws SQLException {
            return this.delegate.executeBatch();
        }

        public java.sql.ResultSet executeQuery() throws SQLException {
            return this.delegate.executeQuery();
        }

        public java.sql.ResultSet executeQuery(String p1) throws SQLException {
            return this.delegate.executeQuery(p1);
        }

        public int executeUpdate() throws SQLException {
            return this.delegate.executeUpdate();
        }

        public int executeUpdate(String p1) throws SQLException {
            return this.delegate.executeUpdate(p1);
        }

        public int executeUpdate(String arg0, int arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public int executeUpdate(String arg0, int[] arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public int executeUpdate(String arg0, String[] arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public void registerOutParameter(int p1, int p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(int p1, int p2, int p3) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(int p1, int p2, String p3) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(String arg0, int arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void registerOutParameter(String arg0, int arg1, String arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void registerOutParameter(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public boolean wasNull() throws SQLException {
            throw new SQLException("Not supported");
        }
    }
}

