/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.MysqlDefs;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowDataStatic;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static final byte[] TABLE_AS_BYTES = "TABLE".getBytes();
    protected Connection conn;
    protected String database = null;
    protected String quotedId = null;

    public DatabaseMetaData(Connection Conn, String Database) {
        this.conn = Conn;
        this.database = Database;
        try {
            this.quotedId = this.conn.supportsQuotedIdentifiers() ? this.getIdentifierQuoteString() : "";
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public java.sql.ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_CAT", 1, 32), new Field("", "TYPE_SCHEM", 1, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "ATTR_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 32), new Field("", "ATTR_TYPE_NAME", 1, 32), new Field("", "ATTR_SIZE", 4, 32), new Field("", "DECIMAL_DIGITS", 4, 32), new Field("", "NUM_PREC_RADIX", 4, 32), new Field("", "NULLABLE ", 4, 32), new Field("", "REMARKS", 1, 32), new Field("", "ATTR_DEF", 1, 32), new Field("", "SQL_DATA_TYPE", 4, 32), new Field("", "SQL_DATETIME_SUB", 4, 32), new Field("", "CHAR_OCTET_LENGTH", 4, 32), new Field("", "ORDINAL_POSITION", 4, 32), new Field("", "IS_NULLABLE", 1, 32), new Field("", "SCOPE_CATALOG", 1, 32), new Field("", "SCOPE_SCHEMA", 1, 32), new Field("", "SCOPE_TABLE", 1, 32), new Field("", "SOURCE_DATA_TYPE", 5, 32)};
        return this.buildResultSet(fields, new ArrayList(), this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getBestRowIdentifier(String catalog, String Schema, String table, int scope, boolean nullable) throws SQLException {
        java.sql.ResultSet resultSet;
        ResultSet results;
        block17: {
            Field[] fields = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "COLUMN_SIZE", 4, 10), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "PSEUDO_COLUMN", 5, 5)};
            String databasePart = "";
            if (catalog != null) {
                if (!catalog.equals("")) {
                    databasePart = " FROM " + this.quotedId + catalog + this.quotedId;
                }
            } else {
                databasePart = " FROM " + this.quotedId + this.database + this.quotedId;
            }
            if (table == null) {
                throw new SQLException("Table not specified.", "S1009");
            }
            results = null;
            try {
                results = this.conn.execSQL("show columns from " + table + databasePart, -1);
                results.setConnection(this.conn);
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                while (results.next()) {
                    String keyType = results.getString("Key");
                    if (keyType == null || !keyType.toUpperCase().startsWith("PRI")) continue;
                    byte[][] rowVal = new byte[8][];
                    rowVal[0] = Integer.toString(2).getBytes();
                    rowVal[1] = results.getBytes("Field");
                    String type = results.getString("Type");
                    int size = MysqlIO.getMaxBuf();
                    int decimals = 0;
                    if (type.indexOf("enum") != -1) {
                        String temp = type.substring(type.indexOf("("), type.indexOf(")"));
                        StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                        int maxLength = 0;
                        while (tokenizer.hasMoreTokens()) {
                            maxLength = Math.max(maxLength, tokenizer.nextToken().length() - 2);
                        }
                        size = maxLength;
                        decimals = 0;
                        type = "enum";
                    } else if (type.indexOf("(") != -1) {
                        if (type.indexOf(",") != -1) {
                            size = Integer.parseInt(type.substring(type.indexOf("(") + 1, type.indexOf(",")));
                            decimals = Integer.parseInt(type.substring(type.indexOf(",") + 1, type.indexOf(")")));
                        } else {
                            size = Integer.parseInt(type.substring(type.indexOf("(") + 1, type.indexOf(")")));
                        }
                        type = type.substring(type.indexOf("("));
                    }
                    rowVal[2] = new byte[0];
                    rowVal[3] = this.s2b(type);
                    rowVal[4] = Integer.toString(size + decimals).getBytes();
                    rowVal[5] = Integer.toString(size + decimals).getBytes();
                    rowVal[6] = Integer.toString(decimals).getBytes();
                    rowVal[7] = Integer.toString(1).getBytes();
                    tuples.add(rowVal);
                }
                resultSet = this.buildResultSet(fields, tuples, this.conn);
                Object var19_18 = null;
                if (results == null) break block17;
            }
            catch (Throwable throwable) {
                Object var19_19 = null;
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException sqlEx) {
                        // empty catch block
                    }
                }
                results = null;
                throw throwable;
            }
            try {
                results.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        results = null;
        return resultSet;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getCatalogs() throws SQLException {
        SQLException sqlEx22;
        java.sql.ResultSet resultSet;
        Statement stmt;
        block11: {
            java.sql.ResultSet results = null;
            stmt = null;
            try {
                stmt = this.conn.createStatement();
                results = stmt.executeQuery("SHOW DATABASES");
                ResultSetMetaData resultsMD = results.getMetaData();
                Field[] fields = new Field[]{new Field("", "TABLE_CAT", 12, resultsMD.getColumnDisplaySize(1))};
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                while (results.next()) {
                    byte[][] rowVal = new byte[][]{results.getBytes(1)};
                    tuples.add(rowVal);
                }
                resultSet = this.buildResultSet(fields, tuples, this.conn);
                Object var8_7 = null;
                if (results == null) break block11;
            }
            catch (Throwable throwable) {
                block14: {
                    SQLException sqlEx22;
                    Object var8_8 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException sqlEx22) {
                            // empty catch block
                        }
                        results = null;
                    }
                    if (stmt == null) break block14;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlEx22) {
                        // empty catch block
                    }
                    stmt = null;
                }
                throw throwable;
            }
            try {
                results.close();
            }
            catch (SQLException sqlEx22) {
                // empty catch block
            }
            results = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sqlEx22) {
                // empty catch block
            }
            stmt = null;
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public java.sql.ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 64), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 64), new Field("", "COLUMN_NAME", 1, 64), new Field("", "GRANTOR", 1, 77), new Field("", "GRANTEE", 1, 77), new Field("", "PRIVILEGE", 1, 64), new Field("", "IS_GRANTABLE", 1, 3)};
        StringBuffer grantQuery = new StringBuffer("SELECT c.host, c.db, t.grantor, c.user, c.table_name, c.column_name, c.column_priv from mysql.columns_priv c, mysql.tables_priv t where c.host = t.host and c.db = t.db and c.table_name = t.table_name ");
        if (catalog != null && catalog.length() != 0) {
            grantQuery.append(" AND c.db='");
            grantQuery.append(catalog);
            grantQuery.append("' ");
        }
        grantQuery.append(" AND c.table_name ='");
        grantQuery.append(table);
        grantQuery.append("' AND c.column_name like '");
        grantQuery.append(columnNamePattern);
        grantQuery.append("'");
        ResultSet results = null;
        ArrayList<byte[][]> grantRows = new ArrayList<byte[][]>();
        try {
            results = this.conn.execSQL(grantQuery.toString(), -1);
            results.setConnection(this.conn);
            while (results.next()) {
                String host = results.getString(1);
                String database = results.getString(2);
                String grantor = results.getString(3);
                String user = results.getString(4);
                if (user == null || user.length() == 0) {
                    user = "%";
                }
                StringBuffer fullUser = new StringBuffer(user);
                if (host != null) {
                    fullUser.append("@");
                    fullUser.append(host);
                }
                String columnName = results.getString(6);
                String allPrivileges = results.getString(7);
                if (allPrivileges == null) continue;
                allPrivileges = allPrivileges.toUpperCase();
                StringTokenizer st = new StringTokenizer(allPrivileges, ",");
                while (st.hasMoreTokens()) {
                    String privilege = st.nextToken().trim();
                    byte[][] tuple = new byte[][]{this.s2b(database), null, this.s2b(table), this.s2b(columnName), (byte[])(grantor != null ? this.s2b(grantor) : null), this.s2b(fullUser.toString()), this.s2b(privilege), null};
                    grantRows.add(tuple);
                }
            }
            Object var20_19 = null;
            if (results == null) return this.buildResultSet(fields, grantRows, this.conn);
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            if (results == null) throw throwable;
            try {
                results.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            results.close();
            return this.buildResultSet(fields, grantRows, this.conn);
        }
        catch (Exception ex) {}
        return this.buildResultSet(fields, grantRows, this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getColumns(String catalog, String schemaPattern, String tableName, String columnNamePattern) throws SQLException {
        int tablenameLength;
        ArrayList<String> tableNameList;
        String databasePart;
        block98: {
            String tableNameFromList;
            java.sql.ResultSet tables;
            databasePart = "";
            if (columnNamePattern == null) {
                columnNamePattern = "%";
            }
            if (catalog != null) {
                if (!catalog.equals("")) {
                    databasePart = " FROM " + this.quotedId + catalog + this.quotedId;
                }
            } else {
                databasePart = " FROM " + this.quotedId + this.database + this.quotedId;
            }
            tableNameList = new ArrayList<String>();
            tablenameLength = 0;
            if (tableName == null) {
                tables = null;
                try {
                    tables = this.getTables(catalog, schemaPattern, "%", new String[0]);
                    while (tables.next()) {
                        tableNameFromList = tables.getString("TABLE_NAME");
                        tableNameList.add(tableNameFromList);
                        if (tableNameFromList.length() <= tablenameLength) continue;
                        tablenameLength = tableNameFromList.length();
                    }
                    Object var11_11 = null;
                    if (tables == null) break block98;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Exception sqlEx) {
                            // empty catch block
                        }
                        tables = null;
                    }
                    throw throwable;
                }
                try {
                    tables.close();
                }
                catch (Exception sqlEx) {
                    // empty catch block
                }
                tables = null;
                {
                    break block98;
                }
            }
            tables = null;
            try {
                tables = this.getTables(catalog, schemaPattern, tableName, new String[0]);
                while (tables.next()) {
                    tableNameFromList = tables.getString("TABLE_NAME");
                    tableNameList.add(tableNameFromList);
                    if (tableNameFromList.length() <= tablenameLength) continue;
                    tablenameLength = tableNameFromList.length();
                }
                Object var14_17 = null;
                if (tables == null) break block98;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (tables != null) {
                    try {
                        tables.close();
                    }
                    catch (SQLException sqlEx) {
                        // empty catch block
                    }
                    tables = null;
                }
                throw throwable;
            }
            try {
                tables.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
            tables = null;
            {
            }
        }
        int catalogLength = 0;
        if (catalog != null) {
            catalogLength = catalog.length();
        } else {
            catalog = "";
            catalogLength = 0;
        }
        Iterator tableNames = tableNameList.iterator();
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, catalogLength), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, tablenameLength), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10), new Field("", "NULLABLE", 4, 10), new Field("", "REMARKS", 1, 0), new Field("", "COLUMN_DEF", 1, 0), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "CHAR_OCTET_LENGTH", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "ORDINAL_POSITION", 4, 10), new Field("", "IS_NULLABLE", 1, 3)};
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        while (tableNames.hasNext()) {
            ResultSet results;
            block101: {
                SQLException sqlEx2;
                Object var23_31;
                String tableNamePattern = (String)tableNames.next();
                results = null;
                try {
                    results = this.conn.execSQL("show columns from " + tableNamePattern + databasePart + " like '" + columnNamePattern + "'", -1);
                    results.setConnection(this.conn);
                    ResultSetMetaData resultsMD = results.getMetaData();
                    int ordPos = 1;
                    while (results.next()) {
                        byte[][] rowVal = new byte[18][];
                        rowVal[0] = this.s2b(catalog);
                        rowVal[1] = new byte[0];
                        rowVal[2] = this.s2b(tableNamePattern);
                        rowVal[3] = results.getBytes("Field");
                        String typeInfo = results.getString("Type");
                        String mysqlType = "";
                        mysqlType = typeInfo.indexOf("(") != -1 ? typeInfo.substring(0, typeInfo.indexOf("(")) : typeInfo;
                        if (this.conn.capitalizeDBMDTypes()) {
                            mysqlType = mysqlType.toUpperCase();
                        }
                        rowVal[4] = Integer.toString(MysqlDefs.mysqlToJavaType(mysqlType)).getBytes();
                        rowVal[5] = this.s2b(mysqlType);
                        if (typeInfo != null) {
                            String size;
                            if (typeInfo.indexOf("enum") != -1 || typeInfo.indexOf("set") != -1) {
                                String temp = typeInfo.substring(typeInfo.indexOf("("), typeInfo.lastIndexOf(")"));
                                StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                                int maxLength = 0;
                                while (tokenizer.hasMoreTokens()) {
                                    maxLength = Math.max(maxLength, tokenizer.nextToken().length() - 2);
                                }
                                rowVal[6] = Integer.toString(maxLength).getBytes();
                                rowVal[8] = new byte[]{48};
                            } else if (typeInfo.indexOf(",") != -1) {
                                size = typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(","));
                                String decimals = typeInfo.substring(typeInfo.indexOf(",") + 1, typeInfo.indexOf(")"));
                                rowVal[6] = this.s2b(size);
                                rowVal[8] = this.s2b(decimals);
                            } else {
                                size = "0";
                                if (typeInfo.indexOf("(") != -1) {
                                    size = typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(")"));
                                } else if (typeInfo.toLowerCase().equals("tinyint")) {
                                    size = "1";
                                } else if (typeInfo.toLowerCase().equals("smallint")) {
                                    size = "6";
                                } else if (typeInfo.toLowerCase().equals("mediumint")) {
                                    size = "6";
                                } else if (typeInfo.toLowerCase().equals("int")) {
                                    size = "11";
                                } else if (typeInfo.toLowerCase().equals("integer")) {
                                    size = "11";
                                } else if (typeInfo.toLowerCase().equals("bigint")) {
                                    size = "25";
                                } else if (typeInfo.toLowerCase().equals("int24")) {
                                    size = "25";
                                } else if (typeInfo.toLowerCase().equals("real")) {
                                    size = "12";
                                } else if (typeInfo.toLowerCase().equals("float")) {
                                    size = "12";
                                } else if (typeInfo.toLowerCase().equals("decimal")) {
                                    size = "12";
                                } else if (typeInfo.toLowerCase().equals("numeric")) {
                                    size = "12";
                                } else if (typeInfo.toLowerCase().equals("double")) {
                                    size = "22";
                                } else if (typeInfo.toLowerCase().equals("char")) {
                                    size = "1";
                                } else if (typeInfo.toLowerCase().equals("varchar")) {
                                    size = "255";
                                } else if (typeInfo.toLowerCase().equals("date")) {
                                    size = "10";
                                } else if (typeInfo.toLowerCase().equals("time")) {
                                    size = "8";
                                } else if (typeInfo.toLowerCase().equals("timestamp")) {
                                    size = "19";
                                } else if (typeInfo.toLowerCase().equals("datetime")) {
                                    size = "19";
                                } else if (typeInfo.toLowerCase().equals("tinyblob")) {
                                    size = "255";
                                } else if (typeInfo.toLowerCase().equals("blob")) {
                                    size = Integer.toString(Math.min(65535, MysqlIO.getMaxBuf()));
                                } else if (typeInfo.toLowerCase().equals("mediumblob")) {
                                    size = Integer.toString(Math.min(16277215, MysqlIO.getMaxBuf()));
                                } else if (typeInfo.toLowerCase().equals("longblob")) {
                                    size = Integer.toString(MysqlIO.getMaxBuf()).compareTo("2147483657") < 0 ? Integer.toString(MysqlIO.getMaxBuf()) : "2147483657";
                                } else if (typeInfo.toLowerCase().equals("tinytext")) {
                                    size = "255";
                                } else if (typeInfo.toLowerCase().equals("text")) {
                                    size = "65535";
                                } else if (typeInfo.toLowerCase().equals("mediumtext")) {
                                    size = Integer.toString(Math.min(16277215, MysqlIO.getMaxBuf()));
                                } else if (typeInfo.toLowerCase().equals("enum")) {
                                    size = "255";
                                } else if (typeInfo.toLowerCase().equals("set")) {
                                    size = "255";
                                }
                                rowVal[6] = size.getBytes();
                                rowVal[8] = new byte[]{48};
                            }
                        } else {
                            rowVal[8] = new byte[]{48};
                            rowVal[6] = new byte[]{48};
                        }
                        rowVal[7] = Integer.toString(MysqlIO.MAXBUF).getBytes();
                        rowVal[9] = new byte[]{49, 48};
                        String nullable = results.getString("Null");
                        if (nullable != null) {
                            if (nullable.equals("YES")) {
                                rowVal[10] = Integer.toString(1).getBytes();
                                rowVal[17] = new String("YES").getBytes();
                            } else {
                                rowVal[10] = Integer.toString(0).getBytes();
                                rowVal[17] = "NO".getBytes();
                            }
                        } else {
                            rowVal[10] = Integer.toString(0).getBytes();
                            rowVal[17] = "NO".getBytes();
                        }
                        try {
                            rowVal[11] = results.getBytes("Extra");
                        }
                        catch (Exception E) {
                            rowVal[11] = new byte[0];
                        }
                        byte[] defaultVal = results.getBytes("Default");
                        rowVal[12] = defaultVal != null ? defaultVal : new byte[0];
                        rowVal[13] = new byte[]{48};
                        rowVal[14] = new byte[]{48};
                        rowVal[15] = rowVal[6];
                        rowVal[16] = Integer.toString(ordPos++).getBytes();
                        tuples.add(rowVal);
                    }
                    var23_31 = null;
                    if (results == null) break block101;
                }
                catch (Throwable throwable) {
                    var23_31 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException sqlEx2) {
                            // empty catch block
                        }
                    }
                    results = null;
                    throw throwable;
                }
                try {
                    results.close();
                }
                catch (SQLException sqlEx2) {
                    // empty catch block
                }
            }
            results = null;
            {
            }
        }
        java.sql.ResultSet Results = this.buildResultSet(fields, tuples, this.conn);
        return Results;
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 0), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        if (this.conn.getIO().versionMeetsMinimum(3, 23, 0)) {
            java.sql.ResultSet resultSet;
            block14: {
                String databasePart = "";
                if (foreignCatalog != null) {
                    if (!foreignCatalog.equals("")) {
                        databasePart = " FROM " + foreignCatalog;
                    }
                } else {
                    databasePart = " FROM " + this.database;
                }
                if (primaryTable == null) {
                    throw new SQLException("Table not specified.", "S1009");
                }
                ResultSet fkresults = null;
                try {
                    fkresults = this.conn.execSQL("show table status " + databasePart, -1);
                    fkresults.setConnection(this.conn);
                    ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                    while (fkresults.next()) {
                        String dummy;
                        String comment;
                        String tableType = fkresults.getString("Type");
                        if (tableType == null || !tableType.toLowerCase().equals("innodb") || (comment = fkresults.getString("Comment")) == null) continue;
                        StringTokenizer commentTokens = new StringTokenizer(comment, ";", false);
                        if (commentTokens.hasMoreTokens()) {
                            dummy = commentTokens.nextToken();
                        }
                        int keySeq = 0;
                        while (commentTokens.hasMoreTokens()) {
                            String keys = commentTokens.nextToken();
                            StringTokenizer keyTokens = new StringTokenizer(keys, "() /", false);
                            byte[][] tuple = new byte[14][];
                            tuple[4] = foreignCatalog == null ? null : this.s2b(foreignCatalog);
                            tuple[5] = foreignSchema == null ? null : this.s2b(foreignSchema);
                            dummy = fkresults.getString("Name");
                            if (dummy.compareTo(foreignTable) != 0) continue;
                            tuple[6] = this.s2b(dummy);
                            tuple[7] = this.s2b(keyTokens.nextToken());
                            dummy = keyTokens.nextToken();
                            tuple[0] = this.s2b(keyTokens.nextToken());
                            tuple[1] = primarySchema == null ? null : this.s2b(primarySchema);
                            dummy = keyTokens.nextToken();
                            if (dummy.compareTo(primaryTable) != 0) continue;
                            tuple[2] = this.s2b(primaryTable);
                            tuple[3] = this.s2b(keyTokens.nextToken());
                            tuple[8] = Integer.toString(keySeq).getBytes();
                            tuple[9] = Integer.toString(4).getBytes();
                            tuple[10] = Integer.toString(4).getBytes();
                            tuple[11] = null;
                            tuple[12] = null;
                            tuple[13] = Integer.toString(7).getBytes();
                            tuples.add(tuple);
                            ++keySeq;
                        }
                    }
                    resultSet = this.buildResultSet(fields, tuples, this.conn);
                    Object var20_19 = null;
                    if (fkresults == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var20_20 = null;
                    if (fkresults != null) {
                        try {
                            fkresults.close();
                        }
                        catch (Exception sqlEx) {
                            // empty catch block
                        }
                        fkresults = null;
                    }
                    throw throwable;
                }
                try {
                    fkresults.close();
                }
                catch (Exception sqlEx) {
                    // empty catch block
                }
                fkresults = null;
            }
            return resultSet;
        }
        return this.buildResultSet(fields, new ArrayList(), this.conn);
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.conn.getServerMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.conn.getServerMinorVersion();
    }

    public String getDatabaseProductName() throws SQLException {
        return "MySQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.conn.getServerVersion();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.conn.supportsIsolationLevel()) {
            return 2;
        }
        return 0;
    }

    public int getDriverMajorVersion() {
        return 3;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public String getDriverName() throws SQLException {
        return "MySQL-AB JDBC Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "3.0.0-beta";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 0), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        if (this.conn.getIO().versionMeetsMinimum(3, 23, 0)) {
            java.sql.ResultSet resultSet;
            ResultSet fkresults;
            block14: {
                String databasePart = "";
                if (catalog != null) {
                    if (!catalog.equals("")) {
                        databasePart = " FROM " + catalog;
                    }
                } else {
                    databasePart = " FROM " + this.database;
                }
                if (table == null) {
                    throw new SQLException("Table not specified.", "S1009");
                }
                fkresults = null;
                try {
                    fkresults = this.conn.execSQL("show table status " + databasePart, -1);
                    fkresults.setConnection(this.conn);
                    ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                    while (fkresults.next()) {
                        String dummy;
                        String comment;
                        String tableType = fkresults.getString("Type");
                        if (tableType == null || !tableType.toLowerCase().equals("innodb") || (comment = fkresults.getString("Comment")) == null) continue;
                        StringTokenizer commentTokens = new StringTokenizer(comment, ";", false);
                        if (commentTokens.hasMoreTokens()) {
                            dummy = commentTokens.nextToken();
                        }
                        int keySeq = 0;
                        while (commentTokens.hasMoreTokens()) {
                            String keys = commentTokens.nextToken();
                            StringTokenizer keyTokens = new StringTokenizer(keys, "() /", false);
                            byte[][] tuple = new byte[14][];
                            tuple[4] = catalog == null ? new byte[]{} : this.s2b(catalog);
                            tuple[5] = null;
                            tuple[6] = fkresults.getBytes("Name");
                            tuple[7] = this.s2b(keyTokens.nextToken());
                            dummy = keyTokens.nextToken();
                            tuple[0] = this.s2b(keyTokens.nextToken());
                            tuple[1] = null;
                            dummy = keyTokens.nextToken();
                            if (dummy.compareTo(table) != 0) continue;
                            tuple[2] = this.s2b(table);
                            tuple[3] = this.s2b(keyTokens.nextToken());
                            tuple[8] = Integer.toString(keySeq).getBytes();
                            tuple[9] = Integer.toString(4).getBytes();
                            tuple[10] = Integer.toString(4).getBytes();
                            tuple[11] = null;
                            tuple[12] = null;
                            tuple[13] = Integer.toString(7).getBytes();
                            tuples.add(tuple);
                            ++keySeq;
                        }
                    }
                    resultSet = this.buildResultSet(fields, tuples, this.conn);
                    Object var17_16 = null;
                    if (fkresults == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var17_17 = null;
                    if (fkresults != null) {
                        try {
                            fkresults.close();
                        }
                        catch (SQLException sqlEx) {
                            // empty catch block
                        }
                    }
                    fkresults = null;
                    throw throwable;
                }
                try {
                    fkresults.close();
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
            }
            fkresults = null;
            return resultSet;
        }
        return this.buildResultSet(fields, new ArrayList(), this.conn);
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (this.conn.supportsQuotedIdentifiers()) {
            if (!this.conn.useAnsiQuotedIdentifiers()) {
                return "`";
            }
            return "\"";
        }
        return " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 0), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        if (this.conn.getIO().versionMeetsMinimum(3, 23, 0)) {
            java.sql.ResultSet resultSet;
            ResultSet fkresults;
            block14: {
                String databasePart = "";
                if (catalog != null) {
                    if (!catalog.equals("")) {
                        databasePart = " from " + catalog;
                    }
                } else {
                    databasePart = " from " + this.database;
                }
                if (table == null) {
                    throw new SQLException("Table not specified.", "S1009");
                }
                fkresults = null;
                try {
                    fkresults = this.conn.execSQL("show table status " + databasePart + " like '" + table + "'", -1);
                    fkresults.setConnection(this.conn);
                    ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                    while (fkresults.next()) {
                        String dummy;
                        String comment;
                        String tableType = fkresults.getString("Type");
                        if (tableType == null || !tableType.toLowerCase().equals("innodb") || (comment = fkresults.getString("Comment")) == null) continue;
                        StringTokenizer commentTokens = new StringTokenizer(comment, ";", false);
                        if (commentTokens.hasMoreTokens()) {
                            dummy = commentTokens.nextToken();
                        }
                        int keySeq = 0;
                        while (commentTokens.hasMoreTokens()) {
                            String keys = commentTokens.nextToken();
                            byte[][] tuple = new byte[14][];
                            StringTokenizer keyTokens = new StringTokenizer(keys, "() /", false);
                            tuple[4] = catalog == null ? new byte[]{} : this.s2b(catalog);
                            tuple[5] = null;
                            tuple[6] = this.s2b(table);
                            tuple[7] = this.s2b(keyTokens.nextToken());
                            dummy = keyTokens.nextToken();
                            tuple[0] = this.s2b(keyTokens.nextToken());
                            tuple[1] = null;
                            tuple[2] = this.s2b(keyTokens.nextToken());
                            tuple[3] = this.s2b(keyTokens.nextToken());
                            tuple[8] = Integer.toString(keySeq).getBytes();
                            tuple[9] = Integer.toString(4).getBytes();
                            tuple[10] = Integer.toString(4).getBytes();
                            tuple[11] = null;
                            tuple[12] = null;
                            tuple[13] = Integer.toString(7).getBytes();
                            tuples.add(tuple);
                            ++keySeq;
                        }
                    }
                    resultSet = this.buildResultSet(fields, tuples, this.conn);
                    Object var17_16 = null;
                    if (fkresults == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var17_17 = null;
                    if (fkresults != null) {
                        try {
                            fkresults.close();
                        }
                        catch (SQLException sqlEx) {
                            // empty catch block
                        }
                    }
                    fkresults = null;
                    throw throwable;
                }
                try {
                    fkresults.close();
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
            }
            fkresults = null;
            return resultSet;
        }
        return this.buildResultSet(fields, new ArrayList(), this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getIndexInfo(String catalog, String Schema, String Table, boolean unique, boolean approximate) throws SQLException {
        java.sql.ResultSet resultSet;
        ResultSet results;
        block10: {
            String databasePart = "";
            if (catalog != null) {
                if (!catalog.equals("")) {
                    databasePart = " FROM " + this.quotedId + catalog + this.quotedId;
                }
            } else {
                databasePart = " FROM " + this.quotedId + this.database + this.quotedId;
            }
            results = null;
            try {
                java.sql.ResultSet indexInfo;
                results = this.conn.execSQL("SHOW INDEX FROM " + Table + databasePart, -1);
                results.setConnection(this.conn);
                Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "NON_UNIQUE", 1, 3), new Field("", "INDEX_QUALIFIER", 1, 1), new Field("", "INDEX_NAME", 1, 32), new Field("", "TYPE", 1, 32), new Field("", "ORDINAL_POSITION", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "ASC_OR_DESC", 1, 1), new Field("", "CARDINALITY", 1, 32), new Field("", "PAGES", 4, 10), new Field("", "FILTER_CONDITION", 1, 32)};
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                while (results.next()) {
                    byte[][] Tuple = new byte[14][];
                    Tuple[0] = catalog == null ? new byte[]{} : this.s2b(catalog);
                    Tuple[1] = new byte[0];
                    Tuple[2] = results.getBytes("Table");
                    Tuple[3] = results.getInt("Non_unique") != 0 ? this.s2b("true") : this.s2b("false");
                    Tuple[4] = new byte[0];
                    Tuple[5] = results.getBytes("Key_name");
                    Tuple[6] = Integer.toString(3).getBytes();
                    Tuple[7] = results.getBytes("Seq_in_index");
                    Tuple[8] = results.getBytes("Column_name");
                    Tuple[9] = results.getBytes("Collation");
                    Tuple[10] = results.getBytes("Cardinality");
                    Tuple[11] = this.s2b("0");
                    Tuple[12] = null;
                    tuples.add(Tuple);
                }
                resultSet = indexInfo = this.buildResultSet(fields, tuples, this.conn);
                Object var13_12 = null;
                if (results == null) break block10;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException sqlEx) {
                        // empty catch block
                    }
                }
                results = null;
                throw throwable;
            }
            try {
                results.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        results = null;
        return resultSet;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 32;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 256;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 512;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 64;
    }

    public int getMaxIndexLength() throws SQLException {
        return 256;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0x7FFFFFF7;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxStatementLength() throws SQLException {
        return MysqlIO.MAXBUF - 4;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 64;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 256;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 16;
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,BIT_COUNT,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MAX,MIN,MOD,PI,POW,POWER,RADIANS,RAND,ROUND,SIN,SQRT,TAN,TRUNCATE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        java.sql.ResultSet resultSet;
        ResultSet rs;
        block12: {
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "COLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 5), new Field("", "PK_NAME", 1, 32)};
            String dbSub = "";
            if (catalog != null) {
                if (!catalog.equals("")) {
                    dbSub = " FROM " + this.quotedId + catalog + this.quotedId;
                }
            } else {
                dbSub = " FROM " + this.quotedId + this.database + this.quotedId;
            }
            if (table == null) {
                throw new SQLException("Table not specified.", "S1009");
            }
            rs = null;
            try {
                rs = this.conn.execSQL("show keys from " + table + dbSub, -1);
                rs.setConnection(this.conn);
                ArrayList tuples = new ArrayList();
                TreeMap<String, byte[][]> sortMap = new TreeMap<String, byte[][]>();
                boolean row_number = true;
                while (rs.next()) {
                    String keyType = rs.getString("Key_name");
                    if (keyType == null || !keyType.toUpperCase().startsWith("PRI")) continue;
                    byte[][] tuple = new byte[6][];
                    tuple[0] = catalog == null ? new byte[]{} : this.s2b(catalog);
                    tuple[1] = new byte[0];
                    tuple[2] = this.s2b(table);
                    String columnName = rs.getString("Column_name");
                    tuple[3] = this.s2b(columnName);
                    tuple[4] = this.s2b(rs.getString("Seq_in_index"));
                    tuple[5] = this.s2b(keyType);
                    sortMap.put(columnName, tuple);
                }
                Iterator sortedIterator = sortMap.values().iterator();
                while (sortedIterator.hasNext()) {
                    tuples.add(sortedIterator.next());
                }
                resultSet = this.buildResultSet(fields, tuples, this.conn);
                Object var14_13 = null;
                if (rs == null) break block12;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqlEx) {
                        // empty catch block
                    }
                }
                rs = null;
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        rs = null;
        return resultSet;
    }

    public java.sql.ResultSet getProcedureColumns(String catalog, String SchemaPattern, String ProcedureNamePattern, String ColumnNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 0), new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "COLUMN_NAME", 1, 0), new Field("", "COLUMN_TYPE", 1, 0), new Field("", "DATA_TYPE", 5, 0), new Field("", "TYPE_NAME", 1, 0), new Field("", "PRECISION", 4, 0), new Field("", "LENGTH", 4, 0), new Field("", "SCALE", 5, 0), new Field("", "RADIX", 5, 0), new Field("", "NULLABLE", 5, 0), new Field("", "REMARKS", 1, 0)};
        return this.buildResultSet(fields, new ArrayList(), this.conn);
    }

    public String getProcedureTerm() throws SQLException {
        return "";
    }

    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "REMARKS", 1, 0), new Field("", "PROCEDURE_TYPE", 5, 0)};
        return this.buildResultSet(fields, new ArrayList(), this.conn);
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public String getSQLKeywords() throws SQLException {
        return "AUTO_INCREMENT,BINARY,BLOB,ENUM,INFILE,LOAD,MEDIUMINT,OPTION,OUTFILE,REPLACE,SET,TEXT,UNSIGNED,ZEROFILL";
    }

    public int getSQLStateType() throws SQLException {
        return 0;
    }

    public String getSchemaTerm() throws SQLException {
        return "";
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_SCHEM", 1, 0)};
        ArrayList tuples = new ArrayList();
        java.sql.ResultSet results = this.buildResultSet(fields, tuples, this.conn);
        return results;
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getStringFunctions() throws SQLException {
        return "ACII,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,ELT,FIELD,FIND_IN_SET,INSERT,INSTR,INTERVAL,LCASE,LEFT,LENGTH,LOCATE,LOWER,LTRIM,MID,POSITION,OCTET_LENGTH,REPEAT,REPLACE,REVEresultsE,RIGHT,RTRIM,SPACE,SOUNDEX,SUBSTRING,SUBSTRING_INDEX,TRIM,UCASE,UPPER";
    }

    public java.sql.ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 32), new Field("", "TABLE_SCHEM", 1, 32), new Field("", "TABLE_NAME", 1, 32), new Field("", "SUPERTABLE_NAME", 1, 32)};
        return this.buildResultSet(fields, new ArrayList(), this.conn);
    }

    public java.sql.ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 32), new Field("", "TABLE_SCHEM", 1, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "SUPERTYPE_CAT", 1, 32), new Field("", "SUPERTYPE_SCHEM", 1, 32), new Field("", "SUPERTYPE_NAME", 1, 32)};
        return this.buildResultSet(fields, new ArrayList(), this.conn);
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,PASSWORD,ENCRYPT,LAST_INSERT_ID,VEresultsION";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 64), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 64), new Field("", "GRANTOR", 1, 77), new Field("", "GRANTEE", 1, 77), new Field("", "PRIVILEGE", 1, 64), new Field("", "IS_GRANTABLE", 1, 3)};
        StringBuffer grantQuery = new StringBuffer("SELECT host,db,table_name,grantor,user,table_priv from mysql.tables_priv ");
        grantQuery.append(" WHERE ");
        if (catalog != null && catalog.length() != 0) {
            grantQuery.append(" db='");
            grantQuery.append(catalog);
            grantQuery.append("' AND ");
        }
        grantQuery.append("table_name like '");
        grantQuery.append(tableNamePattern);
        grantQuery.append("'");
        ResultSet results = null;
        ArrayList<byte[][]> grantRows = new ArrayList<byte[][]>();
        try {
            results = this.conn.execSQL(grantQuery.toString(), -1);
            results.setConnection(this.conn);
            while (results.next()) {
                String allPrivileges;
                String host = results.getString(1);
                String database = results.getString(2);
                String table = results.getString(3);
                String grantor = results.getString(4);
                String user = results.getString(5);
                if (user == null || user.length() == 0) {
                    user = "%";
                }
                StringBuffer fullUser = new StringBuffer(user);
                if (host != null) {
                    fullUser.append("@");
                    fullUser.append(host);
                }
                if ((allPrivileges = results.getString(6)) == null) continue;
                allPrivileges = allPrivileges.toUpperCase();
                StringTokenizer st = new StringTokenizer(allPrivileges, ",");
                while (st.hasMoreTokens()) {
                    Exception ex2;
                    Object var21_20;
                    String privilege = st.nextToken().trim();
                    java.sql.ResultSet columnResults = null;
                    try {
                        columnResults = this.getColumns(catalog, schemaPattern, table, "%");
                        while (columnResults.next()) {
                            String columnName = columnResults.getString(4);
                            byte[][] tuple = new byte[8][];
                            tuple[0] = this.s2b(database);
                            tuple[1] = null;
                            tuple[2] = this.s2b(table);
                            tuple[3] = (byte[])(grantor != null ? this.s2b(grantor) : null);
                            tuple[4] = this.s2b(fullUser.toString());
                            tuple[5] = this.s2b(privilege);
                            tuple[6] = null;
                            grantRows.add(tuple);
                        }
                        var21_20 = null;
                        if (columnResults == null) continue;
                    }
                    catch (Throwable throwable) {
                        var21_20 = null;
                        if (columnResults == null) throw throwable;
                        try {
                            columnResults.close();
                            throw throwable;
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        columnResults.close();
                    }
                    catch (Exception ex2) {}
                }
            }
            Object var24_23 = null;
            if (results == null) return this.buildResultSet(fields, grantRows, this.conn);
        }
        catch (Throwable throwable) {
            Object var24_24 = null;
            if (results == null) throw throwable;
            try {
                results.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            results.close();
            return this.buildResultSet(fields, grantRows, this.conn);
        }
        catch (Exception ex) {}
        return this.buildResultSet(fields, grantRows, this.conn);
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        Field[] fields = new Field[]{new Field("", "TABLE_TYPE", 12, 5)};
        byte[][] TType = new byte[][]{TABLE_AS_BYTES};
        tuples.add(TType);
        return this.buildResultSet(fields, tuples, this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        java.sql.ResultSet resultSet;
        java.sql.ResultSet results;
        block11: {
            String databasePart = "";
            if (catalog != null) {
                if (!catalog.equals("")) {
                    databasePart = " FROM " + this.quotedId + catalog + this.quotedId;
                }
            } else {
                databasePart = " FROM " + this.quotedId + this.database + this.quotedId;
            }
            if (tableNamePattern == null) {
                tableNamePattern = "%";
            }
            results = null;
            try {
                java.sql.ResultSet tables;
                results = this.conn.execSQL("show tables " + databasePart + " like '" + tableNamePattern + "'", -1);
                ResultSetMetaData RsMd = results.getMetaData();
                Field[] fields = new Field[]{new Field("", "TABLE_CAT", 12, catalog == null ? 0 : catalog.length()), new Field("", "TABLE_SCHEM", 12, 0), new Field("", "TABLE_NAME", 12, 255), new Field("", "TABLE_TYPE", 12, 5), new Field("", "REMARKS", 12, 0)};
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                byte[][] row = null;
                while (results.next()) {
                    String name = results.getString(1);
                    row = new byte[][]{catalog == null ? new byte[]{} : this.s2b(catalog), new byte[0], name.getBytes(), TABLE_AS_BYTES, new byte[0]};
                    tuples.add(row);
                }
                resultSet = tables = this.buildResultSet(fields, tuples, this.conn);
                Object var14_13 = null;
                if (results == null) break block11;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException sqlEx) {
                        // empty catch block
                    }
                }
                results = null;
                throw throwable;
            }
            try {
                results.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        results = null;
        return resultSet;
    }

    public String getTimeDateFunctions() throws SQLException {
        return "DAYOFWEEK,WEEKDAY,DAYOFMONTH,DAYOFYEAR,MONTH,DAYNAME,MONTHNAME,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,PERIOD_ADD,PERIOD_DIFF,TO_DAYS,FROM_DAYS,DATE_FORMAT,TIME_FORMAT,CURDATE,CURRENT_DATE,CURTIME,CURRENT_TIME,NOW,SYSDATE,CURRENT_TIMESTAMP,UNIX_TIMESTAMP,FROM_UNIXTIME,SEC_TO_TIME,TIME_TO_SEC";
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "PRECISION", 4, 10), new Field("", "LITERAL_PREFIX", 1, 4), new Field("", "LITERAL_SUFFIX", 1, 4), new Field("", "CREATE_PARAMS", 1, 32), new Field("", "NULLABLE", 5, 5), new Field("", "CASE_SENSITIVE", 1, 3), new Field("", "SEARCHABLE", 5, 3), new Field("", "UNSIGNED_ATTRIBUTE", 1, 3), new Field("", "FIXED_PREC_SCALE", 1, 3), new Field("", "AUTO_INCREMENT", 1, 3), new Field("", "LOCAL_TYPE_NAME", 1, 32), new Field("", "MINIMUM_SCALE", 5, 5), new Field("", "MAXIMUM_SCALE", 5, 5), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10)};
        byte[][] rowVal = null;
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        rowVal = new byte[][]{this.s2b("BIT"), Integer.toString(-7).getBytes(), this.s2b("1"), this.s2b(""), this.s2b(""), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("BIT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("BOOL"), Integer.toString(-7).getBytes(), this.s2b("1"), this.s2b(""), this.s2b(""), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("BOOL"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("TINYINT"), Integer.toString(-6).getBytes(), this.s2b("3"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("TINYINT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("BIGINT"), Integer.toString(-5).getBytes(), this.s2b("19"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("BIGINT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("LONG VARBINARY"), Integer.toString(-4).getBytes(), this.s2b("16777215"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("LONG VARBINARY"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("MEDIUMBLOB"), Integer.toString(-4).getBytes(), this.s2b("16777215"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("MEDIUMBLOB"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("LONGBLOB"), Integer.toString(-4).getBytes(), Integer.toString(Integer.MAX_VALUE).getBytes(), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("LONGBLOB"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("BLOB"), Integer.toString(-4).getBytes(), this.s2b("65535"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("BLOB"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("TINYBLOB"), Integer.toString(-4).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TINYBLOB"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("VARBINARY"), Integer.toString(-3).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b("(M)"), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("VARBINARY"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("BINARY"), Integer.toString(-2).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b("(M)"), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("BINARY"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("LONG VARCHAR"), Integer.toString(-1).getBytes(), this.s2b("16777215"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("LONG VARCHAR"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("MEDIUMTEXT"), Integer.toString(-1).getBytes(), this.s2b("16777215"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("MEDIUMTEXT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("LONGTEXT"), Integer.toString(-1).getBytes(), Integer.toString(Integer.MAX_VALUE).getBytes(), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("LONGTEXT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("TEXT"), Integer.toString(-1).getBytes(), this.s2b("65535"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TEXT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("TINYTEXT"), Integer.toString(-1).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TINYTEXT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("CHAR"), Integer.toString(1).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b("(M)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("CHAR"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("NUMERIC"), Integer.toString(2).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M[,D])] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("NUMERIC"), this.s2b("308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("DECIMAL"), Integer.toString(3).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M[,D])] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DECIMAL"), this.s2b("-308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("INTEGER"), Integer.toString(4).getBytes(), this.s2b("10"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("INTEGER"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("INT"), Integer.toString(4).getBytes(), this.s2b("10"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("INT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("MEDIUMINT"), Integer.toString(4).getBytes(), this.s2b("7"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("MEDIUMINT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("SMALLINT"), Integer.toString(5).getBytes(), this.s2b("5"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("SMALLINT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("DOUBLE"), Integer.toString(6).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M,D)] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DOUBLE"), this.s2b("-308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("FLOAT"), Integer.toString(7).getBytes(), this.s2b("10"), this.s2b(""), this.s2b(""), this.s2b("[(M,D)] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("FLOAT"), this.s2b("-38"), this.s2b("38"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("DOUBLE"), Integer.toString(8).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M,D)] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DOUBLE"), this.s2b("-308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("DOUBLE PRECISION"), Integer.toString(8).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M,D)] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DOUBLE PRECISION"), this.s2b("-308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("REAL"), Integer.toString(8).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M,D)] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("REAL"), this.s2b("-308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("VARCHAR"), Integer.toString(12).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b("(M)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("VARCHAR"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("ENUM"), Integer.toString(12).getBytes(), this.s2b("65535"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("ENUM"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("SET"), Integer.toString(12).getBytes(), this.s2b("64"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("SET"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("DATE"), Integer.toString(91).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("DATE"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("TIME"), Integer.toString(92).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TIME"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("DATETIME"), Integer.toString(93).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("DATETIME"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        rowVal = new byte[][]{this.s2b("TIMESTAMP"), Integer.toString(93).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b("[(M)]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TIMESTAMP"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        tuples.add(rowVal);
        return this.buildResultSet(fields, tuples, this.conn);
    }

    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_CAT", 12, 32), new Field("", "TYPE_SCHEM", 12, 32), new Field("", "TYPE_NAME", 12, 32), new Field("", "CLASS_NAME", 12, 32), new Field("", "DATA_TYPE", 12, 32), new Field("", "REMARKS", 12, 32)};
        ArrayList tuples = new ArrayList();
        return this.buildResultSet(fields, tuples, this.conn);
    }

    public String getURL() throws SQLException {
        return this.conn.getURL();
    }

    public String getUserName() throws SQLException {
        return this.conn.getUser();
    }

    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Field[] fields = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 1, 16), new Field("", "BUFFER_LENGTH", 1, 16), new Field("", "DECIMAL_DIGITS", 1, 16), new Field("", "PSEUDO_COLUMN", 5, 5)};
        return this.buildResultSet(fields, new ArrayList(), this.conn);
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return !this.nullsAreSortedHigh();
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (this.conn.getServerMajorVersion() >= 3) {
            if (this.conn.getServerMajorVersion() == 3) {
                return this.conn.getServerMinorVersion() >= 22;
            }
            return true;
        }
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 1111: {
                        return true;
                    }
                }
                return false;
            }
            case -7: {
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return false;
            }
            case 1111: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1005 && concurrency == 1007;
    }

    public boolean supportsResultSetHoldability(int arg0) throws SQLException {
        return false;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1004;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (this.conn.supportsIsolationLevel()) {
            switch (level) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean supportsTransactions() throws SQLException {
        return this.conn.supportsTransactions();
    }

    public boolean supportsUnion() throws SQLException {
        return this.conn.io.versionMeetsMinimum(4, 0, 0);
    }

    public boolean supportsUnionAll() throws SQLException {
        return this.conn.io.versionMeetsMinimum(4, 0, 0);
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    protected java.sql.ResultSet buildResultSet(Field[] fields, ArrayList rows, Connection Conn) throws SQLException {
        return new ResultSet(fields, new RowDataStatic(rows), Conn);
    }

    private byte[] s2b(String s) {
        return s.getBytes();
    }
}

