/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class Driver
implements java.sql.Driver {
    public static final boolean debug = false;
    public static final boolean trace = false;
    static final int MAJORVERSION = 3;
    static final int MINORVERSION = 0;

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        info = this.parseURL(url, info);
        DriverPropertyInfo hostProp = new DriverPropertyInfo("HOST", info.getProperty("HOST"));
        hostProp.required = true;
        hostProp.description = "Hostname of MySQL Server";
        DriverPropertyInfo portProp = new DriverPropertyInfo("PORT", info.getProperty("PORT", "3306"));
        portProp.required = false;
        portProp.description = "Port number of MySQL Server";
        DriverPropertyInfo dbProp = new DriverPropertyInfo("DBNAME", info.getProperty("DBNAME"));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo userProp = new DriverPropertyInfo("user", info.getProperty("user"));
        userProp.required = true;
        userProp.description = "Username to authenticate as";
        DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", info.getProperty("password"));
        passwordProp.required = true;
        passwordProp.description = "Password to use for authentication";
        DriverPropertyInfo autoReconnect = new DriverPropertyInfo("autoReconnect", info.getProperty("autoReconnect", "false"));
        autoReconnect.required = false;
        autoReconnect.choices = new String[]{"true", "false"};
        autoReconnect.description = "Should the driver try to re-establish bad connections?";
        DriverPropertyInfo maxReconnects = new DriverPropertyInfo("maxReconnects", info.getProperty("maxReconnects", "3"));
        maxReconnects.required = false;
        maxReconnects.description = "Maximum number of reconnects to attempt if autoReconnect is true";
        DriverPropertyInfo initialTimeout = new DriverPropertyInfo("initialTimeout", info.getProperty("initialTimeout", "2"));
        initialTimeout.required = false;
        initialTimeout.description = "Initial timeout (seconds) to wait between failed connections";
        DriverPropertyInfo profileSql = new DriverPropertyInfo("profileSql", info.getProperty("profileSql", "false"));
        profileSql.required = false;
        profileSql.description = "Trace queries and their execution/fetch times on STDERR (true/false) defaults to false";
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{hostProp, portProp, dbProp, userProp, passwordProp, autoReconnect, maxReconnects, initialTimeout, profileSql};
        return dpi;
    }

    public synchronized boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    public synchronized java.sql.Connection connect(String url, Properties info) throws SQLException {
        Properties props = null;
        props = this.parseURL(url, info);
        if (props == null) {
            return null;
        }
        try {
            Connection newConn = new Connection();
            newConn.connectionInit(this.host(props), this.port(props), props, this.database(props), url, this);
            return newConn;
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            throw new SQLException("Cannot load connection class because of underlying exception: '" + ex.toString() + "'.", "08001");
        }
    }

    public String database(Properties props) {
        return props.getProperty("DBNAME");
    }

    public String host(Properties props) {
        return props.getProperty("HOST", "localhost");
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public int port(Properties props) {
        return Integer.parseInt(props.getProperty("PORT", "3306"));
    }

    public String property(String Name, Properties props) {
        return props.getProperty(Name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String url, Properties defaults) throws SQLException {
        StringTokenizer st;
        Properties urlProps = new Properties(defaults);
        if (url == null) {
            return null;
        }
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1, url.length());
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreTokens()) {
                StringTokenizer vp = new StringTokenizer(queryParams.nextToken(), "=");
                String param = "";
                if (vp.hasMoreTokens()) {
                    param = vp.nextToken();
                }
                String value = "";
                if (vp.hasMoreTokens()) {
                    value = vp.nextToken();
                }
                if (value.length() <= 0 || param.length() <= 0) continue;
                urlProps.put(param, value);
            }
        }
        if (!(st = new StringTokenizer(url, ":/", true)).hasMoreTokens()) return null;
        String protocol = st.nextToken();
        if (protocol == null) return null;
        if (!protocol.toLowerCase().equals("jdbc")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String colon = st.nextToken();
        if (colon == null) return null;
        if (!colon.equals(":")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String subProto = st.nextToken();
        if (subProto == null) return null;
        if (!subProto.toLowerCase().equals("mysql")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        colon = st.nextToken();
        if (colon == null) return null;
        if (!colon.equals(":")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String slash = st.nextToken();
        String slash2 = "";
        if (st.hasMoreTokens()) {
            slash2 = st.nextToken();
        }
        if (slash == null || slash2 == null) return null;
        if (!slash.equals("/") && !slash2.equals("/")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String token = st.nextToken();
        if (token == null) return null;
        if (!token.equals(":") && !token.equals("/")) {
            urlProps.put("HOST", token);
            if (!st.hasMoreTokens()) return null;
            token = st.nextToken();
        }
        if (token.equals(":") && st.hasMoreTokens()) {
            token = st.nextToken();
            urlProps.put("PORT", token);
            if (st.hasMoreTokens()) {
                token = st.nextToken();
            }
        }
        if (!token.equals("/")) return urlProps;
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            urlProps.put("DBNAME", token);
            return urlProps;
        }
        urlProps.put("DBNAME", "");
        return urlProps;
    }

    static {
        debug = false;
        trace = false;
        MAJORVERSION = 3;
        MINORVERSION = 0;
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException E) {
            throw new RuntimeException("Can't register driver!");
        }
    }
}

