/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.EscapeTokenizer;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class EscapeProcessor {
    EscapeProcessor() {
    }

    public synchronized String escapeSQL(String sql) throws SQLException {
        int next_end_brace;
        boolean replaceEscapeSequence = false;
        String escapeSequence = null;
        StringBuffer newSql = new StringBuffer();
        if (sql == null) {
            return null;
        }
        int begin_brace = sql.indexOf("{");
        int n = next_end_brace = begin_brace == -1 ? -1 : sql.indexOf("}", begin_brace);
        if (next_end_brace == -1) {
            return sql;
        }
        EscapeTokenizer escapeTokenizer = new EscapeTokenizer(sql);
        while (escapeTokenizer.hasMoreTokens()) {
            String token = escapeTokenizer.nextToken();
            if (token.startsWith("{")) {
                String day2;
                String month2;
                String year4;
                StringTokenizer st;
                String argument;
                int endPos;
                if (!token.endsWith("}")) {
                    throw new SQLException("Not a valid escape sequence: " + token);
                }
                if (token.toLowerCase().startsWith("{escape")) {
                    try {
                        StringTokenizer st2 = new StringTokenizer(token, " '");
                        st2.nextToken();
                        escapeSequence = st2.nextToken();
                        if (escapeSequence.length() < 3) {
                            throw new SQLException("Syntax error for escape sequence '" + token + "'", "42000");
                        }
                        escapeSequence = escapeSequence.substring(1, escapeSequence.length() - 1);
                        replaceEscapeSequence = true;
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new SQLException("Syntax error for escape sequence '" + token + "'", "42000");
                    }
                }
                if (token.toLowerCase().startsWith("{fn")) {
                    int startPos = token.toLowerCase().indexOf("fn ") + 3;
                    endPos = token.length() - 1;
                    newSql.append(token.substring(startPos, endPos));
                    continue;
                }
                if (token.toLowerCase().startsWith("{d")) {
                    int startPos = token.indexOf("'") + 1;
                    endPos = token.lastIndexOf("'");
                    if (startPos == -1 || endPos == -1) {
                        throw new SQLException("Syntax error for DATE escape sequence '" + token + "'", "42000");
                    }
                    argument = token.substring(startPos, endPos);
                    try {
                        st = new StringTokenizer(argument, " -");
                        year4 = st.nextToken();
                        month2 = st.nextToken();
                        day2 = st.nextToken();
                        String dateString = "'" + year4 + "-" + month2 + "-" + day2 + "'";
                        newSql.append(dateString);
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new SQLException("Syntax error for DATE escape sequence '" + argument + "'", "42000");
                    }
                }
                if (token.toLowerCase().startsWith("{ts")) {
                    int startPos = token.indexOf("'") + 1;
                    endPos = token.lastIndexOf("'");
                    if (startPos == -1 || endPos == -1) {
                        throw new SQLException("Syntax error for TIMESTAMP escape sequence '" + token + "'", "42000");
                    }
                    argument = token.substring(startPos, endPos);
                    try {
                        st = new StringTokenizer(argument, " .-:");
                        year4 = st.nextToken();
                        month2 = st.nextToken();
                        day2 = st.nextToken();
                        String hour = st.nextToken();
                        String minute = st.nextToken();
                        String second = st.nextToken();
                        String fractionalSecond = "";
                        if (st.hasMoreTokens()) {
                            fractionalSecond = st.nextToken();
                        }
                        newSql.append("'").append(year4).append("-").append(month2).append("-").append(day2).append(" ").append(hour).append(":").append(minute).append(":").append(second).append("'");
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new SQLException("Syntax error for TIMESTAMP escape sequence '" + argument + "'", "42000");
                    }
                }
                if (token.toLowerCase().startsWith("{t")) {
                    int startPos = token.indexOf("'") + 1;
                    endPos = token.lastIndexOf("'");
                    if (startPos == -1 || endPos == -1) {
                        throw new SQLException("Syntax error for TIME escape sequence '" + token + "'", "42000");
                    }
                    argument = token.substring(startPos, endPos);
                    try {
                        st = new StringTokenizer(argument, " :");
                        String hour = st.nextToken();
                        String minute = st.nextToken();
                        String second = st.nextToken();
                        String timeString = "'" + hour + ":" + minute + ":" + second + "'";
                        newSql.append(timeString);
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new SQLException("Syntax error for escape sequence '" + argument + "'", "42000");
                    }
                }
                if (token.toLowerCase().startsWith("{call") || token.toLowerCase().startsWith("{? = call")) {
                    throw new SQLException("Stored procedures not supported: " + token, "S1C00");
                }
                if (!token.toLowerCase().startsWith("{oj")) continue;
                newSql.append(token);
                continue;
            }
            newSql.append(token);
        }
        String escapedSql = newSql.toString();
        if (replaceEscapeSequence) {
            String currentSql = escapedSql;
            while (currentSql.indexOf(escapeSequence) != -1) {
                int escapePos = currentSql.indexOf(escapeSequence);
                String LHS = currentSql.substring(0, escapePos);
                String RHS = currentSql.substring(escapePos + 1, currentSql.length());
                currentSql = LHS + "\\" + RHS;
            }
            escapedSql = currentSql;
        }
        return escapedSql;
    }
}

