/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

public class EscapeTokenizer {
    protected boolean emittingEscapeCode = false;
    protected boolean inBraces = false;
    protected boolean inQuotes = false;
    protected char lastChar = '\u0000';
    protected char lastLastChar = '\u0000';
    protected int pos = 0;
    protected char quoteChar = '\u0000';
    protected String source = null;
    protected int sourceLength = 0;

    public EscapeTokenizer(String s) {
        this.source = s;
        this.sourceLength = s.length();
        this.pos = 0;
    }

    public synchronized boolean hasMoreTokens() {
        return this.pos < this.sourceLength;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized String nextToken() {
        StringBuffer tokenBuf = new StringBuffer();
        if (this.emittingEscapeCode) {
            tokenBuf.append("{");
            this.emittingEscapeCode = false;
        }
        while (this.pos < this.sourceLength) {
            char c;
            block25: {
                block26: {
                    block28: {
                        block27: {
                            block22: {
                                block24: {
                                    block23: {
                                        c = this.source.charAt(this.pos);
                                        if (c != '\'') break block22;
                                        if (this.lastChar == '\\') break block23;
                                        if (this.inQuotes) {
                                            if (this.quoteChar == c) {
                                                this.inQuotes = false;
                                            }
                                            break block24;
                                        } else {
                                            this.inQuotes = true;
                                            this.quoteChar = c;
                                        }
                                        break block24;
                                    }
                                    if (this.lastLastChar == '\\') {
                                        if (this.inQuotes) {
                                            if (this.quoteChar == c) {
                                                this.inQuotes = false;
                                            }
                                        } else {
                                            this.inQuotes = true;
                                            this.quoteChar = c;
                                        }
                                    }
                                }
                                tokenBuf.append(c);
                                break block25;
                            }
                            if (c != '\"') break block26;
                            if (this.lastChar == '\\' || this.lastChar == '\"') break block27;
                            if (this.inQuotes) {
                                if (this.quoteChar == c) {
                                    this.inQuotes = false;
                                }
                                break block28;
                            } else {
                                this.inQuotes = true;
                                this.quoteChar = c;
                            }
                            break block28;
                        }
                        if (this.lastLastChar == '\\') {
                            if (this.inQuotes) {
                                if (this.quoteChar == c) {
                                    this.inQuotes = false;
                                }
                            } else {
                                this.inQuotes = true;
                                this.quoteChar = c;
                            }
                        }
                    }
                    tokenBuf.append(c);
                    break block25;
                }
                if (c == '{') {
                    if (!this.inQuotes) {
                        ++this.pos;
                        this.emittingEscapeCode = true;
                        return tokenBuf.toString();
                    }
                    tokenBuf.append(c);
                } else if (c == '}') {
                    tokenBuf.append(c);
                    if (!this.inQuotes) {
                        this.lastChar = c;
                        ++this.pos;
                        return tokenBuf.toString();
                    }
                } else {
                    tokenBuf.append(c);
                }
            }
            this.lastLastChar = this.lastChar;
            this.lastChar = c;
            ++this.pos;
        }
        return tokenBuf.toString();
    }
}

