/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.MysqlDefs;
import com.mysql.jdbc.StringUtils;

public class Field {
    private static final int AUTO_INCREMENT_FLAG = 512;
    int colDecimals;
    short colFlag;
    int length;
    int mysqlType = -1;
    String name;
    int nameStart;
    int nameLength;
    int sqlType = -1;
    String tableName;
    int tableNameStart;
    int tableNameLength;
    byte[] buffer;
    private String fullName = null;

    public Field(String tableName, String columnName, int jdbcType, int length) {
        this.tableName = tableName;
        this.name = columnName;
        this.length = length;
        this.sqlType = jdbcType;
        this.colFlag = 0;
        this.colDecimals = 0;
    }

    Field(byte[] buffer, int nameStart, int nameLength, int tableNameStart, int tableNameLength, int length, int mysqlType, short colFlag, int colDecimals) {
        this.buffer = buffer;
        this.nameStart = nameStart;
        this.nameLength = nameLength;
        this.tableNameStart = tableNameStart;
        this.tableNameLength = tableNameLength;
        this.length = length;
        this.colFlag = colFlag;
        this.colDecimals = colDecimals;
        this.mysqlType = mysqlType;
        this.sqlType = MysqlDefs.mysqlToJavaType(mysqlType);
        boolean isBinary = this.isBinary();
        if (this.sqlType == -4 && !isBinary) {
            this.sqlType = -1;
        } else if (this.sqlType == -3 && !isBinary) {
            this.sqlType = 12;
        }
    }

    public boolean isAutoIncrement() {
        return (this.colFlag & 0x200) > 0;
    }

    public boolean isBinary() {
        return (this.colFlag & 0x80) > 0;
    }

    public boolean isBlob() {
        return (this.colFlag & 0x10) > 0;
    }

    public String getFullName() {
        if (this.fullName == null) {
            StringBuffer fullNameBuf = new StringBuffer(this.getTableName().length() + 1 + this.getName().length());
            fullNameBuf.append(this.tableName);
            fullNameBuf.append('.');
            fullNameBuf.append(this.name);
            this.fullName = fullNameBuf.toString();
            Object var1_1 = null;
        }
        return this.fullName;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isMultipleKey() {
        return (this.colFlag & 8) > 0;
    }

    public int getMysqlType() {
        return this.mysqlType;
    }

    public String getName() {
        if (this.name == null) {
            this.name = StringUtils.toAsciiString3(this.buffer, this.nameStart, this.nameLength);
        }
        return this.name;
    }

    public boolean isPrimaryKey() {
        return (this.colFlag & 2) > 0;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public String getTable() {
        return this.getTableName();
    }

    public String getTableName() {
        if (this.tableName == null) {
            this.tableName = StringUtils.toAsciiString3(this.buffer, this.tableNameStart, this.tableNameLength);
        }
        return this.tableName;
    }

    public boolean isUniqueKey() {
        return (this.colFlag & 4) > 0;
    }

    public boolean isUnsigned() {
        return (this.colFlag & 0x20) > 0;
    }

    public boolean isZeroFill() {
        return (this.colFlag & 0x40) > 0;
    }

    public String toString() {
        return this.getFullName();
    }

    int getDecimals() {
        return this.colDecimals;
    }

    boolean isNotNull() {
        return (this.colFlag & 1) > 0;
    }

    static {
        AUTO_INCREMENT_FLAG = 512;
    }
}

