/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Debug;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowData;
import com.mysql.jdbc.RowDataDynamic;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.UpdatableResultSet;
import com.mysql.jdbc.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class MysqlIO {
    static final int COMP_HEADER_LENGTH = 3;
    static final long MAX_THREE_BYTES = 16581375L;
    static final int HEADER_LENGTH = 4;
    static int MAXBUF;
    private static int CLIENT_COMPRESS;
    private static int CLIENT_CONNECT_WITH_DB;
    private static int CLIENT_FOUND_ROWS;
    private static int CLIENT_IGNORE_SPACE;
    private static int CLIENT_LOCAL_FILES;
    private static int CLIENT_LONG_FLAG;
    private static int CLIENT_LONG_PASSWORD;
    private static int CLIENT_NO_SCHEMA;
    private static int CLIENT_ODBC;
    private static int CLIENT_PROTOCOL_41;
    SQLWarning warningChain = null;
    private boolean colDecimalNeedsBump = false;
    private Connection connection;
    private Deflater deflater = null;
    private String host = null;
    private Inflater inflater = null;
    private int clientParam = 0;
    private Socket mysqlConnection = null;
    private InputStream mysqlInput = null;
    private BufferedOutputStream mysqlOutput = null;
    private byte packetSequence = 0;
    private ResultSet pendingResultSet = null;
    private int port = 3306;
    private boolean profileSql = false;
    private byte protocolVersion = 0;
    private SoftReference splitBufRef;
    private Buffer reusablePacket = null;
    private Buffer sendPacket = null;
    private int serverMajorVersion = 0;
    private int serverMinorVersion = 0;
    private int serverSubMinorVersion = 0;
    private String serverVersion = null;
    private boolean useCompression = false;
    private boolean useNewUpdateCounts = false;
    private RowData streamingData = null;

    public MysqlIO(String Host, int port, Connection Conn) throws IOException, SQLException {
        this.connection = Conn;
        this.reusablePacket = new Buffer(this.connection.getNetBufferLength(), this.connection.getMaxAllowedPacket());
        this.port = port;
        this.host = Host;
        this.mysqlConnection = new Socket(this.host, this.port);
        try {
            this.mysqlConnection.setTcpNoDelay(true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.mysqlInput = new BufferedInputStream(this.mysqlConnection.getInputStream(), 16384);
        this.mysqlOutput = new BufferedOutputStream(this.mysqlConnection.getOutputStream(), 16384);
    }

    public void setProfileSql(boolean flag) {
        this.profileSql = flag;
    }

    protected ResultSet getResultSet(long columnCount, int max_rows, int resultSetType, boolean streamResults) throws Exception {
        Buffer Packet;
        Field[] Fields = new Field[(int)columnCount];
        int i = 0;
        while ((long)i < columnCount) {
            Packet = this.readPacket();
            Fields[i] = this.unpackField(Packet);
            ++i;
        }
        Packet = this.readPacket();
        RowData rowData = null;
        if (!streamResults) {
            ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
            byte[][] rowBytes = this.nextRow((int)columnCount);
            int rowCount = 0;
            if (rowBytes != null) {
                rows.add(rowBytes);
                rowCount = 1;
            }
            while (rowBytes != null && rowCount < max_rows) {
                rowBytes = this.nextRow((int)columnCount);
                if (rowBytes == null) continue;
                rows.add(rowBytes);
                ++rowCount;
            }
            rowData = new RowDataStatic(rows);
        } else {
            rowData = new RowDataDynamic(this, (int)columnCount);
            this.streamingData = rowData;
        }
        return this.buildResultSetWithRows(Fields, rowData, null, resultSetType);
    }

    private final Field unpackField(Buffer packet) {
        if ((this.clientParam & CLIENT_PROTOCOL_41) != 0) {
            packet.fastSkipLenString();
            int tableNameStart = packet.getPosition() + 1;
            int tableNameLength = packet.fastSkipLenString();
            packet.fastSkipLenString();
            int nameStart = packet.getPosition() + 1;
            int nameLength = packet.fastSkipLenString();
            packet.fastSkipLenString();
            int colLength = packet.readnBytes();
            int colType = packet.readnBytes();
            packet.readByte();
            short colFlag = (short)(packet.readByte() & 0xFF);
            int colDecimals = packet.readByte() & 0xFF;
            String defaultValue = packet.readLenString();
            return new Field(packet.getBufferSource(), nameStart, nameLength, tableNameStart, tableNameLength, colLength, colType, colFlag, colDecimals);
        }
        int tableNameStart = packet.getPosition() + 1;
        int tableNameLength = packet.fastSkipLenString();
        int nameStart = packet.getPosition() + 1;
        int nameLength = packet.fastSkipLenString();
        int colLength = packet.readnBytes();
        int colType = packet.readnBytes();
        packet.readByte();
        short colFlag = (short)(packet.readByte() & 0xFF);
        int colDecimals = packet.readByte() & 0xFF;
        if (this.colDecimalNeedsBump) {
            ++colDecimals;
        }
        return new Field(packet.getBufferSource(), nameStart, nameLength, tableNameStart, tableNameLength, colLength, colType, colFlag, colDecimals);
    }

    protected final void forceClose() throws IOException {
        this.mysqlConnection.close();
    }

    protected ResultSet buildResultSetWithRows(Field[] fields, RowData rows, Connection conn, int resultSetType) throws SQLException {
        switch (resultSetType) {
            case 1007: {
                return new ResultSet(fields, rows, conn);
            }
            case 1008: {
                return new UpdatableResultSet(fields, rows, conn);
            }
        }
        return new ResultSet(fields, rows, conn);
    }

    protected ResultSet buildResultSetWithUpdates(long updateCount, long updateID, Connection Conn) {
        return new ResultSet(updateCount, updateID);
    }

    static int getMaxBuf() {
        return MAXBUF;
    }

    final int getServerMajorVersion() {
        return this.serverMajorVersion;
    }

    final int getServerMinorVersion() {
        return this.serverMinorVersion;
    }

    final int getServerSubMinorVersion() {
        return this.serverSubMinorVersion;
    }

    String getServerVersion() {
        return this.serverVersion;
    }

    void init(String user, String password) throws SQLException {
        block26: {
            try {
                int serverCapabilities;
                Buffer buf = this.readPacket();
                this.protocolVersion = buf.readByte();
                if (this.protocolVersion == -1) {
                    try {
                        this.mysqlConnection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new SQLException("Server configuration denies access to data source", "08001", 0);
                }
                this.serverVersion = buf.readString();
                int point = this.serverVersion.indexOf(".");
                if (point != -1) {
                    try {
                        int n;
                        this.serverMajorVersion = n = Integer.parseInt(this.serverVersion.substring(0, point));
                    }
                    catch (NumberFormatException NFE1) {
                        // empty catch block
                    }
                    String remaining = this.serverVersion.substring(point + 1, this.serverVersion.length());
                    point = remaining.indexOf(".");
                    if (point != -1) {
                        try {
                            int n;
                            this.serverMinorVersion = n = Integer.parseInt(remaining.substring(0, point));
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                        remaining = remaining.substring(point + 1, remaining.length());
                        int pos = 0;
                        while (pos < remaining.length()) {
                            if (remaining.charAt(pos) < '0' || remaining.charAt(pos) > '9') break;
                            ++pos;
                        }
                        try {
                            int n;
                            this.serverSubMinorVersion = n = Integer.parseInt(remaining.substring(0, pos));
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                }
                this.colDecimalNeedsBump = this.versionMeetsMinimum(3, 23, 0);
                this.useNewUpdateCounts = this.versionMeetsMinimum(3, 22, 5);
                long threadId = buf.readLong();
                String seed = buf.readString();
                if (buf.getPosition() >= buf.getBufLength() || ((serverCapabilities = buf.readInt()) & CLIENT_COMPRESS) != 0) {
                    // empty if block
                }
                this.clientParam |= CLIENT_FOUND_ROWS;
                this.clientParam = this.protocolVersion > 9 ? (this.clientParam |= CLIENT_LONG_PASSWORD) : (this.clientParam &= ~CLIENT_LONG_PASSWORD);
                if (this.versionMeetsMinimum(4, 1, 0)) {
                    this.clientParam |= CLIENT_PROTOCOL_41;
                }
                int passwordLength = 16;
                int userLength = 0;
                if (user != null) {
                    userLength = user.length();
                }
                int packLength = userLength + passwordLength + 6 + 4;
                Buffer packet = new Buffer(packLength);
                packet.writeInt(this.clientParam);
                packet.writeLongInt(packLength);
                packet.writeString(user);
                if (this.protocolVersion > 9) {
                    packet.writeString(Util.newCrypt(password, seed));
                } else {
                    packet.writeString(Util.oldCrypt(password, seed));
                }
                this.send(packet);
                Buffer b = this.readPacket();
                byte status = b.readByte();
                if (status == -1) {
                    String message = "";
                    int errno = 2000;
                    if (this.protocolVersion > 9) {
                        errno = b.readInt();
                        message = b.readString();
                        this.clearReceive();
                        String xOpen = SQLError.mysqlToXOpen(errno);
                        if (xOpen.equals("S1000")) {
                            throw new SQLException("Communication failure during handshake. Is there a server running on " + this.host + ":" + this.port + "?");
                        }
                        throw new SQLException(SQLError.get(xOpen) + ": " + message, xOpen, errno);
                    }
                    message = b.readString();
                    this.clearReceive();
                    if (message.indexOf("Access denied") != -1) {
                        throw new SQLException(SQLError.get("28000") + ": " + message, "28000", errno);
                    }
                    throw new SQLException(SQLError.get("08001") + ": " + message, "08001", errno);
                }
                if (status == 0) {
                    if (this.serverMajorVersion >= 3 && this.serverMinorVersion >= 22 && this.serverSubMinorVersion >= 5) {
                        packet.newReadLength();
                        packet.newReadLength();
                    } else {
                        packet.readLength();
                        packet.readLength();
                    }
                    break block26;
                }
                throw new SQLException("Unknown Status code from server", "08007", status);
            }
            catch (IOException ioEx) {
                throw new SQLException(SQLError.get("08S01") + ": " + ioEx.getClass().getName(), "08S01", 0);
            }
        }
    }

    final void quit() throws IOException {
        Buffer packet = new Buffer(6);
        this.packetSequence = (byte)-1;
        packet.writeByte((byte)1);
        this.send(packet);
        this.forceClose();
    }

    void resetMaxBuf() {
        this.reusablePacket.setMaxLength(this.connection.getMaxAllowedPacket());
        this.sendPacket.setMaxLength(this.connection.getMaxAllowedPacket());
    }

    final Buffer sendCommand(int command, String extraData, Buffer queryPacket) throws Exception {
        byte statusCode;
        this.checkForOutstandingStreamingData();
        Buffer resultPacket = null;
        try {
            if (queryPacket == null) {
                int packLength = 8 + (extraData != null ? extraData.length() : 0) + 2;
                if (this.sendPacket == null) {
                    this.sendPacket = new Buffer(packLength, this.connection.getMaxAllowedPacket());
                }
                this.packetSequence = (byte)-1;
                this.sendPacket.clear();
                if (this.useCompression) {
                    this.sendPacket.setPosition(this.sendPacket.getPosition() + 3);
                }
                this.sendPacket.writeByte((byte)command);
                if (command == 2 || command == 5 || command == 6 || command == 3) {
                    this.sendPacket.writeStringNoNull(extraData);
                } else if (command == 12) {
                    long id = new Long(extraData);
                    this.sendPacket.writeLong(id);
                } else if (command == 7 && this.protocolVersion > 9) {
                    Debug.msg(this, "Reload");
                }
                this.send(this.sendPacket);
            } else {
                this.packetSequence = (byte)-1;
                this.send(queryPacket);
            }
        }
        catch (Exception ex) {
            throw new SQLException(SQLError.get("08S01") + ": " + ex.getClass().getName(), "08S01", 0);
        }
        try {
            resultPacket = this.reuseAndReadPacket(this.reusablePacket);
            statusCode = resultPacket.readByte();
        }
        catch (EOFException eofe) {
            throw eofe;
        }
        catch (Exception fallThru) {
            throw new SQLException(SQLError.get("08S01") + ": " + fallThru.getClass().getName(), "08S01", 0);
        }
        try {
            if (statusCode == -1) {
                int errno = 2000;
                if (this.protocolVersion > 9) {
                    errno = resultPacket.readInt();
                    String errorMessage = resultPacket.readString();
                    this.clearReceive();
                    String xOpen = SQLError.mysqlToXOpen(errno);
                    throw new SQLException(SQLError.get(xOpen) + ": " + errorMessage, xOpen, errno);
                }
                String errorMessage = resultPacket.readString();
                this.clearReceive();
                if (errorMessage.indexOf("Unknown column") != -1) {
                    throw new SQLException(SQLError.get("S0022") + ": " + errorMessage, "S0022", -1);
                }
                throw new SQLException(SQLError.get("S1000") + ": " + errorMessage, "S1000", -1);
            }
            if (statusCode == 0) {
                if (command == 5 || command == 6) {
                    SQLWarning newWarning = new SQLWarning("Command=" + command + ": ");
                    if (this.warningChain != null) {
                        newWarning.setNextException(this.warningChain);
                    }
                    this.warningChain = newWarning;
                }
            } else if (resultPacket.isLastDataPacket()) {
                SQLWarning newWarning = new SQLWarning("Command=" + command + ": ");
                if (this.warningChain != null) {
                    newWarning.setNextException(this.warningChain);
                }
                this.warningChain = newWarning;
            }
            return resultPacket;
        }
        catch (IOException ioEx) {
            throw new SQLException(SQLError.get("08S01") + ": " + ioEx.getClass().getName(), "08S01", 0);
        }
    }

    final ResultSet prepareQuery(String query, String characterEncoding) throws Exception {
        int packLength = 5 + query.length() * 2 + 2;
        if (this.sendPacket == null) {
            this.sendPacket = new Buffer(packLength, this.connection.getMaxAllowedPacket());
        } else {
            this.sendPacket.clear();
        }
        this.sendPacket.writeByte((byte)22);
        if (characterEncoding != null) {
            this.sendPacket.writeStringNoNull(query, characterEncoding);
        } else {
            this.sendPacket.writeStringNoNull(query);
        }
        this.clearAllReceive();
        Buffer resultPacket = this.sendCommand(22, null, this.sendPacket);
        resultPacket.setPosition(resultPacket.getPosition() - 1);
        long columnCount = resultPacket.readLength();
        if (columnCount != 0L) {
            ResultSet results = this.getResultSet(columnCount, -1, 1007, false);
            return results;
        }
        throw new SQLException("No handle or metadata returned for statement prepare", "S1000");
    }

    final ResultSet executePreparedQuery(Buffer paramPacket, int maxRows, Connection conn, int resultSetType, boolean streamResults) throws Exception {
        long updateCount = -1L;
        long updateID = -1L;
        StringBuffer profileMsgBuf = null;
        long queryStartTime = 0L;
        if (this.profileSql) {
            profileMsgBuf = new StringBuffer();
            queryStartTime = System.currentTimeMillis();
            profileMsgBuf.append("\"\texecution time:\t");
        }
        this.clearAllReceive();
        Buffer resultPacket = this.sendCommand(23, null, paramPacket);
        if (this.profileSql) {
            long executionTime = System.currentTimeMillis() - queryStartTime;
            profileMsgBuf.append(executionTime);
            profileMsgBuf.append("\t");
        }
        resultPacket.setPosition(resultPacket.getPosition() - 1);
        long columnCount = resultPacket.readLength();
        if (columnCount == 0L) {
            try {
                if (this.useNewUpdateCounts) {
                    updateCount = resultPacket.newReadLength();
                    updateID = resultPacket.newReadLength();
                } else {
                    updateCount = resultPacket.readLength();
                    updateID = resultPacket.readLength();
                }
            }
            catch (Exception ex) {
                throw new SQLException(SQLError.get("S1000") + ": " + ex.getClass().getName(), "S1000", -1);
            }
            if (this.profileSql) {
                System.err.println(profileMsgBuf.toString());
            }
            return this.buildResultSetWithUpdates(updateCount, updateID, conn);
        }
        long fetchStartTime = 0L;
        if (this.profileSql) {
            fetchStartTime = System.currentTimeMillis();
        }
        ResultSet results = this.getResultSet(columnCount, maxRows, resultSetType, streamResults);
        if (this.profileSql) {
            long fetchElapsedTime = System.currentTimeMillis() - fetchStartTime;
            profileMsgBuf.append("result set fetch time:\t");
            profileMsgBuf.append(fetchElapsedTime);
        }
        return results;
    }

    final ResultSet sqlQuery(String query, int maxRows, String characterEncoding, Connection conn, int resultSetType, boolean streamResults) throws Exception {
        int packLength = 5 + query.length() * 2 + 2;
        if (this.sendPacket == null) {
            this.sendPacket = new Buffer(packLength, this.connection.getMaxAllowedPacket());
        } else {
            this.sendPacket.clear();
        }
        this.sendPacket.writeByte((byte)3);
        if (characterEncoding != null) {
            this.sendPacket.writeStringNoNull(query, characterEncoding);
        } else {
            this.sendPacket.writeStringNoNull(query);
        }
        return this.sqlQueryDirect(this.sendPacket, maxRows, conn, resultSetType, streamResults);
    }

    final ResultSet sqlQuery(String query, int maxRows, String encoding, int resultSetType, boolean streamResults) throws Exception {
        return this.sqlQuery(query, maxRows, encoding, null, resultSetType, streamResults);
    }

    final ResultSet sqlQuery(String query, int maxRows, int resultSetType, boolean streamResults) throws Exception {
        StringBuffer profileMsgBuf = null;
        long queryStartTime = 0L;
        if (this.profileSql) {
            profileMsgBuf = new StringBuffer();
            queryStartTime = System.currentTimeMillis();
            profileMsgBuf.append("Query\t\"");
            profileMsgBuf.append(query);
            profileMsgBuf.append("\"\texecution time:\t");
        }
        this.clearAllReceive();
        Buffer packet = this.sendCommand(3, query, null);
        if (this.profileSql) {
            long executionTime = System.currentTimeMillis() - queryStartTime;
            profileMsgBuf.append(executionTime);
            profileMsgBuf.append("\t");
        }
        packet.setPosition(packet.getPosition() - 1);
        long columnCount = packet.readLength();
        if (columnCount == 0L) {
            long updateCount = -1L;
            long updateID = -1L;
            try {
                if (this.useNewUpdateCounts) {
                    updateCount = packet.newReadLength();
                    updateID = packet.newReadLength();
                } else {
                    updateCount = packet.readLength();
                    updateID = packet.readLength();
                }
            }
            catch (Exception ex) {
                throw new SQLException(SQLError.get("S1000") + ": " + ex.getClass().getName(), "S1000", -1);
            }
            if (this.profileSql) {
                System.err.println(profileMsgBuf.toString());
            }
            return this.buildResultSetWithUpdates(updateCount, updateID, null);
        }
        long fetchStartTime = 0L;
        if (this.profileSql) {
            fetchStartTime = System.currentTimeMillis();
        }
        ResultSet results = this.getResultSet(columnCount, maxRows, resultSetType, streamResults);
        if (this.profileSql) {
            long fetchElapsedTime = System.currentTimeMillis() - fetchStartTime;
            profileMsgBuf.append("result set fetch time:\t");
            profileMsgBuf.append(fetchElapsedTime);
            System.err.println(profileMsgBuf.toString());
        }
        return results;
    }

    final ResultSet sqlQueryDirect(Buffer queryPacket, int maxRows, Connection conn, int resultSetType, boolean streamResults) throws Exception {
        long updateCount = -1L;
        long updateID = -1L;
        StringBuffer profileMsgBuf = null;
        long queryStartTime = 0L;
        if (this.profileSql) {
            profileMsgBuf = new StringBuffer();
            queryStartTime = System.currentTimeMillis();
            byte[] queryBuf = queryPacket.getByteBuffer();
            String query = new String(queryBuf, 5, queryPacket.getPosition() - 5);
            profileMsgBuf.append("Query\t\"");
            profileMsgBuf.append(query);
            profileMsgBuf.append("\"\texecution time:\t");
        }
        this.clearAllReceive();
        Buffer resultPacket = this.sendCommand(3, null, queryPacket);
        if (this.profileSql) {
            long executionTime = System.currentTimeMillis() - queryStartTime;
            profileMsgBuf.append(executionTime);
            profileMsgBuf.append("\t");
        }
        resultPacket.setPosition(resultPacket.getPosition() - 1);
        long columnCount = resultPacket.readLength();
        if (columnCount == 0L) {
            try {
                if (this.useNewUpdateCounts) {
                    updateCount = resultPacket.newReadLength();
                    updateID = resultPacket.newReadLength();
                } else {
                    updateCount = resultPacket.readLength();
                    updateID = resultPacket.readLength();
                }
            }
            catch (Exception ex) {
                throw new SQLException(SQLError.get("S1000") + ": " + ex.getClass().getName(), "S1000", -1);
            }
            if (this.profileSql) {
                System.err.println(profileMsgBuf.toString());
            }
            return this.buildResultSetWithUpdates(updateCount, updateID, conn);
        }
        long fetchStartTime = 0L;
        if (this.profileSql) {
            fetchStartTime = System.currentTimeMillis();
        }
        ResultSet results = this.getResultSet(columnCount, maxRows, resultSetType, streamResults);
        if (this.profileSql) {
            long fetchElapsedTime = System.currentTimeMillis() - fetchStartTime;
            profileMsgBuf.append("result set fetch time:\t");
            profileMsgBuf.append(fetchElapsedTime);
            System.err.println(profileMsgBuf.toString());
        }
        return results;
    }

    boolean versionMeetsMinimum(int major, int minor, int subminor) {
        if (this.getServerMajorVersion() >= major) {
            if (this.getServerMajorVersion() == major) {
                if (this.getServerMinorVersion() >= minor) {
                    if (this.getServerMinorVersion() == minor) {
                        return this.getServerSubMinorVersion() >= subminor;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void clearAllReceive() throws SQLException {
        try {
            int len = this.mysqlInput.available();
            if (len > 0) {
                Buffer packet = this.readPacket();
                if (packet.getByteBuffer()[0] == -1) {
                    this.clearReceive();
                    return;
                }
                while (!packet.isLastDataPacket() && (packet = this.readPacket()).getByteBuffer()[0] != -1) {
                }
            }
            this.clearReceive();
            return;
        }
        catch (IOException ioEx) {
            throw new SQLException("Communication link failure: " + ioEx.getClass().getName(), "08S01");
        }
    }

    private final void clearReceive() throws IOException {
        int len = this.mysqlInput.available();
        if (len > 0) {
            // empty if block
        }
    }

    final byte[][] nextRow(int columnCount) throws Exception {
        int offset;
        Buffer rowPacket = this.reuseAndReadPacket(this.reusablePacket);
        if (rowPacket.readByte() == -1) {
            int errno = 2000;
            if (this.protocolVersion > 9) {
                errno = rowPacket.readInt();
                String errorMessage = rowPacket.readString();
                String xOpen = SQLError.mysqlToXOpen(errno);
                this.clearReceive();
                throw new SQLException(SQLError.get(SQLError.get(xOpen)) + ": " + errorMessage, xOpen, errno);
            }
            String errorMessage = rowPacket.readString();
            this.clearReceive();
            throw new SQLException(errorMessage, SQLError.mysqlToXOpen(errno), errno);
        }
        rowPacket.setPosition(rowPacket.getPosition() - 1);
        int[] dataStart = new int[columnCount];
        byte[][] rowData = new byte[columnCount][];
        int n = offset = rowPacket.wasMultiPacket() ? 5 : 0;
        if (!rowPacket.isLastDataPacket()) {
            int i = 0;
            while (i < columnCount) {
                int p;
                dataStart[i] = p = rowPacket.getPosition();
                rowPacket.setPosition((int)rowPacket.readLength() + rowPacket.getPosition());
                ++i;
            }
            int i2 = 0;
            while (i2 < columnCount) {
                rowPacket.setPosition(dataStart[i2]);
                rowData[i2] = rowPacket.readLenByteArray(offset);
                ++i2;
            }
            return rowData;
        }
        return null;
    }

    private final void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    private final Buffer readPacket() throws IOException {
        int packetLength = this.mysqlInput.read() + (this.mysqlInput.read() << 8) + (this.mysqlInput.read() << 16);
        if (packetLength == -65793) {
            this.forceClose();
            throw new IOException("Unexpected end of input stream");
        }
        this.mysqlInput.skip(1L);
        byte[] buffer = new byte[packetLength + 1];
        this.readFully(this.mysqlInput, buffer, 0, packetLength);
        buffer[packetLength] = 0;
        return new Buffer(buffer);
    }

    private final Buffer reuseAndReadPacket(Buffer reuse) throws IOException, SQLException {
        if (reuse.wasMultiPacket()) {
            int bytesAvail = this.mysqlInput.available();
            if (bytesAvail <= 2) {
                reuse.setBufLength(1);
                reuse.setPosition(0);
                reuse.writeByte((byte)-2);
                this.mysqlInput.skip(bytesAvail);
            }
            reuse.setWasMultiPacket(false);
            return reuse;
        }
        reuse.setWasMultiPacket(false);
        int packetLength = this.mysqlInput.read() + (this.mysqlInput.read() << 8) + (this.mysqlInput.read() << 16);
        if (packetLength == -65793) {
            this.forceClose();
            throw new IOException("Unexpected end of input stream");
        }
        byte multiPacketSeq = (byte)this.mysqlInput.read();
        reuse.setPosition(0);
        reuse.setSendLength(0);
        if (reuse.getByteBuffer().length <= packetLength) {
            reuse.setByteBuffer(new byte[packetLength + 1]);
        }
        reuse.setBufLength(packetLength);
        this.readFully(this.mysqlInput, reuse.getByteBuffer(), 0, packetLength);
        boolean isMultiPacket = false;
        if ((long)packetLength == 16581375L) {
            reuse.setPosition(16581375);
            int packetEndPoint = packetLength;
            isMultiPacket = true;
            packetLength = this.mysqlInput.read() + (this.mysqlInput.read() << 8) + (this.mysqlInput.read() << 16);
            if (packetLength == -65793) {
                this.forceClose();
                throw new IOException("Unexpected end of input stream");
            }
            Buffer multiPacket = new Buffer(packetLength);
            boolean firstMultiPkt = true;
            while (true) {
                if (!firstMultiPkt) {
                    packetLength = this.mysqlInput.read() + (this.mysqlInput.read() << 8) + (this.mysqlInput.read() << 16);
                    if (packetLength == -65793) {
                        this.forceClose();
                        throw new IOException("Unexpected end of input stream");
                    }
                } else {
                    firstMultiPkt = false;
                }
                if (packetLength == 1) break;
                byte newPacketSeq = (byte)this.mysqlInput.read();
                if (newPacketSeq != multiPacketSeq + 1) {
                    throw new IOException("Packets received out of order");
                }
                multiPacketSeq = newPacketSeq;
                multiPacket.setPosition(0);
                multiPacket.setSendLength(0);
                multiPacket.setBufLength(packetLength);
                byte[] byteBuf = multiPacket.getByteBuffer();
                int lengthToWrite = packetLength;
                this.readFully(this.mysqlInput, byteBuf, 0, packetLength);
                reuse.writeBytesNoNull(byteBuf, 0, lengthToWrite);
                packetEndPoint += lengthToWrite;
            }
            reuse.writeByte((byte)0);
            reuse.setPosition(0);
            reuse.setWasMultiPacket(true);
        }
        if (!isMultiPacket) {
            reuse.getByteBuffer()[packetLength] = 0;
        }
        return reuse;
    }

    private final void send(Buffer packet) throws IOException {
        int l = packet.getPosition();
        if (this.serverMajorVersion >= 4 && (long)l >= 16581375L) {
            this.sendSplitPackets(packet);
        } else {
            this.packetSequence = (byte)(this.packetSequence + 1);
            packet.setPosition(0);
            packet.writeLongInt(l - 4);
            packet.writeByte(this.packetSequence);
            this.mysqlOutput.write(packet.getByteBuffer(), 0, l);
            this.mysqlOutput.flush();
        }
    }

    private final void sendSplitPackets(Buffer packet) throws IOException {
        Buffer headerPacket;
        Buffer buffer = headerPacket = this.splitBufRef == null ? null : (Buffer)this.splitBufRef.get();
        if (headerPacket == null) {
            headerPacket = new Buffer(16581379);
            this.splitBufRef = new SoftReference<Buffer>(headerPacket);
        }
        int len = packet.getPosition();
        int splitSize = 16581375;
        int originalPacketPos = 4;
        byte[] origPacketBytes = packet.getByteBuffer();
        byte[] headerPacketBytes = headerPacket.getByteBuffer();
        while ((long)len >= 16581375L) {
            headerPacket.setPosition(0);
            headerPacket.writeLongInt(splitSize);
            this.packetSequence = (byte)(this.packetSequence + 1);
            headerPacket.writeByte(this.packetSequence);
            System.arraycopy(origPacketBytes, originalPacketPos, headerPacketBytes, 4, splitSize);
            this.mysqlOutput.write(headerPacketBytes, 0, splitSize + 4);
            this.mysqlOutput.flush();
            originalPacketPos += splitSize;
            len -= splitSize;
        }
        headerPacket.clear();
        headerPacket.setPosition(0);
        headerPacket.writeLongInt(len - 4);
        this.packetSequence = (byte)(this.packetSequence + 1);
        headerPacket.writeByte(this.packetSequence);
        if (len != 0) {
            System.arraycopy(origPacketBytes, originalPacketPos, headerPacketBytes, 4, len - 4);
        }
        this.mysqlOutput.write(headerPacket.getByteBuffer(), 0, len);
        this.mysqlOutput.flush();
    }

    void closeStreamer(RowData streamer) throws SQLException {
        if (this.streamingData == null) {
            throw new SQLException("Attempt to close streaming result set " + streamer + " when no streaming  result set was registered. This is an internal error.");
        }
        if (streamer != this.streamingData) {
            throw new SQLException("Attempt to close streaming result set " + streamer + " that was not registered." + " Only one streaming result set may be open and in use per-connection. Ensure that you have called .close() on " + " any active result sets before attempting more queries.");
        }
        this.streamingData = null;
    }

    private void checkForOutstandingStreamingData() throws SQLException {
        if (this.streamingData != null) {
            throw new SQLException("Streaming result set " + this.streamingData + " is still active." + " Only one streaming result set may be open and in use per-connection. Ensure that you have called .close() on " + " any active result sets before attempting more queries.");
        }
    }

    static {
        COMP_HEADER_LENGTH = 3;
        MAX_THREE_BYTES = 16581375L;
        HEADER_LENGTH = 4;
        MAXBUF = 65535;
        CLIENT_COMPRESS = 32;
        CLIENT_CONNECT_WITH_DB = 8;
        CLIENT_FOUND_ROWS = 2;
        CLIENT_IGNORE_SPACE = 256;
        CLIENT_LOCAL_FILES = 128;
        CLIENT_LONG_FLAG = 4;
        CLIENT_LONG_PASSWORD = 1;
        CLIENT_NO_SCHEMA = 16;
        CLIENT_ODBC = 64;
        CLIENT_PROTOCOL_41 = 16384;
    }
}

