/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.Statement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    protected static SimpleDateFormat TSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static boolean timezoneSet = false;
    static final Object tzMutex = new Object();
    protected static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private static NumberFormat doubleFormatter;
    private static Hashtable templateCache;
    protected boolean[] isNull = null;
    protected boolean[] isStream = null;
    protected InputStream[] parameterStreams = null;
    protected String[] parameterValues = null;
    private String originalSql = null;
    private byte[] streamConvertBuf = new byte[4096];
    private char firstCharOfStmt;
    private boolean hasLimitClause = false;
    private Buffer sendPacket = null;
    private byte[][] staticSqlStrings = null;
    private boolean useTrueBoolean = false;
    private byte[] resultSetByteValues;

    public PreparedStatement(Connection conn, String sql, String catalog) throws SQLException {
        super(conn, catalog);
        if (sql == null) {
            throw new SQLException("SQL String can not be NULL", "S1009");
        }
        this.useTrueBoolean = this.connection.getIO().versionMeetsMinimum(3, 21, 23);
        this.hasLimitClause = sql.toUpperCase().indexOf("LIMIT") != -1;
        char[] statementAsChars = sql.toCharArray();
        int statementLength = statementAsChars.length;
        int placeHolderCount = 0;
        int i = 0;
        while (i < statementLength) {
            if (statementAsChars[i] == '?') {
                ++placeHolderCount;
            }
            if (!Character.isWhitespace(statementAsChars[i])) {
                this.firstCharOfStmt = Character.toUpperCase(statementAsChars[i]);
            }
            ++i;
        }
        ArrayList<EndPoint> endpointList = new ArrayList<EndPoint>(placeHolderCount + 1);
        boolean inQuotes = false;
        int lastParmEnd = 0;
        this.originalSql = sql;
        this.connection = conn;
        int pre1 = 0;
        int pre2 = 0;
        int i2 = 0;
        while (i2 < statementLength) {
            int c = statementAsChars[i2];
            if (c == 39 && pre1 == 92 && pre2 == 92) {
                inQuotes = !inQuotes;
            } else if (c == 39 && pre1 != 92) {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c == 63 && !inQuotes) {
                endpointList.add(new EndPoint(lastParmEnd, i2));
                lastParmEnd = i2 + 1;
            }
            pre2 = pre1;
            pre1 = c;
            ++i2;
        }
        endpointList.add(new EndPoint(lastParmEnd, statementLength));
        this.staticSqlStrings = new byte[endpointList.size()][];
        String characterEncoding = null;
        if (this.connection.useUnicode()) {
            characterEncoding = this.connection.getEncoding();
        }
        i2 = 0;
        while (i2 < this.staticSqlStrings.length) {
            int len;
            int begin;
            int end;
            EndPoint ep;
            if (characterEncoding == null) {
                ep = (EndPoint)endpointList.get(i2);
                end = ep.end;
                begin = ep.begin;
                len = end - begin;
                byte[] buf = new byte[len];
                int j = 0;
                while (j < len) {
                    buf[j] = (byte)statementAsChars[begin + j];
                    ++j;
                }
                this.staticSqlStrings[i2] = buf;
            } else {
                try {
                    ep = (EndPoint)endpointList.get(i2);
                    end = ep.end;
                    begin = ep.begin;
                    len = end - begin;
                    String temp = new String(statementAsChars, begin, len);
                    this.staticSqlStrings[i2] = temp.getBytes(characterEncoding);
                }
                catch (UnsupportedEncodingException ue) {
                    throw new SQLException(ue.toString());
                }
            }
            ++i2;
        }
        this.parameterValues = new String[this.staticSqlStrings.length - 1];
        this.parameterStreams = new InputStream[this.staticSqlStrings.length - 1];
        this.isStream = new boolean[this.staticSqlStrings.length - 1];
        this.isNull = new boolean[this.staticSqlStrings.length - 1];
        this.clearParameters();
        int j = 0;
        while (j < this.parameterValues.length) {
            this.isStream[j] = false;
            ++j;
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new NotImplemented();
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream X, int length) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setBinaryStream(parameterIndex, X, length);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal X) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.setInternal(parameterIndex, PreparedStatement.fixDecimalExponent(X.toString()));
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream X, int length) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, -2);
        } else {
            if (parameterIndex < 1 || parameterIndex > this.staticSqlStrings.length) {
                throw new SQLException("Parameter index out of range (" + parameterIndex + " > " + this.staticSqlStrings.length + ")", "S1009");
            }
            this.parameterStreams[parameterIndex - 1] = X;
            this.isStream[parameterIndex - 1] = true;
            this.isNull[parameterIndex - 1] = false;
        }
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.setBinaryStream(i, x.getBinaryStream(), Integer.MAX_VALUE);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.useTrueBoolean) {
            this.setInternal(parameterIndex, x ? "'1'" : "'0'");
        } else {
            this.setInternal(parameterIndex, x ? "'t'" : "'f'");
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            ByteArrayInputStream BIn = new ByteArrayInputStream(x);
            this.setBinaryStream(parameterIndex, (InputStream)BIn, x.length);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            if (reader == null) {
                this.setNull(parameterIndex, -1);
            } else {
                StringBuffer buf = new StringBuffer(length);
                char[] c = new char[4096];
                int len = 0;
                while ((len = reader.read(c)) != -1) {
                    buf.append(c, 0, len);
                }
                this.setString(parameterIndex, buf.toString());
            }
        }
        catch (IOException ioEx) {
            throw new SQLException(ioEx.toString(), "S1000");
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        throw new NotImplemented();
    }

    public void setDate(int parameterIndex, Date X) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 91);
        } else {
            SimpleDateFormat DF = new SimpleDateFormat("''yyyy-MM-dd''");
            this.setInternal(parameterIndex, DF.format(X));
        }
    }

    public void setDate(int parameterIndex, Date X, Calendar Cal) throws SQLException {
        this.setDate(parameterIndex, X);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setInternal(parameterIndex, PreparedStatement.fixDecimalExponent(String.valueOf(x)));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setInternal(parameterIndex, PreparedStatement.fixDecimalExponent(String.valueOf(x)));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new NotImplemented();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setInternal(parameterIndex, "null");
        this.isNull[parameterIndex - 1] = true;
    }

    public void setNull(int parameterIndex, int sqlType, String Arg) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    public void setObject(int parameterIndex, Object X, int targetSqlType, int scale) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 1111);
        } else {
            try {
                block2 : switch (targetSqlType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        Number X_as_number;
                        if (X instanceof Boolean) {
                            X_as_number = (Boolean)X != false ? new Integer(1) : new Integer(0);
                        } else if (X instanceof String) {
                            switch (targetSqlType) {
                                case -7: {
                                    X_as_number = Boolean.getBoolean((String)X) ? new Integer("1") : new Integer("0");
                                    break;
                                }
                                case -6: 
                                case 4: 
                                case 5: {
                                    X_as_number = Integer.valueOf((String)X);
                                    break;
                                }
                                case -5: {
                                    X_as_number = Long.valueOf((String)X);
                                    break;
                                }
                                case 7: {
                                    X_as_number = Float.valueOf((String)X);
                                    break;
                                }
                                case 6: 
                                case 8: {
                                    X_as_number = Double.valueOf((String)X);
                                    break;
                                }
                                default: {
                                    X_as_number = new BigDecimal((String)X);
                                    break;
                                }
                            }
                        } else {
                            X_as_number = (Number)X;
                        }
                        switch (targetSqlType) {
                            case -7: 
                            case -6: 
                            case 4: 
                            case 5: {
                                this.setInt(parameterIndex, X_as_number.intValue());
                                break block2;
                            }
                            case -5: {
                                this.setLong(parameterIndex, X_as_number.longValue());
                                break block2;
                            }
                            case 7: {
                                this.setFloat(parameterIndex, X_as_number.floatValue());
                                break block2;
                            }
                            case 6: 
                            case 8: {
                                this.setDouble(parameterIndex, X_as_number.doubleValue());
                                break block2;
                            }
                        }
                        if (X_as_number instanceof BigDecimal) {
                            this.setBigDecimal(parameterIndex, (BigDecimal)X_as_number);
                            break;
                        }
                        if (X_as_number instanceof BigInteger) {
                            this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)X_as_number, scale));
                            break;
                        }
                        this.setBigDecimal(parameterIndex, new BigDecimal(X_as_number.doubleValue()));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.setString(parameterIndex, X.toString());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        if (X instanceof String) {
                            this.setBytes(parameterIndex, ((String)X).getBytes());
                            break;
                        }
                        this.setBytes(parameterIndex, (byte[])X);
                        break;
                    }
                    case 91: 
                    case 93: {
                        java.util.Date X_as_date;
                        if (X instanceof String) {
                            ParsePosition pp = new ParsePosition(0);
                            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)X, false));
                            X_as_date = ((DateFormat)sdf).parse((String)X, pp);
                        } else {
                            X_as_date = (java.util.Date)X;
                        }
                        switch (targetSqlType) {
                            case 91: {
                                if (X_as_date instanceof Date) {
                                    this.setDate(parameterIndex, (Date)X_as_date);
                                    break block2;
                                }
                                this.setDate(parameterIndex, new Date(X_as_date.getTime()));
                                break block2;
                            }
                            case 93: {
                                if (X_as_date instanceof Timestamp) {
                                    this.setTimestamp(parameterIndex, (Timestamp)X_as_date);
                                    break block2;
                                }
                                this.setTimestamp(parameterIndex, new Timestamp(X_as_date.getTime()));
                            }
                        }
                        break;
                    }
                    case 92: {
                        if (X instanceof String) {
                            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)X, true));
                            this.setTime(parameterIndex, new Time(sdf.parse((String)X).getTime()));
                            break;
                        }
                        if (X instanceof Timestamp) {
                            Timestamp xT = (Timestamp)X;
                            this.setTime(parameterIndex, new Time(xT.getHours(), xT.getMinutes(), xT.getSeconds()));
                            break;
                        }
                        this.setTime(parameterIndex, (Time)X);
                        break;
                    }
                    case 1111: {
                        try {
                            ByteArrayOutputStream BytesOut = new ByteArrayOutputStream();
                            ObjectOutputStream ObjectOut = new ObjectOutputStream(BytesOut);
                            ObjectOut.writeObject(X);
                            ObjectOut.flush();
                            ObjectOut.close();
                            BytesOut.flush();
                            BytesOut.close();
                            byte[] buf = BytesOut.toByteArray();
                            ByteArrayInputStream BytesIn = new ByteArrayInputStream(buf);
                            this.setBinaryStream(parameterIndex, (InputStream)BytesIn, -1);
                            break;
                        }
                        catch (Exception E) {
                            throw new SQLException("Invalid argument value: " + E.getClass().getName(), "S1009");
                        }
                    }
                    default: {
                        throw new SQLException("Unknown Types value", "S1000");
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new SQLException("Cannot convert " + X.getClass().toString() + " to SQL type requested due to " + ex.getClass().getName() + " - " + ex.getMessage(), "S1000");
            }
        }
    }

    public void setObject(int parameterIndex, Object X, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, X, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object X) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 1111);
        } else if (X instanceof Byte) {
            this.setInt(parameterIndex, ((Byte)X).intValue());
        } else if (X instanceof String) {
            this.setString(parameterIndex, (String)X);
        } else if (X instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)X);
        } else if (X instanceof Short) {
            this.setShort(parameterIndex, (Short)X);
        } else if (X instanceof Integer) {
            this.setInt(parameterIndex, (Integer)X);
        } else if (X instanceof Long) {
            this.setLong(parameterIndex, (Long)X);
        } else if (X instanceof Float) {
            this.setFloat(parameterIndex, ((Float)X).floatValue());
        } else if (X instanceof Double) {
            this.setDouble(parameterIndex, (Double)X);
        } else if (X instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])X);
        } else if (X instanceof Date) {
            this.setDate(parameterIndex, (Date)X);
        } else if (X instanceof Time) {
            this.setTime(parameterIndex, (Time)X);
        } else if (X instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)X);
        } else if (X instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)X);
        } else if (X instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)X, -1);
        } else if (X instanceof Blob) {
            this.setBinaryStream(parameterIndex, ((Blob)X).getBinaryStream(), -1);
        } else {
            try {
                ByteArrayOutputStream BytesOut = new ByteArrayOutputStream();
                ObjectOutputStream ObjectOut = new ObjectOutputStream(BytesOut);
                ObjectOut.writeObject(X);
                ObjectOut.flush();
                ObjectOut.close();
                BytesOut.flush();
                BytesOut.close();
                byte[] buf = BytesOut.toByteArray();
                ByteArrayInputStream BytesIn = new ByteArrayInputStream(buf);
                this.setBinaryStream(parameterIndex, (InputStream)BytesIn, -1);
            }
            catch (Exception E) {
                throw new SQLException("Invalid argument value: " + E.getClass().getName(), "S1009");
            }
        }
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new NotImplemented();
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setInternal(parameterIndex, String.valueOf(x));
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.setInternal(parameterIndex, "null");
        } else {
            StringBuffer B = new StringBuffer((int)((double)x.length() * 1.1));
            B.append('\'');
            int i = 0;
            while (i < x.length()) {
                char c = x.charAt(i);
                switch (c) {
                    case '\u0000': {
                        B.append('\\');
                        B.append('0');
                        break;
                    }
                    case '\n': {
                        B.append('\\');
                        B.append('n');
                        break;
                    }
                    case '\r': {
                        B.append('\\');
                        B.append('r');
                        break;
                    }
                    case '\\': {
                        B.append('\\');
                        B.append('\\');
                        break;
                    }
                    case '\'': {
                        B.append('\\');
                        B.append('\'');
                        break;
                    }
                    case '\"': {
                        B.append('\\');
                        B.append('\"');
                        break;
                    }
                    case '\u001a': {
                        B.append('\\');
                        B.append('Z');
                        break;
                    }
                    default: {
                        B.append(c);
                    }
                }
                ++i;
            }
            B.append('\'');
            this.setInternal(parameterIndex, B.toString());
        }
    }

    public void setTime(int parameterIndex, Time X) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 92);
        } else {
            this.setInternal(parameterIndex, "'" + X.toString() + "'");
        }
    }

    public void setTime(int parameterIndex, Time X, Calendar Cal) throws SQLException {
        this.setTime(parameterIndex, X);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int parameterIndex, Timestamp X) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 93);
        } else {
            String TimestampString = null;
            SimpleDateFormat simpleDateFormat = TSDF;
            synchronized (simpleDateFormat) {
                TimestampString = "'" + TSDF.format(X) + "'";
            }
            this.setInternal(parameterIndex, TimestampString);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp X, Calendar Cal) throws SQLException {
        this.setTimestamp(parameterIndex, X);
    }

    public void setUnicodeStream(int parameterIndex, InputStream X, int length) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setBinaryStream(parameterIndex, X, length);
        }
    }

    public void addBatch() throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        this.batchedArgs.add(new BatchParams(this.parameterValues, this.parameterStreams, this.isStream, this.isNull));
    }

    public void clearParameters() throws SQLException {
        int i = 0;
        while (i < this.parameterValues.length) {
            this.parameterValues[i] = null;
            this.parameterStreams[i] = null;
            this.isStream[i] = false;
            this.isNull[i] = false;
            ++i;
        }
    }

    public void close() throws SQLException {
        super.close();
        this.originalSql = null;
        this.staticSqlStrings = null;
        this.parameterValues = null;
        this.parameterStreams = null;
        this.isStream = null;
        this.isNull = null;
        this.streamConvertBuf = null;
        this.sendPacket = null;
        templateCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        if (this.connection.isReadOnly() && this.firstCharOfStmt != 'S') {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        this.checkClosed();
        if (this.sendPacket == null) {
            this.sendPacket = new Buffer(this.connection.getNetBufferLength(), this.connection.getMaxAllowedPacket());
        } else {
            this.sendPacket.clear();
        }
        this.sendPacket.writeByte((byte)3);
        String Encoding = null;
        if (this.connection.useUnicode()) {
            Encoding = this.connection.getEncoding();
        }
        try {
            int i = 0;
            while (i < this.parameterValues.length) {
                if (this.parameterValues[i] == null && this.parameterStreams[i] == null) {
                    throw new SQLException("No value specified for parameter " + (i + 1));
                }
                this.sendPacket.writeBytesNoNull(this.staticSqlStrings[i]);
                if (this.isStream[i]) {
                    this.sendPacket.writeBytesNoNull(this.streamToBytes(this.parameterStreams[i]));
                } else if (Encoding != null) {
                    this.sendPacket.writeStringNoNull(this.parameterValues[i], Encoding);
                } else {
                    this.sendPacket.writeStringNoNull(this.parameterValues[i]);
                }
                ++i;
            }
            this.sendPacket.writeBytesNoNull(this.staticSqlStrings[this.parameterValues.length]);
        }
        catch (UnsupportedEncodingException UE) {
            throw new SQLException("Unsupported character encoding '" + Encoding + "'");
        }
        ResultSet RS = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String OldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                OldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                if (this.firstCharOfStmt == 'S') {
                    if (this.hasLimitClause) {
                        RS = this.connection.execSQL(null, this.maxRows, this.sendPacket, this.resultSetType, this.createStreamingResultSet());
                    } else if (this.maxRows <= 0) {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                    } else {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1);
                    }
                } else {
                    this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                }
                RS = this.connection.execSQL(null, -1, this.sendPacket, this.resultSetType, this.createStreamingResultSet());
            } else {
                RS = this.connection.execSQL(null, -1, this.sendPacket, this.resultSetType, this.createStreamingResultSet());
            }
            if (OldCatalog != null) {
                this.connection.setCatalog(OldCatalog);
            }
        }
        this.lastInsertId = RS.getUpdateID();
        if (RS != null) {
            this.results = RS;
        }
        RS.setConnection(this.connection);
        RS.setResultSetType(this.resultSetType);
        RS.setResultSetConcurrency(this.resultSetConcurrency);
        RS.setStatement(this);
        return RS != null && RS.reallyResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.connection.isReadOnly()) {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        try {
            int[] updateCounts = null;
            if (this.batchedArgs != null) {
                int nbrCommands = this.batchedArgs.size();
                updateCounts = new int[nbrCommands];
                int i = 0;
                while (i < nbrCommands) {
                    updateCounts[i] = -3;
                    ++i;
                }
                Throwable sqlEx = null;
                int i2 = 0;
                while (i2 < nbrCommands) {
                    Object arg = this.batchedArgs.get(i2);
                    if (arg instanceof String) {
                        updateCounts[i2] = this.executeUpdate((String)arg);
                    } else {
                        BatchParams paramArg = (BatchParams)arg;
                        try {
                            updateCounts[i2] = this.executeUpdate(paramArg.parameterStrings, paramArg.parameterStreams, paramArg.isStream, paramArg.isNull);
                        }
                        catch (SQLException ex) {
                            sqlEx = ex;
                        }
                    }
                    ++i2;
                }
                if (sqlEx != null) {
                    throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                }
            }
            nArray = updateCounts != null ? updateCounts : new int[]{};
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.sql.ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        if (this.sendPacket == null) {
            this.sendPacket = new Buffer(this.connection.getNetBufferLength(), this.connection.getMaxAllowedPacket());
        } else {
            this.sendPacket.clear();
        }
        this.sendPacket.writeByte((byte)3);
        String Encoding = null;
        if (this.connection.useUnicode()) {
            Encoding = this.connection.getEncoding();
        }
        try {
            int i = 0;
            while (i < this.parameterValues.length) {
                if (this.parameterValues[i] == null && this.parameterStreams[i] == null) {
                    throw new SQLException("No value specified for parameter " + (i + 1), "07001");
                }
                this.sendPacket.writeBytesNoNull(this.staticSqlStrings[i]);
                if (this.isStream[i]) {
                    this.sendPacket.writeBytesNoNull(this.streamToBytes(this.parameterStreams[i]));
                } else if (Encoding != null) {
                    this.sendPacket.writeStringNoNull(this.parameterValues[i], Encoding);
                } else {
                    this.sendPacket.writeStringNoNull(this.parameterValues[i]);
                }
                ++i;
            }
            this.sendPacket.writeBytesNoNull(this.staticSqlStrings[this.parameterValues.length]);
        }
        catch (UnsupportedEncodingException UE) {
            throw new SQLException("Unsupported character encoding '" + Encoding + "'");
        }
        if (this.results != null) {
            this.results.close();
        }
        Object object = this.connection.getMutex();
        synchronized (object) {
            String OldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                OldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                if (this.hasLimitClause) {
                    this.results = this.connection.execSQL(null, this.maxRows, this.sendPacket, this.resultSetType, this.createStreamingResultSet());
                } else {
                    if (this.maxRows <= 0) {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                    } else {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1);
                    }
                    this.results = this.connection.execSQL(null, -1, this.sendPacket, this.resultSetType, this.createStreamingResultSet());
                    if (OldCatalog != null) {
                        this.connection.setCatalog(OldCatalog);
                    }
                }
            } else {
                this.results = this.connection.execSQL(null, -1, this.sendPacket, this.resultSetType, this.createStreamingResultSet());
            }
            if (OldCatalog != null) {
                this.connection.setCatalog(OldCatalog);
            }
        }
        this.lastInsertId = this.results.getUpdateID();
        this.nextResults = this.results;
        this.results.setConnection(this.connection);
        this.results.setResultSetType(this.resultSetType);
        this.results.setResultSetConcurrency(this.resultSetConcurrency);
        this.results.setStatement(this);
        if (!this.results.reallyResult()) {
            if (!this.connection.getAutoCommit()) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new SQLException("Can not issue INSERT/UPDATE/DELETE with executeQuery()", "S1009");
        }
        return this.results;
    }

    public synchronized int executeUpdate() throws SQLException {
        return this.executeUpdate(this.parameterValues, this.parameterStreams, this.isStream, this.isNull);
    }

    public String toString() {
        String Encoding = null;
        if (this.connection != null && this.connection.useUnicode()) {
            Encoding = this.connection.getEncoding();
        }
        StringBuffer SB = new StringBuffer();
        SB.append(super.toString());
        SB.append(": ");
        try {
            int i = 0;
            while (i < this.parameterValues.length) {
                if (Encoding != null) {
                    SB.append(new String(this.staticSqlStrings[i], Encoding));
                } else {
                    SB.append(new String(this.staticSqlStrings[i]));
                }
                if (this.parameterValues[i] == null && !this.isStream[i]) {
                    SB.append("** NOT SPECIFIED **");
                } else if (this.isStream[i]) {
                    SB.append("** STREAM DATA **");
                } else {
                    if (this.doEscapeProcessing) {
                        try {
                            this.parameterValues[i] = this.escaper.escapeSQL(this.parameterValues[i]);
                        }
                        catch (SQLException SQE) {
                            // empty catch block
                        }
                    }
                    if (Encoding != null) {
                        SB.append(new String(this.parameterValues[i].getBytes(), Encoding));
                    } else {
                        SB.append(new String(this.parameterValues[i].getBytes()));
                    }
                }
                ++i;
            }
            if (Encoding != null) {
                SB.append(new String(this.staticSqlStrings[this.parameterValues.length], Encoding));
            } else {
                SB.append(this.staticSqlStrings[this.parameterValues.length]);
            }
        }
        catch (UnsupportedEncodingException UE) {
            SB.append("\n\n** WARNING **\n\n Unsupported character encoding '");
            SB.append(Encoding);
            SB.append("'");
        }
        return SB.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int executeUpdate(String[] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, boolean[] batchedIsNull) throws SQLException {
        if (this.connection.isReadOnly()) {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        this.checkClosed();
        if (this.sendPacket == null) {
            this.sendPacket = new Buffer(this.connection.getNetBufferLength(), this.connection.getMaxAllowedPacket());
        } else {
            this.sendPacket.clear();
        }
        this.sendPacket.writeByte((byte)3);
        String Encoding = null;
        if (this.connection.useUnicode()) {
            Encoding = this.connection.getEncoding();
        }
        try {
            int i = 0;
            while (i < batchedParameterStrings.length) {
                if (batchedParameterStrings[i] == null && batchedParameterStreams[i] == null) {
                    throw new SQLException("No value specified for parameter " + (i + 1), "07001");
                }
                this.sendPacket.writeBytesNoNull(this.staticSqlStrings[i]);
                if (batchedIsStream[i]) {
                    this.sendPacket.writeBytesNoNull(this.streamToBytes(batchedParameterStreams[i]));
                } else if (Encoding != null) {
                    this.sendPacket.writeStringNoNull(batchedParameterStrings[i], Encoding);
                } else {
                    this.sendPacket.writeStringNoNull(batchedParameterStrings[i]);
                }
                ++i;
            }
            this.sendPacket.writeBytesNoNull(this.staticSqlStrings[batchedParameterStrings.length]);
        }
        catch (UnsupportedEncodingException UE) {
            throw new SQLException("Unsupported character encoding '" + Encoding + "'");
        }
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
            }
            rs = this.connection.execSQL(null, -1, this.sendPacket, this.resultSetType, false);
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        if (rs.reallyResult()) {
            throw new SQLException("Results returned for UPDATE ONLY.", "01S03");
        }
        this.updateCount = rs.getUpdateCount();
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.updateCount;
        this.lastInsertId = rs.getUpdateID();
        return truncatedUpdateCount;
    }

    protected static final String fixDecimalExponent(String dString) {
        char maybeMinusChar;
        int ePos = dString.indexOf("E");
        if (ePos == -1) {
            ePos = dString.indexOf("e");
        }
        if (ePos != -1 && dString.length() > ePos + 1 && (maybeMinusChar = dString.charAt(ePos + 1)) != '-') {
            StringBuffer buf = new StringBuffer(dString.length() + 1);
            buf.append(dString.substring(0, ePos + 1));
            buf.append('+');
            buf.append(dString.substring(ePos + 1, dString.length()));
            dString = buf.toString();
        }
        return dString;
    }

    protected final byte[] streamToBytes(InputStream in) throws SQLException {
        return this.streamToBytes(in, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] streamToBytes(InputStream in, boolean escape) throws SQLException {
        byte[] byArray;
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            int bc = this.readblock(in, this.streamConvertBuf);
            if (escape) {
                bytesOut.write(39);
            }
            while (bc > 0) {
                if (escape) {
                    this.escapeblockFast(this.streamConvertBuf, bytesOut, bc);
                } else {
                    bytesOut.write(this.streamConvertBuf, 0, bc);
                }
                bc = this.readblock(in, this.streamConvertBuf);
            }
            if (escape) {
                bytesOut.write(39);
            }
            byArray = bytesOut.toByteArray();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                in.close();
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            in = null;
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        in = null;
        return byArray;
    }

    byte[] getBytes(int parameterIndex) throws SQLException {
        if (this.isStream[parameterIndex]) {
            return this.streamToBytes(this.parameterStreams[parameterIndex], false);
        }
        String encoding = null;
        if (this.connection.useUnicode()) {
            encoding = this.connection.getEncoding();
        }
        if (encoding != null) {
            try {
                String stringVal = this.parameterValues[parameterIndex];
                if (stringVal.startsWith("'") && stringVal.endsWith("'")) {
                    stringVal = stringVal.substring(1, stringVal.length() - 1);
                }
                return stringVal.getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException("Unsupported character encoding '" + encoding + "'");
            }
        }
        String stringVal = this.parameterValues[parameterIndex];
        if (stringVal.startsWith("'") && stringVal.endsWith("'")) {
            stringVal = stringVal.substring(1, stringVal.length() - 1);
        }
        return stringVal.getBytes();
    }

    boolean isNull(int paramIndex) {
        return this.isNull[paramIndex];
    }

    void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    private final String getDateTimePattern(String dt, boolean toTime) throws Exception {
        int i;
        int size;
        char c;
        int n;
        Object[] v;
        int z;
        char c2;
        int dtLength;
        int n2 = dtLength = dt != null ? dt.length() : 0;
        if (dtLength >= 8 && dtLength <= 10) {
            int dashCount = 0;
            boolean isDateOnly = true;
            int i2 = 0;
            while (i2 < dtLength) {
                c2 = dt.charAt(i2);
                if (!Character.isDigit(c2) && c2 != '-') {
                    isDateOnly = false;
                    break;
                }
                if (c2 == '-') {
                    ++dashCount;
                }
                ++i2;
            }
            if (isDateOnly && dashCount == 2) {
                return "yyyy-MM-dd";
            }
        }
        boolean colonsOnly = true;
        int i3 = 0;
        while (i3 < dtLength) {
            char c3 = dt.charAt(i3);
            if (!Character.isDigit(c3) && c3 != ':') {
                colonsOnly = false;
                break;
            }
            ++i3;
        }
        if (colonsOnly) {
            return "HH:mm:ss";
        }
        StringReader reader = new StringReader(dt + " ");
        ArrayList<Object[]> vec = new ArrayList<Object[]>();
        ArrayList<Object[]> vec_removelist = new ArrayList<Object[]>();
        Object[] nv = new Object[]{new Character('y'), new StringBuffer(), new Integer(0)};
        vec.add(nv);
        if (toTime) {
            nv = new Object[]{new Character('h'), new StringBuffer(), new Integer(0)};
            vec.add(nv);
        }
        while ((z = reader.read()) != -1) {
            char separator = c2;
            int maxvecs = vec.size();
            int count = 0;
            while (count < maxvecs) {
                v = (Object[])vec.get(count);
                n = (Integer)v[2];
                c = this.getSuccessor(((Character)v[0]).charValue(), n);
                if (!Character.isLetterOrDigit(separator)) {
                    if (c == ((Character)v[0]).charValue() && c != 'S') {
                        vec_removelist.add(v);
                    } else {
                        ((StringBuffer)v[1]).append(separator);
                        if (c == 'X' || c == 'Y') {
                            v[2] = new Integer(4);
                        }
                    }
                } else {
                    if (c == 'X') {
                        c = 'y';
                        nv = new Object[3];
                        nv[1] = new StringBuffer(((StringBuffer)v[1]).toString()).append('M');
                        nv[0] = new Character('M');
                        nv[2] = new Integer(1);
                        vec.add(nv);
                    } else if (c == 'Y') {
                        c = 'M';
                        nv = new Object[3];
                        nv[1] = new StringBuffer(((StringBuffer)v[1]).toString()).append('d');
                        nv[0] = new Character('d');
                        nv[2] = new Integer(1);
                        vec.add(nv);
                    }
                    ((StringBuffer)v[1]).append(c);
                    if (c == ((Character)v[0]).charValue()) {
                        v[2] = new Integer(n + 1);
                    } else {
                        v[0] = new Character(c);
                        v[2] = new Integer(1);
                    }
                }
                ++count;
            }
            size = vec_removelist.size();
            i = 0;
            while (i < size) {
                v = (Object[])vec_removelist.get(i);
                vec.remove(v);
                ++i;
            }
            vec_removelist.clear();
        }
        size = vec.size();
        i = 0;
        while (i < size) {
            boolean containsEnd;
            v = (Object[])vec.get(i);
            c = ((Character)v[0]).charValue();
            boolean bk = this.getSuccessor(c, n = ((Integer)v[2]).intValue()) != c;
            boolean atEnd = (c == 's' || c == 'm' || c == 'h' && toTime) && bk;
            boolean finishesAtDate = bk && c == 'd' && !toTime;
            boolean bl = containsEnd = ((StringBuffer)v[1]).toString().indexOf(87) != -1;
            if (!atEnd && !finishesAtDate || containsEnd) {
                vec_removelist.add(v);
            }
            ++i;
        }
        size = vec_removelist.size();
        int i4 = 0;
        while (i4 < size) {
            vec.remove(vec_removelist.get(i4));
            ++i4;
        }
        vec_removelist.clear();
        v = (Object[])vec.get(0);
        StringBuffer format = (StringBuffer)v[1];
        format.setLength(format.length() - 1);
        return format.toString();
    }

    private final void setInternal(int paramIndex, String val) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.staticSqlStrings.length) {
            throw new SQLException("Parameter index out of range (" + paramIndex + " > " + this.staticSqlStrings.length + ").", "S1009");
        }
        this.isStream[paramIndex - 1] = false;
        this.isNull[paramIndex - 1] = false;
        this.parameterStreams[paramIndex - 1] = null;
        this.parameterValues[paramIndex - 1] = val;
    }

    private final char getSuccessor(char c, int n) {
        return (char)(c == 'y' && n == 2 ? 88 : (c == 'y' && n < 4 ? 121 : (c == 'y' ? 77 : (c == 'M' && n == 2 ? 89 : (c == 'M' && n < 3 ? 77 : (c == 'M' ? 100 : (c == 'd' && n < 2 ? 100 : (c == 'd' ? 72 : (c == 'H' && n < 2 ? 72 : (c == 'H' ? 109 : (c == 'm' && n < 2 ? 109 : (c == 'm' ? 115 : (c == 's' && n < 2 ? 115 : 87)))))))))))));
    }

    private final void escapeblockFast(byte[] buf, ByteArrayOutputStream bytesOut, int size) {
        int lastwritten = 0;
        int i = 0;
        while (i < size) {
            byte b = buf[i];
            if (b == 0) {
                if (i > lastwritten) {
                    bytesOut.write(buf, lastwritten, i - lastwritten);
                }
                bytesOut.write(92);
                bytesOut.write(48);
                lastwritten = i + 1;
            } else if (b == 92 || b == 39 || b == 34) {
                if (i > lastwritten) {
                    bytesOut.write(buf, lastwritten, i - lastwritten);
                }
                bytesOut.write(92);
                lastwritten = i;
            }
            ++i;
        }
        if (lastwritten < size) {
            bytesOut.write(buf, lastwritten, size - lastwritten);
        }
    }

    private final void escapeblock(byte[] buf, ByteArrayOutputStream bytesOut, int size) {
        byte[] out = new byte[buf.length * 2];
        int iIndex = 0;
        int i = 0;
        while (i < size) {
            byte b = buf[i];
            switch (b) {
                case 0: {
                    out[iIndex++] = 92;
                    out[iIndex++] = 48;
                    break;
                }
                case 10: {
                    out[iIndex++] = 92;
                    out[iIndex++] = 110;
                    break;
                }
                case 13: {
                    out[iIndex++] = 92;
                    out[iIndex++] = 114;
                    break;
                }
                case 92: {
                    out[iIndex++] = 92;
                    out[iIndex++] = 92;
                    break;
                }
                case 39: {
                    out[iIndex++] = 92;
                    out[iIndex++] = 39;
                    break;
                }
                case 34: {
                    out[iIndex++] = 92;
                    out[iIndex++] = 34;
                    break;
                }
                case 26: {
                    out[iIndex++] = 92;
                    out[iIndex++] = 90;
                    break;
                }
                default: {
                    out[iIndex++] = b;
                }
            }
            ++i;
        }
        bytesOut.write(out, 0, iIndex);
    }

    private final int readblock(InputStream i, byte[] b) throws SQLException {
        try {
            return i.read(b);
        }
        catch (Throwable E) {
            throw new SQLException("Error reading from InputStream " + E.getClass().getName(), "S1000");
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new NotImplemented();
    }

    public void setURL(int parameterIndex, URL arg) throws SQLException {
        if (arg != null) {
            this.setString(parameterIndex, arg.toString());
        } else {
            this.setNull(parameterIndex, 1);
        }
    }

    static {
        templateCache = new Hashtable();
        doubleFormatter = NumberFormat.getNumberInstance(Locale.US);
        doubleFormatter.setGroupingUsed(false);
        doubleFormatter.setMaximumFractionDigits(12);
    }

    class EndPoint {
        int begin;
        int end;

        EndPoint(int b, int e) {
            this.begin = b;
            this.end = e;
        }
    }

    class BatchParams {
        boolean[] isNull = null;
        boolean[] isStream = null;
        InputStream[] parameterStreams = null;
        String[] parameterStrings = null;

        BatchParams(String[] strings, InputStream[] streams, boolean[] isStreamFlags, boolean[] isNullFlags) {
            this.parameterStrings = new String[strings.length];
            this.parameterStreams = new InputStream[streams.length];
            this.isStream = new boolean[isStreamFlags.length];
            this.isNull = new boolean[isNullFlags.length];
            System.arraycopy(strings, 0, this.parameterStrings, 0, strings.length);
            System.arraycopy(streams, 0, this.parameterStreams, 0, streams.length);
            System.arraycopy(isStreamFlags, 0, this.isStream, 0, isStreamFlags.length);
            System.arraycopy(isNullFlags, 0, this.isNull, 0, isNullFlags.length);
        }
    }
}

