/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Field;
import java.sql.SQLException;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    Field[] Fields;

    public ResultSetMetaData(Field[] Fields) {
        this.Fields = Fields;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return true;
    }

    public String getCatalogName(int column) throws SQLException {
        Field F = this.getField(column);
        return "";
    }

    public String getColumnClassName(int column) throws SQLException {
        Field f = this.getField(column);
        switch (f.getSQLType()) {
            case -7: {
                return "java.lang.Boolean";
            }
            case -6: {
                if (f.isUnsigned()) {
                    return "java.lang.Integer";
                }
                return "java.lang.Byte";
            }
            case 5: {
                if (f.isUnsigned()) {
                    return "java.lang.Integer";
                }
                return "java.lang.Short";
            }
            case 4: {
                if (f.isUnsigned()) {
                    return "java.lang.Long";
                }
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 6: 
            case 7: {
                return "java.lang.Float";
            }
            case 8: {
                return "java.lang.Double";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -4: 
            case -3: 
            case -2: {
                if (!f.isBlob()) {
                    return "java.lang.String";
                }
                if (!f.isBinary()) {
                    return "java.lang.String";
                }
                return "java.lang.Object";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return "java.lang.Object";
    }

    public int getColumnCount() throws SQLException {
        return this.Fields.length;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getField(column).getLength();
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    public String getColumnName(int column) throws SQLException {
        return this.getField(column).getName();
    }

    public int getColumnType(int column) throws SQLException {
        return this.getField(column).getSQLType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        int mysql_type = this.getField(column).getMysqlType();
        switch (mysql_type) {
            case 0: {
                return "DECIMAL";
            }
            case 1: {
                return "TINY";
            }
            case 2: {
                return "SHORT";
            }
            case 3: {
                return "LONG";
            }
            case 4: {
                return "FLOAT";
            }
            case 5: {
                return "DOUBLE";
            }
            case 6: {
                return "NULL";
            }
            case 7: {
                return "TIMESTAMP";
            }
            case 8: {
                return "LONGLONG";
            }
            case 9: {
                return "INT";
            }
            case 10: {
                return "DATE";
            }
            case 11: {
                return "TIME";
            }
            case 12: {
                return "DATETIME";
            }
            case 249: {
                return "TINYBLOB";
            }
            case 250: {
                return "MEDIUMBLOB";
            }
            case 251: {
                return "LONGBLOB";
            }
            case 252: {
                if (this.getField(column).isBinary()) {
                    return "TEXT";
                }
                return "BLOB";
            }
            case 253: {
                return "VARCHAR";
            }
            case 254: {
                return "CHAR";
            }
            case 247: {
                return "ENUM";
            }
            case 248: {
                return "SET";
            }
        }
        return "UNKNOWN";
    }

    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    public int isNullable(int column) throws SQLException {
        if (!this.getField(column).isNotNull()) {
            return 1;
        }
        return 0;
    }

    public int getPrecision(int column) throws SQLException {
        Field F = this.getField(column);
        if (ResultSetMetaData.isDecimalType(F.getSQLType())) {
            if (F.getDecimals() > 0) {
                return F.getLength() - 1;
            }
            return F.getLength();
        }
        return 0;
    }

    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    public int getScale(int column) throws SQLException {
        Field F = this.getField(column);
        if (ResultSetMetaData.isDecimalType(F.getSQLType())) {
            return F.getDecimals();
        }
        return 0;
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    public boolean isSigned(int column) throws SQLException {
        Field F = this.getField(column);
        int sql_type = F.getSQLType();
        switch (sql_type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return !F.isUnsigned();
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public String getTableName(int column) throws SQLException {
        return this.getField(column).getTableName();
    }

    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    protected Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column index out of range.", "S1002");
        }
        return this.Fields[columnIndex - 1];
    }

    private static final boolean isDecimalType(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }
}

