/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.RowData;
import java.sql.SQLException;

public class RowDataDynamic
implements RowData {
    private MysqlIO io;
    private byte[][] nextRow;
    private int columnCount;
    private int index = -1;
    private boolean isAtEnd = false;
    private boolean isAfterEnd = false;

    public RowDataDynamic(MysqlIO io, int colCount) throws SQLException {
        this.io = io;
        this.columnCount = colCount;
        this.nextRecord();
    }

    private void nextRecord() throws SQLException {
        try {
            if (!this.isAtEnd) {
                this.nextRow = this.io.nextRow(this.columnCount);
                if (this.nextRow == null) {
                    this.isAtEnd = true;
                }
            } else {
                this.isAfterEnd = true;
            }
        }
        catch (Exception e) {
            throw new SQLException("Error trying to fetch row:" + e.getMessage(), "S1000");
        }
    }

    public boolean hasNext() throws SQLException {
        boolean hasNext;
        boolean bl = hasNext = this.nextRow != null;
        if (!hasNext) {
            this.io.closeStreamer(this);
        }
        return hasNext;
    }

    public byte[][] next() throws SQLException {
        ++this.index;
        byte[][] ret = this.nextRow;
        this.nextRecord();
        return ret;
    }

    private void notSupported() throws SQLException {
        throw new OperationNotSupportedException();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.index < 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.isAfterEnd;
    }

    public void beforeFirst() throws SQLException {
        this.notSupported();
    }

    public void afterLast() throws SQLException {
        this.notSupported();
    }

    public void beforeLast() throws SQLException {
        this.notSupported();
    }

    public boolean isFirst() throws SQLException {
        this.notSupported();
        return false;
    }

    public boolean isLast() throws SQLException {
        this.notSupported();
        return false;
    }

    public void close() throws SQLException {
        while (this.hasNext()) {
            this.next();
        }
        this.io.closeStreamer(this);
    }

    public int getCurrentRowNumber() throws SQLException {
        this.notSupported();
        return -1;
    }

    public void setCurrentRow(int index) throws SQLException {
        this.notSupported();
    }

    public void moveRowRelative(int rows) throws SQLException {
        this.notSupported();
    }

    public boolean isDynamic() {
        return true;
    }

    public int size() {
        return -1;
    }

    public boolean isEmpty() throws SQLException {
        this.notSupported();
        return false;
    }

    public byte[][] getAt(int index) throws SQLException {
        this.notSupported();
        return null;
    }

    public void addRow(byte[][] row) throws SQLException {
        this.notSupported();
    }

    public void removeRow(int index) throws SQLException {
        this.notSupported();
    }

    class OperationNotSupportedException
    extends SQLException {
        OperationNotSupportedException() {
            super("Operation not supported for streaming result sets", "S1009");
        }
    }
}

