/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.RowData;
import java.util.ArrayList;

public class RowDataStatic
implements RowData {
    private ArrayList rows;
    private int index = -1;

    public RowDataStatic(ArrayList rows) {
        this.rows = rows;
    }

    public boolean hasNext() {
        boolean hasMore = this.index + 1 < this.rows.size();
        return hasMore;
    }

    public byte[][] next() {
        ++this.index;
        if (this.index < this.rows.size()) {
            return (byte[][])this.rows.get(this.index);
        }
        return null;
    }

    public void close() {
    }

    public boolean isBeforeFirst() {
        return this.index == -1;
    }

    public boolean isAfterLast() {
        return this.index >= this.rows.size();
    }

    public void beforeFirst() {
        this.index = -1;
    }

    public void beforeLast() {
        this.index = this.rows.size() - 2;
    }

    public void afterLast() {
        this.index = this.rows.size();
    }

    public boolean isFirst() {
        return this.index == 0;
    }

    public boolean isLast() {
        return this.index == this.rows.size() - 1;
    }

    public byte[][] getAt(int atIndex) {
        if (atIndex < 0 || atIndex > this.rows.size()) {
            return null;
        }
        return (byte[][])this.rows.get(atIndex);
    }

    public int getCurrentRowNumber() {
        return this.index;
    }

    public void setCurrentRow(int newIndex) {
        this.index = newIndex;
    }

    public void moveRowRelative(int rows) {
        this.index += rows;
    }

    public void addRow(byte[][] row) {
        this.rows.add(row);
    }

    public void removeRow(int atIndex) {
        this.rows.remove(atIndex);
    }

    public boolean isEmpty() {
        return this.rows.size() == 0;
    }

    public int size() {
        return this.rows.size();
    }

    public boolean isDynamic() {
        return false;
    }
}

