/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowDataStatic;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;

public class Statement
implements java.sql.Statement {
    protected ArrayList batchedArgs;
    protected Connection connection = null;
    protected int resultSetConcurrency = 0;
    protected int resultSetType = 0;
    String currentCatalog = null;
    boolean doEscapeProcessing = true;
    EscapeProcessor escaper = null;
    long lastInsertId = -1L;
    int maxFieldSize = MysqlIO.MAXBUF;
    int maxRows = -1;
    ResultSet nextResults = null;
    ResultSet results = null;
    int timeout = 0;
    long updateCount = -1L;
    SQLWarning warningChain = null;
    private int fetchSize = 0;
    private boolean isClosed = false;

    public Statement(Connection c, String catalog) throws SQLException {
        if (c == null || c.isClosedNoPing()) {
            throw new SQLException("Connection is closed.", "08003");
        }
        this.connection = c;
        this.escaper = new EscapeProcessor();
        this.currentCatalog = catalog;
        if (this.connection != null) {
            this.maxFieldSize = this.connection.getMaxAllowedPacket();
        }
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void setCursorName(String name) throws SQLException {
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.doEscapeProcessing = enable;
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw new SQLException("Illegal value for setFetchDirection()", "S1009");
            }
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows > this.getMaxRows() || rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("Illegal value for setFetchSize()", "S1009");
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", 4, 17)};
        ArrayList<byte[][]> rowSet = new ArrayList<byte[][]>();
        byte[][] row = new byte[][]{Long.toString(this.getLastInsertID()).getBytes()};
        rowSet.add(row);
        return new ResultSet(fields, new RowDataStatic(rowSet), this.connection);
    }

    public long getLastInsertID() {
        return this.lastInsertId;
    }

    public long getLongUpdateCount() {
        if (this.results == null) {
            return -1L;
        }
        if (this.results.reallyResult()) {
            return -1L;
        }
        return this.updateCount;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        int max_buf;
        if (max < 0) {
            throw new SQLException("Illegal value for setMaxFieldSize()", "S1009");
        }
        int n = max_buf = this.connection != null ? this.connection.getMaxAllowedPacket() : MysqlIO.MAXBUF;
        if (max > max_buf) {
            throw new SQLException("Can not set max field size > max allowed packet: " + max_buf, "S1009");
        }
        this.maxFieldSize = max;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max > 50000000 || max < 0) {
            throw new SQLException("setMaxRows() out of range. " + max + " > " + 50000000 + ".", "S1009");
        }
        if (max == 0) {
            max = -1;
        }
        this.maxRows = max;
        this.connection.maxRowsChanged();
    }

    public int getMaxRows() throws SQLException {
        if (this.maxRows <= 0) {
            return 0;
        }
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int current) throws SQLException {
        switch (current) {
            case 1: 
            case 2: 
            case 3: {
                if (this.results != null && (current == 3 || current == 1)) {
                    this.results.close();
                }
                this.results = this.nextResults;
                this.nextResults = null;
                return this.results != null && this.results.reallyResult();
            }
        }
        throw new SQLException("Illegal flag for getMoreResults(int)", "S1009");
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("Illegal value for setQueryTimeout()", "S1009");
        }
        this.timeout = seconds;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public synchronized java.sql.ResultSet getResultSet() throws SQLException {
        return this.results != null && this.results.reallyResult() ? this.results : null;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public synchronized int getUpdateCount() throws SQLException {
        if (this.results == null) {
            return -1;
        }
        if (this.results.reallyResult()) {
            return -1;
        }
        int truncated_updateCount = 0;
        truncated_updateCount = this.results.getUpdateCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.results.getUpdateCount();
        return truncated_updateCount;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    public synchronized void addBatch(String sql) throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        if (sql != null) {
            this.batchedArgs.add(sql);
        }
    }

    public void cancel() throws SQLException {
    }

    public synchronized void clearBatch() throws SQLException {
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public synchronized void close() throws SQLException {
        if (this.results != null) {
            try {
                this.results.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.results = null;
        this.connection = null;
        this.warningChain = null;
        this.escaper = null;
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean execute(String sql) throws SQLException {
        if (this.connection.isReadOnly() && sql != null) {
            int length = sql.length();
            int firstNonWsChar = 0;
            int i = 0;
            while (i < length) {
                char c = sql.charAt(i);
                if (!Character.isWhitespace(c)) {
                    firstNonWsChar = c;
                    break;
                }
                ++i;
            }
            if (firstNonWsChar != 83 && firstNonWsChar != 115) {
                throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
            }
        }
        this.checkClosed();
        if (this.doEscapeProcessing) {
            sql = this.escaper.escapeSQL(sql);
        }
        if (this.results != null) {
            this.results.close();
        }
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                char firstChar = Character.toUpperCase(sql.charAt(0));
                if (firstChar == 'S') {
                    if (sql.toUpperCase().indexOf("LIMIT") != -1) {
                        rs = this.connection.execSQL(sql, this.maxRows, this.resultSetConcurrency, this.createStreamingResultSet());
                    } else if (this.maxRows <= 0) {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                    } else {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1);
                    }
                } else {
                    this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                }
                rs = this.connection.execSQL(sql, -1, this.resultSetConcurrency, this.createStreamingResultSet());
            } else {
                rs = this.connection.execSQL(sql, -1, this.resultSetConcurrency, this.createStreamingResultSet());
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = rs.getUpdateID();
        if (rs != null) {
            this.results = rs;
        }
        rs.setConnection(this.connection);
        rs.setResultSetType(this.resultSetType);
        rs.setResultSetConcurrency(this.resultSetConcurrency);
        return rs != null && rs.reallyResult();
    }

    public boolean execute(String arg0, int arg1) throws SQLException {
        return this.execute(arg0);
    }

    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return this.execute(arg0);
    }

    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return this.execute(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.connection.isReadOnly()) {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        try {
            int[] updateCounts = null;
            if (this.batchedArgs != null) {
                int nbrCommands = this.batchedArgs.size();
                updateCounts = new int[nbrCommands];
                int i = 0;
                while (i < nbrCommands) {
                    updateCounts[i] = -3;
                    ++i;
                }
                SQLException sqlEx = null;
                int i2 = 0;
                while (i2 < nbrCommands) {
                    try {
                        updateCounts[i2] = this.executeUpdate((String)this.batchedArgs.get(i2));
                    }
                    catch (SQLException ex) {
                        sqlEx = ex;
                    }
                    ++i2;
                }
                if (sqlEx != null) {
                    throw new BatchUpdateException(sqlEx.getMessage(), sqlEx.getSQLState(), sqlEx.getErrorCode(), updateCounts);
                }
            }
            nArray = updateCounts != null ? updateCounts : new int[]{};
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        if (this.doEscapeProcessing) {
            sql = this.escaper.escapeSQL(sql);
        }
        if (this.results != null) {
            this.results.close();
        }
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                if (sql.toUpperCase().indexOf("LIMIT") != -1) {
                    this.results = this.connection.execSQL(sql, this.maxRows, this.resultSetConcurrency, this.createStreamingResultSet());
                } else {
                    if (this.maxRows <= 0) {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
                    } else {
                        this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1);
                    }
                    this.results = this.connection.execSQL(sql, -1, this.resultSetConcurrency, this.createStreamingResultSet());
                    if (oldCatalog != null) {
                        this.connection.setCatalog(oldCatalog);
                    }
                }
            } else {
                this.results = this.connection.execSQL(sql, -1, this.resultSetConcurrency, this.createStreamingResultSet());
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = this.results.getUpdateID();
        this.nextResults = this.results;
        this.results.setConnection(this.connection);
        this.results.setResultSetType(this.resultSetType);
        this.results.setResultSetConcurrency(this.resultSetConcurrency);
        this.results.setStatement(this);
        if (!this.results.reallyResult()) {
            if (!this.connection.getAutoCommit()) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new SQLException("Can not issue INSERT/UPDATE/DELETE with executeQuery()", "S1009");
        }
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int executeUpdate(String sql) throws SQLException {
        if (this.connection.isReadOnly()) {
            throw new SQLException("Connection is read-only. Queries leading to data modification are not allowed", "S1009");
        }
        this.checkClosed();
        if (this.doEscapeProcessing) {
            sql = this.escaper.escapeSQL(sql);
        }
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                this.connection.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1);
            }
            rs = this.connection.execSQL(sql, -1, 1007, false);
            rs.setConnection(this.connection);
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        if (rs.reallyResult()) {
            if (!this.connection.getAutoCommit()) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
            }
            rs.close();
            throw new SQLException("Results returned for UPDATE ONLY.", "01S03");
        }
        this.updateCount = rs.getUpdateCount();
        int truncated_updateCount = 0;
        truncated_updateCount = this.updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.updateCount;
        this.lastInsertId = rs.getUpdateID();
        return truncated_updateCount;
    }

    public int executeUpdate(String arg0, int arg1) throws SQLException {
        return this.executeUpdate(arg0);
    }

    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return this.executeUpdate(arg0);
    }

    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return this.executeUpdate(arg0);
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("No operations allowed after statement closed");
        }
    }

    void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    protected boolean createStreamingResultSet() {
        return this.resultSetType == 1003 && this.resultSetConcurrency == 1007 && this.fetchSize == Integer.MIN_VALUE;
    }
}

