/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.NotUpdatable;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowData;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;

public class UpdatableResultSet
extends ResultSet {
    private static String quotedIdChar = null;
    protected String deleteSQL = null;
    protected PreparedStatement deleter = null;
    protected String insertSQL = null;
    protected PreparedStatement inserter = null;
    protected ArrayList primaryKeyIndicies = null;
    protected String refreshSQL = null;
    protected PreparedStatement refresher;
    protected String updateSQL = null;
    protected PreparedStatement updater = null;
    protected boolean doingUpdates = false;
    protected boolean onInsertRow = false;
    protected boolean isUpdatable = false;

    public UpdatableResultSet(Field[] fields, RowData rows, Connection conn) throws SQLException {
        super(fields, rows, conn);
        this.isUpdatable = this.isUpdateable();
    }

    public UpdatableResultSet(Field[] fields, RowData rows) throws SQLException {
        super(fields, rows);
        this.isUpdatable = this.isUpdateable();
    }

    public UpdatableResultSet(long updateCount, long updateID) {
        super(updateCount, updateID);
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return super.isAfterLast();
    }

    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        return super.getAsciiStream(columnIndex);
    }

    public synchronized InputStream getAsciiStream(String columnName) throws SQLException {
        return super.getAsciiStream(columnName);
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return super.isBeforeFirst();
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return super.getBigDecimal(columnIndex, scale);
    }

    public synchronized BigDecimal getBigDecimal(String ColumnName, int scale) throws SQLException {
        return super.getBigDecimal(this.findColumn(ColumnName), scale);
    }

    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        return super.getBinaryStream(columnIndex);
    }

    public synchronized InputStream getBinaryStream(String columnName) throws SQLException {
        return super.getBinaryStream(columnName);
    }

    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        return super.getBoolean(columnIndex);
    }

    public synchronized boolean getBoolean(String ColumnName) throws SQLException {
        return super.getBoolean(this.findColumn(ColumnName));
    }

    public synchronized byte getByte(int columnIndex) throws SQLException {
        return super.getByte(columnIndex);
    }

    public synchronized byte getByte(String ColumnName) throws SQLException {
        return super.getByte(this.findColumn(ColumnName));
    }

    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        return super.getBytes(columnIndex);
    }

    public synchronized byte[] getBytes(String ColumnName) throws SQLException {
        return super.getBytes(this.findColumn(ColumnName));
    }

    public int getConcurrency() throws SQLException {
        return this.isUpdatable ? 1008 : 1007;
    }

    public synchronized String getCursorName() throws SQLException {
        return super.getCursorName();
    }

    public synchronized Date getDate(int columnIndex) throws SQLException {
        return super.getDate(columnIndex);
    }

    public synchronized Date getDate(String ColumnName) throws SQLException {
        return super.getDate(this.findColumn(ColumnName));
    }

    public synchronized double getDouble(int columnIndex) throws SQLException {
        return super.getDouble(columnIndex);
    }

    public synchronized double getDouble(String ColumnName) throws SQLException {
        return super.getDouble(this.findColumn(ColumnName));
    }

    public synchronized boolean isFirst() throws SQLException {
        return super.isFirst();
    }

    public synchronized float getFloat(int columnIndex) throws SQLException {
        return super.getFloat(columnIndex);
    }

    public synchronized float getFloat(String ColumnName) throws SQLException {
        return super.getFloat(this.findColumn(ColumnName));
    }

    public synchronized int getInt(int columnIndex) throws SQLException {
        return super.getInt(columnIndex);
    }

    public synchronized int getInt(String ColumnName) throws SQLException {
        return super.getInt(this.findColumn(ColumnName));
    }

    public synchronized boolean isLast() throws SQLException {
        return super.isLast();
    }

    public synchronized long getLong(int columnIndex) throws SQLException {
        return super.getLong(columnIndex);
    }

    public synchronized long getLong(String ColumnName) throws SQLException {
        return super.getLong(this.findColumn(ColumnName));
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        return super.getObject(columnIndex);
    }

    public synchronized Object getObject(String columnName) throws SQLException {
        return super.getObject(columnName);
    }

    public synchronized int getRow() throws SQLException {
        return super.getRow();
    }

    public synchronized short getShort(int columnIndex) throws SQLException {
        return super.getShort(columnIndex);
    }

    public synchronized short getShort(String ColumnName) throws SQLException {
        return super.getShort(this.findColumn(ColumnName));
    }

    public synchronized String getString(int columnIndex) throws SQLException {
        return super.getString(columnIndex);
    }

    public synchronized String getString(String ColumnName) throws SQLException {
        return super.getString(this.findColumn(ColumnName));
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        return super.getTime(columnIndex);
    }

    public synchronized Time getTime(String ColumnName) throws SQLException {
        return super.getTime(this.findColumn(ColumnName));
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        return super.getTimestamp(columnIndex);
    }

    public synchronized Timestamp getTimestamp(String ColumnName) throws SQLException {
        return super.getTimestamp(ColumnName);
    }

    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return super.getUnicodeStream(columnIndex);
    }

    public synchronized InputStream getUnicodeStream(String columnName) throws SQLException {
        return super.getUnicodeStream(columnName);
    }

    public synchronized boolean absolute(int row) throws SQLException {
        return super.absolute(row);
    }

    public synchronized void afterLast() throws SQLException {
        super.afterLast();
    }

    public synchronized void beforeFirst() throws SQLException {
        super.beforeFirst();
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.updater.clearParameters();
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public synchronized void close() throws SQLException {
        super.close();
    }

    public synchronized void deleteRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.onInsertRow) {
            throw new SQLException("Can not call deleteRow() when on insert row");
        }
        if (this.rowData.size() == 0) {
            throw new SQLException("Can't deleteRow() on empty result set");
        }
        if (this.isBeforeFirst()) {
            throw new SQLException("Before start of result set. Can not call deleteRow().");
        }
        if (this.isAfterLast()) {
            throw new SQLException("After end of result set. Can not call deleteRow().");
        }
        if (this.deleter == null) {
            if (this.deleteSQL == null) {
                this.generateStatements();
            }
            this.deleter = (PreparedStatement)this.connection.prepareStatement(this.deleteSQL);
        }
        this.deleter.clearParameters();
        String Encoding = null;
        if (this.connection.useUnicode()) {
            Encoding = this.connection.getEncoding();
        }
        try {
            int num_keys = this.primaryKeyIndicies.size();
            if (num_keys == 1) {
                int index = (Integer)this.primaryKeyIndicies.get(0);
                String CurrentVal = Encoding == null ? new String(this.thisRow[index]) : new String(this.thisRow[index], Encoding);
                this.deleter.setString(1, CurrentVal);
            } else {
                int i = 0;
                while (i < num_keys) {
                    int index = (Integer)this.primaryKeyIndicies.get(i);
                    String CurrentVal = Encoding == null ? new String(this.thisRow[index]) : new String(this.thisRow[index], Encoding);
                    this.deleter.setString(i + 1, CurrentVal);
                    ++i;
                }
            }
            this.deleter.executeUpdate();
            this.rowData.removeRow(this.rowData.getCurrentRowNumber());
        }
        catch (UnsupportedEncodingException UE) {
            throw new SQLException("Unsupported character encoding '" + this.connection.getEncoding() + "'");
        }
    }

    public synchronized boolean first() throws SQLException {
        return super.first();
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.onInsertRow) {
            throw new SQLException("Not on insert row");
        }
        this.inserter.executeUpdate();
        int numPrimaryKeys = 0;
        if (this.primaryKeyIndicies != null) {
            numPrimaryKeys = this.primaryKeyIndicies.size();
        }
        long autoIncrementId = this.inserter.getLastInsertID();
        int num_fields = this.fields.length;
        byte[][] NewRow = new byte[num_fields][];
        int i = 0;
        while (i < num_fields) {
            NewRow[i] = (byte[])(this.inserter.isNull(i) ? null : this.inserter.getBytes(i));
            if (numPrimaryKeys == 1 && this.fields[i].isPrimaryKey() && autoIncrementId > 0L) {
                NewRow[i] = String.valueOf(autoIncrementId).getBytes();
            }
            ++i;
        }
        this.rowData.addRow(NewRow);
        this.resetInserter();
    }

    public synchronized boolean last() throws SQLException {
        return super.last();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        this.onInsertRow = false;
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.inserter == null) {
            this.generateStatements();
            this.inserter = (PreparedStatement)this.connection.prepareStatement(this.insertSQL);
            this.resetInserter();
        } else {
            this.resetInserter();
        }
        this.onInsertRow = true;
        this.doingUpdates = false;
    }

    public synchronized boolean next() throws SQLException {
        return super.next();
    }

    public synchronized boolean prev() throws SQLException {
        return super.prev();
    }

    public synchronized boolean previous() throws SQLException {
        return super.previous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void refreshRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.onInsertRow) {
            throw new SQLException("Can not call refreshRow() when on insert row");
        }
        if (this.rowData.size() == 0) {
            throw new SQLException("Can't refreshRow() on empty result set");
        }
        if (this.isBeforeFirst()) {
            throw new SQLException("Before start of result set. Can not call refreshRow().");
        }
        if (this.isAfterLast()) {
            throw new SQLException("After end of result set. Can not call refreshRow().");
        }
        if (this.refresher == null) {
            if (this.refreshSQL == null) {
                this.generateStatements();
            }
            this.refresher = (PreparedStatement)this.connection.prepareStatement(this.refreshSQL);
        }
        this.refresher.clearParameters();
        String encoding = null;
        if (this.connection.useUnicode()) {
            encoding = this.connection.getEncoding();
        }
        try {
            int numKeys = this.primaryKeyIndicies.size();
            if (numKeys == 1) {
                byte[] dataFrom = null;
                int index = (Integer)this.primaryKeyIndicies.get(0);
                if (!this.doingUpdates) {
                    dataFrom = this.thisRow[index];
                } else {
                    dataFrom = this.updater.getBytes(index);
                    if (this.updater.isNull(index) || dataFrom.length == 0) {
                        dataFrom = this.thisRow[index];
                    }
                }
                String currentVal = encoding == null ? new String(dataFrom) : new String(dataFrom, encoding);
                this.refresher.setString(1, currentVal);
            } else {
                int i = 0;
                while (i < numKeys) {
                    byte[] dataFrom = null;
                    int index = (Integer)this.primaryKeyIndicies.get(i);
                    if (!this.doingUpdates) {
                        dataFrom = this.thisRow[index];
                    } else {
                        dataFrom = this.updater.getBytes(index);
                        if (this.updater.isNull(index) || dataFrom.length == 0) {
                            dataFrom = this.thisRow[index];
                        }
                    }
                    String currentVal = encoding == null ? new String(dataFrom) : new String(dataFrom, encoding);
                    this.refresher.setString(i + 1, currentVal);
                    ++i;
                }
            }
            java.sql.ResultSet rs = null;
            try {
                rs = this.refresher.executeQuery();
                int numCols = rs.getMetaData().getColumnCount();
                if (!rs.next()) throw new SQLException("refreshRow() called on row that has been deleted or had primary key changed", "S1000");
                int i = 0;
                while (i < numCols) {
                    byte[] val = rs.getBytes(i + 1);
                    this.thisRow[i] = (byte[])(val == null || rs.wasNull() ? null : rs.getBytes(i + 1));
                    ++i;
                }
                Object var8_13 = null;
                if (rs == null) return;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                rs.close();
                return;
            }
            catch (Exception ex) {}
            return;
        }
        catch (UnsupportedEncodingException UE) {
            throw new SQLException("Unsupported character encoding '" + this.connection.getEncoding() + "'");
        }
    }

    public synchronized boolean relative(int rows) throws SQLException {
        return super.relative(rows);
    }

    public synchronized boolean rowDeleted() throws SQLException {
        throw new NotImplemented();
    }

    public synchronized boolean rowInserted() throws SQLException {
        throw new NotImplemented();
    }

    public synchronized boolean rowUpdated() throws SQLException {
        throw new NotImplemented();
    }

    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setAsciiStream(columnIndex, x, length);
        } else {
            this.inserter.setAsciiStream(columnIndex, x, length);
        }
    }

    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBigDecimal(columnIndex, x);
        } else {
            this.inserter.setBigDecimal(columnIndex, x);
        }
    }

    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBinaryStream(columnIndex, x, length);
        } else {
            this.inserter.setBinaryStream(columnIndex, x, length);
        }
    }

    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new NotImplemented();
    }

    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new NotImplemented();
    }

    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBoolean(columnIndex, x);
        } else {
            this.inserter.setBoolean(columnIndex, x);
        }
    }

    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setByte(columnIndex, x);
        } else {
            this.inserter.setByte(columnIndex, x);
        }
    }

    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setBytes(columnIndex, x);
        } else {
            this.inserter.setBytes(columnIndex, x);
        }
    }

    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setCharacterStream(columnIndex, x, length);
        } else {
            this.inserter.setCharacterStream(columnIndex, x, length);
        }
    }

    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setDate(columnIndex, x);
        } else {
            this.inserter.setDate(columnIndex, x);
        }
    }

    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setDouble(columnIndex, x);
        } else {
            this.inserter.setDouble(columnIndex, x);
        }
    }

    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setFloat(columnIndex, x);
        } else {
            this.inserter.setFloat(columnIndex, x);
        }
    }

    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setInt(columnIndex, x);
        } else {
            this.inserter.setInt(columnIndex, x);
        }
    }

    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setLong(columnIndex, x);
        } else {
            this.inserter.setLong(columnIndex, x);
        }
    }

    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public synchronized void updateNull(int columnIndex) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setNull(columnIndex, 0);
        } else {
            this.inserter.setNull(columnIndex, 0);
        }
    }

    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setObject(columnIndex, x);
        } else {
            this.inserter.setObject(columnIndex, x);
        }
    }

    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setObject(columnIndex, x);
        } else {
            this.inserter.setObject(columnIndex, x);
        }
    }

    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public synchronized void updateRow() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        if (this.doingUpdates) {
            this.updater.executeUpdate();
            this.refreshRow();
            this.doingUpdates = false;
        }
        this.syncUpdate();
    }

    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setShort(columnIndex, x);
        } else {
            this.inserter.setShort(columnIndex, x);
        }
    }

    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setString(columnIndex, x);
        } else {
            this.inserter.setString(columnIndex, x);
        }
    }

    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setTime(columnIndex, x);
        } else {
            this.inserter.setTime(columnIndex, x);
        }
    }

    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (!this.onInsertRow) {
            if (!this.doingUpdates) {
                this.doingUpdates = true;
                this.syncUpdate();
            }
            this.updater.setTimestamp(columnIndex, x);
        } else {
            this.inserter.setTimestamp(columnIndex, x);
        }
    }

    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public synchronized boolean wasNull() throws SQLException {
        return super.wasNull();
    }

    protected void setResultSetConcurrency(int concurrencyFlag) {
        super.setResultSetConcurrency(concurrencyFlag);
        if (concurrencyFlag == 1008 && !this.isUpdateable()) {
            SQLWarning sQLWarning = new SQLWarning("Result Set not updateable. The query that generated this result set must select only one table, and must select all primary keys from that table. See the JDBC 2.1 API Specification, section 5.6 for more details.");
        }
    }

    protected void generateStatements() throws SQLException {
        if (!this.isUpdatable) {
            throw new NotUpdatable();
        }
        boolean useQuotedIdentifiers = this.connection.supportsQuotedIdentifiers();
        String quotedId = this.getQuotedIdChar();
        String TableName = this.fields[0].getTableName();
        this.primaryKeyIndicies = new ArrayList();
        StringBuffer FieldValues2 = new StringBuffer();
        StringBuffer KeyValues = new StringBuffer();
        StringBuffer ColumnNames = new StringBuffer();
        StringBuffer InsertPlaceHolders = new StringBuffer();
        boolean first_time = true;
        boolean keys_first_time = true;
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].isPrimaryKey()) {
                this.primaryKeyIndicies.add(new Integer(i));
                if (!keys_first_time) {
                    KeyValues.append(" AND ");
                } else {
                    keys_first_time = false;
                }
                if (useQuotedIdentifiers) {
                    KeyValues.append(quotedId);
                }
                KeyValues.append(this.fields[i].getName());
                if (useQuotedIdentifiers) {
                    KeyValues.append(quotedId);
                }
                KeyValues.append("=?");
            }
            if (first_time) {
                first_time = false;
                FieldValues2.append("SET ");
            } else {
                FieldValues2.append(",");
                ColumnNames.append(",");
                InsertPlaceHolders.append(",");
            }
            InsertPlaceHolders.append("?");
            if (useQuotedIdentifiers) {
                ColumnNames.append(quotedId);
            }
            ColumnNames.append(this.fields[i].getName());
            if (useQuotedIdentifiers) {
                ColumnNames.append(quotedId);
            }
            if (useQuotedIdentifiers) {
                FieldValues2.append(quotedId);
            }
            FieldValues2.append(this.fields[i].getName());
            if (useQuotedIdentifiers) {
                FieldValues2.append(quotedId);
            }
            FieldValues2.append("=?");
            ++i;
        }
        String quotedIdStr = useQuotedIdentifiers ? quotedId : "";
        this.updateSQL = "UPDATE " + quotedIdStr + TableName + quotedIdStr + " " + FieldValues2.toString() + " WHERE " + KeyValues.toString();
        this.insertSQL = "INSERT INTO " + quotedIdStr + TableName + quotedIdStr + " (" + ColumnNames.toString() + ") VALUES (" + InsertPlaceHolders.toString() + ")";
        this.refreshSQL = "SELECT " + ColumnNames.toString() + " FROM " + quotedIdStr + TableName + quotedIdStr + " WHERE " + KeyValues.toString();
        this.deleteSQL = "DELETE FROM " + quotedIdStr + TableName + quotedIdStr + " WHERE " + KeyValues.toString();
    }

    int getResultSetType() {
        return 0;
    }

    boolean isUpdateable() {
        int i;
        if (this.fields.length > 0) {
            String TableName = this.fields[0].getTableName();
            i = 1;
            while (i < this.fields.length) {
                if (TableName == null || !this.fields[i].getTableName().equals(TableName)) {
                    return false;
                }
                ++i;
            }
            if (TableName == null || TableName.length() == 0) {
                return false;
            }
        } else {
            return false;
        }
        boolean has_primary_key = false;
        i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].isPrimaryKey()) {
                has_primary_key = true;
                break;
            }
            ++i;
        }
        return has_primary_key;
    }

    void syncUpdate() throws SQLException {
        if (this.updater == null) {
            if (this.updateSQL == null) {
                this.generateStatements();
            }
            this.updater = (PreparedStatement)this.connection.prepareStatement(this.updateSQL);
        }
        int num_fields = this.fields.length;
        this.updater.clearParameters();
        int i = 0;
        while (i < num_fields) {
            if (this.thisRow[i] != null) {
                this.updater.setBytes(i + 1, this.thisRow[i]);
            } else {
                this.updater.setNull(i + 1, 0);
            }
            ++i;
        }
        int numKeys = this.primaryKeyIndicies.size();
        if (numKeys == 1) {
            int index = (Integer)this.primaryKeyIndicies.get(0);
            byte[] keyData = this.thisRow[(Integer)this.primaryKeyIndicies.get(0)];
            this.updater.setBytes(num_fields + 1, keyData);
        } else {
            int i2 = 0;
            while (i2 < numKeys) {
                byte[] currentVal = this.thisRow[(Integer)this.primaryKeyIndicies.get(i2)];
                if (currentVal != null) {
                    this.updater.setBytes(num_fields + i2 + 1, currentVal);
                } else {
                    this.updater.setNull(num_fields + i2 + 1, 0);
                }
                ++i2;
            }
        }
    }

    private synchronized String getQuotedIdChar() throws SQLException {
        if (quotedIdChar == null) {
            DatabaseMetaData dbmd = this.connection.getMetaData();
            quotedIdChar = dbmd.getIdentifierQuoteString();
        }
        return quotedIdChar;
    }

    private void resetInserter() throws SQLException {
        this.inserter.clearParameters();
        int i = 0;
        while (i < this.fields.length) {
            this.inserter.setNull(i + 1, 0);
            ++i;
        }
    }

    private void resetUpdater() throws SQLException {
        this.updater.clearParameters();
        int i = 0;
        while (i < this.fields.length) {
            this.updater.setNull(i + 1, 0);
            ++i;
        }
    }
}

