/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.jdbc2.optional;

import com.mysql.jdbc.Driver;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class MysqlDataSource
implements DataSource,
Referenceable,
Serializable {
    protected static Driver _MysqlDriver = null;
    protected boolean explicitUrl = false;
    protected String url = null;
    protected String _HostName = null;
    protected int _port = 3306;
    protected String _DatabaseName = null;
    protected String _Encoding = null;
    protected String _User = null;
    protected String _Password = null;
    protected PrintWriter _LogWriter = null;
    protected String _profileSql = "false";

    public Connection getConnection() throws SQLException {
        return this.getConnection(this._User, this._Password);
    }

    public Connection getConnection(String UserID, String Password) throws SQLException {
        Properties Props = new Properties();
        if (UserID == null) {
            UserID = "";
        }
        if (Password == null) {
            Password = "";
        }
        Props.put("user", UserID);
        Props.put("password", Password);
        Props.put("profileSql", this.getProfileSql());
        return this.getConnection(Props);
    }

    protected Connection getConnection(Properties Props) throws SQLException {
        String jdbcUrlToUse = null;
        if (!this.explicitUrl) {
            StringBuffer JDBCUrl = new StringBuffer("jdbc:mysql://");
            if (this._HostName != null) {
                JDBCUrl.append(this._HostName);
            }
            JDBCUrl.append(":");
            JDBCUrl.append(this._port);
            JDBCUrl.append("/");
            if (this._DatabaseName != null) {
                JDBCUrl.append(this._DatabaseName);
            }
            jdbcUrlToUse = JDBCUrl.toString();
        } else {
            jdbcUrlToUse = this.url;
        }
        return _MysqlDriver.connect(jdbcUrlToUse, Props);
    }

    public String getDatabaseName() {
        return this._DatabaseName;
    }

    public PrintWriter getLogWriter() {
        return this._LogWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public int getPort() {
        return this._port;
    }

    public String getProfileSql() {
        return this._profileSql;
    }

    public void setProfileSql(String flag) {
        this._profileSql = flag;
    }

    public Reference getReference() throws NamingException {
        String FactoryName = "com.mysql.jdbc.jdbc2.optional.MysqlDataSourceFactory";
        Reference Ref2 = new Reference(this.getClass().getName(), FactoryName, null);
        Ref2.add(new StringRefAddr("user", this.getUser()));
        Ref2.add(new StringRefAddr("password", this._Password));
        Ref2.add(new StringRefAddr("serverName", this.getServerName()));
        Ref2.add(new StringRefAddr("port", "" + this.getPort()));
        Ref2.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        Ref2.add(new StringRefAddr("profileSql", this.getProfileSql()));
        return Ref2;
    }

    public String getServerName() {
        return this._HostName;
    }

    public void setUrl(String url) {
        this.url = url;
        this.explicitUrl = true;
    }

    public String getUrl() {
        if (!this.explicitUrl) {
            String Url = "jdbc:mysql://";
            Url = Url + this.getServerName() + ":" + this.getPort() + "/" + this.getDatabaseName();
            return Url;
        }
        return this.url;
    }

    public void setURL(String url) {
        this.setUrl(url);
    }

    public String getURL() {
        return this.getUrl();
    }

    public String getUser() {
        return this._User;
    }

    public void setDatabaseName(String DBName) {
        this._DatabaseName = DBName;
    }

    public void setLogWriter(PrintWriter Output) throws SQLException {
        this._LogWriter = Output;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public void setPassword(String Pass) {
        this._Password = Pass;
    }

    public void setPort(int p) {
        this._port = p;
    }

    public void setPortNumber(int p) {
        this.setPort(p);
    }

    public void setServerName(String ServerName) {
        this._HostName = ServerName;
    }

    public void setUser(String UserID) {
        this._User = UserID;
    }

    static {
        try {
            _MysqlDriver = (Driver)Class.forName("com.mysql.jdbc.Driver").newInstance();
        }
        catch (Exception E) {
            throw new RuntimeException("Can not load Driver class com.mysql.jdbc.Driver");
        }
    }
}

