/*
 * Decompiled with CFR 0.152.
 */
package testsuite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;

public abstract class BaseTestCase
extends TestCase {
    protected Connection conn = null;
    protected ResultSet rs = null;
    protected Statement stmt = null;
    protected PreparedStatement pstmt = null;
    protected static String dbUrl = "jdbc:mysql:///test";

    public BaseTestCase(String name) {
        super(name);
        String newDbUrl = System.getProperty("com.mysql.jdbc.testsuite.url");
        if (newDbUrl != null && newDbUrl.trim().length() != 0) {
            dbUrl = newDbUrl;
        }
    }

    public void setUp() throws Exception {
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        this.conn = DriverManager.getConnection(dbUrl);
        this.stmt = this.conn.createStatement();
    }

    public void tearDown() throws Exception {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException SQLE) {
                // empty catch block
            }
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException SQLE) {
                // empty catch block
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

