/*
 * Decompiled with CFR 0.152.
 */
package testsuite.simple;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Assert;
import testsuite.BaseTestCase;

public class BlobTest
extends BaseTestCase {
    static byte[] testBlob = new byte[0x200000];

    public BlobTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new BlobTest("testBytesInsert").run();
        new BlobTest("testByteStreamInsert").run();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createTestTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.stmt.executeUpdate("DROP TABLE IF EXISTS BLOBTEST");
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.tearDown();
            throw throwable;
        }
        super.tearDown();
    }

    private void createTestTable() throws SQLException {
        try {
            this.stmt.executeUpdate("DROP TABLE BLOBTEST");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE TABLE BLOBTEST (pos int PRIMARY KEY auto_increment, blobdata LONGBLOB)");
    }

    public void testBytesInsert() throws SQLException {
        this.pstmt = this.conn.prepareStatement("INSERT INTO BLOBTEST(blobdata) VALUES (?)");
        this.pstmt.setBytes(1, testBlob);
        this.pstmt.execute();
        int rowsUpdated = this.pstmt.getUpdateCount();
        this.pstmt.clearParameters();
        this.doRetrieval();
    }

    public void testByteStreamInsert() throws SQLException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(testBlob);
        this.pstmt = this.conn.prepareStatement("INSERT INTO BLOBTEST(blobdata) VALUES (?)");
        this.pstmt.setBinaryStream(1, (InputStream)bIn, 0);
        this.pstmt.execute();
        int rowsUpdated = this.pstmt.getUpdateCount();
        this.pstmt.clearParameters();
        this.doRetrieval();
    }

    private void doRetrieval() throws SQLException {
        boolean passed = false;
        passed = false;
        String message = "";
        try {
            ResultSet rs = this.stmt.executeQuery("SELECT blobdata from BLOBTEST LIMIT 1");
            rs.next();
            byte[] retrBytes = rs.getBytes(1);
            if (retrBytes.length == testBlob.length) {
                int i = 0;
                while (i < testBlob.length) {
                    if (retrBytes[i] != testBlob[i]) {
                        int j = i - 10;
                        while (j < i + 10) {
                            System.out.print(retrBytes[j] + " ");
                            ++j;
                        }
                        System.out.println();
                        int j2 = i - 10;
                        while (j2 < i + 10) {
                            System.out.print(testBlob[j2] + " ");
                            ++j2;
                        }
                        System.out.println();
                        passed = false;
                        message = "Byte pattern differed at position " + i + " , " + retrBytes[i] + " != " + testBlob[i];
                        break;
                    }
                    passed = true;
                    ++i;
                }
            } else {
                passed = false;
                message = "retrBytes.length(" + retrBytes.length + ") != testBlob.length(" + testBlob.length + ")";
            }
            Assert.assertTrue((String)("Inserted BLOB data did not match retrieved BLOB data." + message), (boolean)passed);
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
    }

    static {
        int dataRange = 255;
        int i = 0;
        while (i < testBlob.length) {
            BlobTest.testBlob[i] = (byte)(Math.random() * (double)dataRange + -128.0);
            ++i;
        }
    }
}

