/*
 * Decompiled with CFR 0.152.
 */
package testsuite.simple;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.io.File;
import java.sql.Connection;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import junit.framework.Assert;
import testsuite.BaseTestCase;

public class DataSourceTest
extends BaseTestCase {
    private File tempDir;
    private Context ctx;

    public DataSourceTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new DataSourceTest("testDataSource").run();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.registerDataSource();
    }

    public void tearDown() throws Exception {
        this.ctx.unbind(this.tempDir.getAbsolutePath() + "/test");
        this.ctx.close();
        this.tempDir.delete();
        super.tearDown();
    }

    public void testDataSource() throws Exception {
        NameParser nameParser = this.ctx.getNameParser("");
        Name datasourceName = nameParser.parse(this.tempDir.getAbsolutePath() + "/test");
        Object obj = this.ctx.lookup(datasourceName);
        DataSource boundDs = null;
        if (obj instanceof DataSource) {
            boundDs = (DataSource)obj;
        } else if (obj instanceof Reference) {
            Reference objAsRef = (Reference)obj;
            ObjectFactory factory = (ObjectFactory)Class.forName(objAsRef.getFactoryClassName()).newInstance();
            boundDs = (DataSource)factory.getObjectInstance(objAsRef, datasourceName, this.ctx, new Hashtable());
        }
        Assert.assertTrue((String)"Datasource not bound", (boundDs != null ? 1 : 0) != 0);
        Connection con = boundDs.getConnection();
        con.close();
        Assert.assertTrue((String)"Connection can not be obtained from data source", (con != null ? 1 : 0) != 0);
    }

    private void registerDataSource() throws Exception {
        this.tempDir = File.createTempFile("jnditest", null);
        this.tempDir.delete();
        this.tempDir.mkdir();
        this.tempDir.deleteOnExit();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.fscontext.RefFSContextFactory");
        this.ctx = new InitialContext(env);
        Assert.assertTrue((String)"Naming Context not created", (this.ctx != null ? 1 : 0) != 0);
        MysqlDataSource ds = new MysqlDataSource();
        ds.setUrl(BaseTestCase.dbUrl);
        this.ctx.bind(this.tempDir.getAbsolutePath() + "/test", (Object)ds);
    }
}

