/*
 * Decompiled with CFR 0.152.
 */
package testsuite.simple;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import testsuite.BaseTestCase;

public class DateTest
extends BaseTestCase {
    public DateTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new DateTest("testTimestamp").run();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createTestTable();
    }

    private void createTestTable() throws SQLException {
        try {
            this.stmt.executeUpdate("DROP TABLE DATETEST");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE TABLE DATETEST (tstamp TIMESTAMP, dt DATE, dtime DATETIME, tm TIME)");
    }

    public void testTimestamp() throws SQLException {
        this.pstmt = this.conn.prepareStatement("INSERT INTO DATETEST(tstamp, dt, dtime, tm) VALUES (?, ?, ?, ?)");
        Calendar cal = Calendar.getInstance();
        cal.set(2, 6);
        cal.set(5, 3);
        cal.set(1, 2002);
        cal.set(10, 7);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(9, 0);
        cal.getTime();
        System.out.println(cal);
        DateFormat df = SimpleDateFormat.getInstance();
        Timestamp nowTstamp = new Timestamp(cal.getTime().getTime());
        Date nowDate = new Date(cal.getTime().getTime());
        Timestamp nowDatetime = new Timestamp(cal.getTime().getTime());
        Time nowTime = new Time(cal.getTime().getTime());
        System.out.println("** Times with given calendar (before storing) **\n");
        System.out.println("TIMESTAMP:\t" + nowTstamp.getTime() + " -> " + df.format(nowTstamp));
        System.out.println("DATE:\t\t" + nowDate.getTime() + " -> " + df.format(nowDate));
        System.out.println("DATETIME:\t" + nowDatetime.getTime() + " -> " + df.format(nowDatetime));
        System.out.println("TIME:\t\t" + nowTime.getTime() + " -> " + df.format(nowTime));
        System.out.println("\n");
        this.pstmt.setTimestamp(1, nowTstamp);
        this.pstmt.setDate(2, nowDate);
        this.pstmt.setTimestamp(3, nowDatetime);
        this.pstmt.setTime(4, nowTime);
        this.pstmt.execute();
        int rowsUpdated = this.pstmt.getUpdateCount();
        this.pstmt.clearParameters();
        this.rs = this.stmt.executeQuery("SELECT * from DATETEST");
        Date thenDate = null;
        while (this.rs.next()) {
            Timestamp thenTstamp = this.rs.getTimestamp(1);
            thenDate = this.rs.getDate(2);
            Timestamp thenDatetime = this.rs.getTimestamp(3);
            Time thenTime = this.rs.getTime(4);
            System.out.println("** Times with given calendar (retrieved from database) **\n");
            System.out.println("TIMESTAMP:\t" + thenTstamp.getTime() + " -> " + df.format(thenTstamp));
            System.out.println("DATE:\t\t" + thenDate.getTime() + " -> " + df.format(thenDate));
            System.out.println("DATETIME:\t" + thenDatetime.getTime() + " -> " + df.format(thenDatetime));
            System.out.println("TIME:\t\t" + thenTime.getTime() + " -> " + df.format(thenTime));
            System.out.println("\n");
        }
        System.out.println("Blah " + thenDate);
        this.rs.close();
        this.rs = null;
    }
}

