/*
 * Decompiled with CFR 0.152.
 */
package testsuite.simple;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import junit.framework.Assert;
import testsuite.BaseTestCase;

public class MetadataTest
extends BaseTestCase {
    public MetadataTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new MetadataTest("testGetPrimaryKeys").run();
        new MetadataTest("testForeignKeys").run();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createTestTable();
    }

    public void testForeignKeys() throws SQLException {
        String fkColumnName;
        String pkColumnName;
        DatabaseMetaData dbmd = this.conn.getMetaData();
        this.rs = dbmd.getImportedKeys(null, null, "child");
        while (this.rs.next()) {
            pkColumnName = this.rs.getString("PKCOLUMN_NAME");
            fkColumnName = this.rs.getString("FKCOLUMN_NAME");
            Assert.assertTrue((String)("Primary Key not returned correctly ('" + pkColumnName + "' != 'parent_id')"), (boolean)pkColumnName.equalsIgnoreCase("parent_id"));
            Assert.assertTrue((String)("Foreign Key not returned correctly ('" + fkColumnName + "' != 'parent_id')"), (boolean)fkColumnName.equalsIgnoreCase("parent_id"));
        }
        this.rs.close();
        this.rs = dbmd.getExportedKeys(null, null, "parent");
        while (this.rs.next()) {
            pkColumnName = this.rs.getString("PKCOLUMN_NAME");
            fkColumnName = this.rs.getString("FKCOLUMN_NAME");
            Assert.assertTrue((String)("Primary Key not returned correctly ('" + pkColumnName + "' != 'parent_id')"), (boolean)pkColumnName.equalsIgnoreCase("parent_id"));
            Assert.assertTrue((String)("Foreign Key not returned correctly ('" + fkColumnName + "' != 'parent_id')"), (boolean)fkColumnName.equalsIgnoreCase("parent_id"));
        }
        this.rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testGetPrimaryKeys() throws SQLException {
        try {
            DatabaseMetaData dbmd = this.conn.getMetaData();
            this.rs = dbmd.getPrimaryKeys(this.conn.getCatalog(), "", "multikey");
            short[] keySeqs = new short[4];
            String[] columnNames = new String[4];
            int i = 0;
            while (this.rs.next()) {
                String tableName = this.rs.getString("TABLE_NAME");
                columnNames[i] = this.rs.getString("COLUMN_NAME");
                String pkName = this.rs.getString("PK_NAME");
                keySeqs[i] = this.rs.getShort("KEY_SEQ");
                ++i;
            }
            if (keySeqs[0] != 3 && keySeqs[1] != 2 && keySeqs[2] != 4 && keySeqs[4] != 1) {
                Assert.fail((String)"Keys returned in wrong order");
            }
            Object var8_7 = null;
            if (this.rs == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (this.rs == null) throw throwable;
            try {
                this.rs.close();
                throw throwable;
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.rs.close();
            return;
        }
        catch (SQLException sqlEx) {}
    }

    private void createTestTable() throws SQLException {
        try {
            this.stmt.executeUpdate("DROP TABLE parent");
            this.stmt.executeUpdate("DROP TABLE child");
            this.stmt.executeUpdate("DROP TABLE multikey");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE TABLE parent(parent_id INT NOT NULL, PRIMARY KEY (parent_id)) TYPE=INNODB");
        this.stmt.executeUpdate("CREATE TABLE child(child_id INT, parent_id INT, INDEX par_ind (parent_id), FOREIGN KEY (parent_id) REFERENCES parent(parent_id)) TYPE=INNODB");
        this.stmt.executeUpdate("CREATE TABLE multikey(d INT NOT NULL, b INT NOT NULL, a INT NOT NULL, c INT NOT NULL, PRIMARY KEY (d, b, a, c))");
    }
}

